#include <string>
#include <list>
#include <vector>
#include <Shlwapi.h>
#include "main.h"
#include "patrecog.h"

#define MINAMP		0.1f
#define MINLENGTH 10
#define MAXSMOOTH 100

signed short GetSample(SWaveHdr *pHdr, char *pData, unsigned long nSample, unsigned long nChannel)
{
	unsigned long nBytesPerSample=pHdr->BitsPerSample/8;
	unsigned long nSamples=pHdr->dwDSize/(nBytesPerSample*pHdr->wChnls);
	if (nSample>=nSamples)
		return 0;
	signed short w;
	memcpy(&w, &(pData[nSample*(nBytesPerSample*pHdr->wChnls)+(nChannel*nBytesPerSample)]), 2);
	if (pHdr->BitsPerSample==8)
		w<<=8;
	return w;
}

void main(int argn, char *arg[])
{
	if (argn<2)
	{
		printf("ERROR: wrong argument-count !\n\n");
		printf("Syntax: CDLG [wavefile]\n");
		printf("Remarks: [wavefile] refers to the dialog-wavefile (wav). PHONEMES.PSF must be present in the same directory (use CPAT.EXE to create it).\n");
		return;
	}
	SWaveHdr WaveHeader;
	char *pData;
	std::string sName=arg[1];
	PathRemoveExtension(arg[1]);
	//sName+=".wav";
	printf("Loading %s...\n", sName.c_str());
	FILE *pFile=fopen(sName.c_str(), "rb");
	if (!pFile)
		return;
	if (!fread(&WaveHeader, sizeof(WaveHeader), 1, pFile))
	{
		fclose(pFile);
		return;
	}
	pData=(char*)malloc(WaveHeader.dwDSize);
	if (!fread(pData, WaveHeader.dwDSize, 1, pFile))
	{
		free(pData);
		fclose(pFile);
		return;
	}
	// try to include expressions from cue-points...
/*	std::list<std::string> lstExprName;
	std::list<std::string>::iterator lstExprNameIt;
	std::list<SExpr*> lstExpr;
	std::list<SExpr*>::iterator lstExprIt;
	lstExprName.clear();
	lstExpr.clear();
	// search for cue-header
	bool bTagFound=false;
	char sCUETag[4];
	fread(sCUETag, 4, 1, pFile);
	while ((!feof(pFile)) && (!bTagFound))
	{
		if ((sCUETag[0]=='c') &&
				(sCUETag[1]=='u') &&
				(sCUETag[2]=='e') &&
				(sCUETag[3]==' '))
		{
			bTagFound=true;
		}else
		{
			fseek(pFile, -3, SEEK_CUR);
			fread(sCUETag, 4, 1, pFile);
		}
	}
	if (bTagFound)
	{
		printf("Reading cue-points for facial-expression from wave-file...\n");
		std::vector<SCueLabel*> lstCueLabel;
		std::vector<SCueData*> lstCueData;
		std::vector<SCueData*>::iterator lstCueDataIt;
		lstCueLabel.clear();
		lstCueData.clear();
		int nDataSize;
		int nCuePoints;
		fread(&nDataSize, 4, 1, pFile);
		fread(&nCuePoints, 4, 1, pFile);
		for (int i=0;i<nCuePoints;i++)
		{
			SCueData *pCueData=new SCueData();
			lstCueData.push_back(pCueData);
			fread(pCueData, sizeof(SCueData), 1, pFile);
		}
		fread(sCUETag, 4, 1, pFile);
		if ((sCUETag[0]=='L') &&
				(sCUETag[1]=='I') &&
				(sCUETag[2]=='S') &&
				(sCUETag[3]=='T'))
		{
			fread(&nDataSize, 4, 1, pFile);
			unsigned long dwFileOfs=ftell(pFile);
			fread(sCUETag, 4, 1, pFile);
			if ((sCUETag[0]=='a') &&
					(sCUETag[1]=='d') &&
					(sCUETag[2]=='t') &&
					(sCUETag[3]=='l'))
			{
				while ((int)(ftell(pFile)-dwFileOfs)<nDataSize)
				{
					fread(sCUETag, 4, 1, pFile);
					if ((sCUETag[0]=='l') &&
							(sCUETag[1]=='a') &&
							(sCUETag[2]=='b') &&
							(sCUETag[3]=='l'))
					{
						int nTemp;
						fread(&nTemp, 4, 1, pFile);
						SCueLabel *pCueLabel=new SCueLabel();
						lstCueLabel.push_back(pCueLabel);
						fread(&(pCueLabel->nId), 4, 1, pFile);
						char c;
						i=0;
						do
						{
							fread(&c, 1, 1, pFile);
							pCueLabel->sName[i++]=c;
						}while (c!=0);
					}else
					if ((sCUETag[0]=='n') &&
							(sCUETag[1]=='o') &&
							(sCUETag[2]=='t') &&
							(sCUETag[3]=='e'))
					{
						int nTemp;
						fread(&nTemp, 4, 1, pFile);
						fread(&nTemp, 4, 1, pFile);
						for (i=0;i<(int)lstCueLabel.size();i++)
						{
							if (lstCueLabel[i]->nId==nTemp)
							{
								nTemp=i;
								goto found;
							}
						}
found:
						SCueLabel *pCueLabel=lstCueLabel[nTemp];
						char c;
						i=0;
						do
						{
							fread(&c, 1, 1, pFile);
							if (pCueLabel)
								pCueLabel->sNote[i++]=c;
						}while (c!=0);
						fread(&c, 1, 1, pFile);
					}
				}
			}
		}
		// extract information and embed
		printf("dumping %i facial-expressions...\n", lstCueData.size());
		lstCueDataIt=lstCueData.begin();
		while (lstCueDataIt!=lstCueData.end())
		{
			int nExprId=0;
			for (i=0;i<(int)lstCueLabel.size();i++)
			{
				if (lstCueLabel[i]->nId==(*lstCueDataIt)->nId)
				{
					nExprId=i;
					goto found2;
				}
			}
found2:
			int nId=0;
			lstExprNameIt=lstExprName.begin();
			while (lstExprNameIt!=lstExprName.end())
			{
				if (strcmp( (*lstExprNameIt).c_str(), ( lstCueLabel[nExprId] )->sName )==0)
					goto dontadd;
				nId++;
				lstExprNameIt++;
			}
			lstExprName.push_back( ( lstCueLabel[nExprId] )->sName );
	dontadd:;
			char *pszName=( lstCueLabel[nExprId] )->sName;
			char *pszNote=( lstCueLabel[nExprId] )->sNote;
			char *pszSubStr;
			int nAttack=0, nSustain=0, nRelease=0;
			float fBlend=1.0f;
			pszSubStr=strstr(pszNote, "A ");
			if (pszSubStr)
				nAttack=(int)(atof(pszSubStr + 2) * (double)WaveHeader.dwSRate);
			pszSubStr=strstr(pszNote, "S ");
			if (pszSubStr)
				nSustain=(int)(atof(pszSubStr + 2) * (double)WaveHeader.dwSRate);
			pszSubStr=strstr(pszNote, "R ");
			if (pszSubStr)
				nRelease=(int)(atof(pszSubStr + 2) * (double)WaveHeader.dwSRate);
			pszSubStr=strstr(pszNote, "B ");
			if (pszSubStr)
				fBlend=(float)atof(pszSubStr + 2);
			lstExpr.push_back(new SExpr(nId, (*lstCueDataIt)->nSmpPos, nAttack, nSustain, nRelease, fBlend));
			delete (*lstCueDataIt);
			lstCueDataIt=lstCueData.erase(lstCueDataIt);
		}
		for (i=0;i<(int)lstCueLabel.size();i++)
		{
			delete (lstCueLabel[i]);
		}
		lstCueLabel.clear();
	}*/
	fclose(pFile);

	int nInputDataLen=(int)(WaveHeader.dwDSize/((WaveHeader.BitsPerSample/8)*WaveHeader.wChnls));
	float *pInputData=(float*)malloc(nInputDataLen*sizeof(float));
	for (int i=0;i<nInputDataLen;i++)
	{
		int w=0;
		for (int j=0;j<WaveHeader.wChnls;j++)
		{
			w+=GetSample(&WaveHeader, pData, i, j);
		}
		pInputData[i]=(float)w/(float)WaveHeader.wChnls/32768.0f;
	}
	free(pData);
	sName=arg[1];
	sName+=".lsf";
	CPatRecog PatRecog;
	PathRemoveFileSpec(arg[1]);
	std::string sPhonemeFile=arg[1];
	sPhonemeFile+="\\phonemes.psf";
	printf("Loading phoneme-set %s...\n", sPhonemeFile.c_str());
	PatRecog.LoadPatternSet(sPhonemeFile.c_str());
	printf("Analyzing %s...\n\n", sName.c_str());
	int nOfs=0;
	int nLastPhoneme=-1;
	int nLastPhonemeCount=0;
	float fError;
	unsigned long dwStartTime=GetTickCount();
	std::list<SEvent*> lstEvents;
	std::list<SEvent*>::iterator lstEventsIt;
	lstEvents.clear();
	lstEvents.push_back(new SEvent(0, -1, 0.0f));
	float fAmp;
	int n;
	while (nOfs<nInputDataLen)
	{
		n=PatRecog.Analyze(&(pInputData[nOfs]), nInputDataLen-nOfs, MINAMP, &fError, &fAmp);
		if (n<0)
				n=-1;
		if (n!=nLastPhoneme)
		{
			if (n>=0)
			{
				printf("(%08d)\t---  (%3.2f%% done)\n%s (Err: %5.5f; Vol: %5.5f) ", nLastPhonemeCount, ((float)nOfs/(float)nInputDataLen)*100.0f, PatRecog.Pattern[n].sName, fError, fAmp);
			}else if (n==-1)
			{
//				printf("(%08d)\n*** NO PATTERN *** ", nLastPhonemeCount);
//			}else if (n==-2)
//			{
				printf("(%08d)\t---  (%3.2f%% done)\n*** SILENCE ***                  ", nLastPhonemeCount, ((float)nOfs/(float)nInputDataLen)*100.0f);
			}
			if (!lstEvents.empty())
				(*(lstEvents.rbegin()))->nLen=nLastPhonemeCount;
			lstEvents.push_back(new SEvent(nOfs, (signed char)n, fAmp));
			nLastPhoneme=n;
			nLastPhonemeCount=0;
		}
		nLastPhonemeCount++;
		nOfs+=64;//34;
	}
//	lstEvents.push_back(new SEvent(nInputDataLen, (signed char)n, fAmp));
	// smooth results
	printf("\n\nsmoothing results\n");
	lstEventsIt=lstEvents.begin();
	std::list<SEvent*>::iterator lstLastEventsIt=NULL;
	SEvent *pLastEvent=NULL;
	int nTotLen=0;
	int nMerged=0;
	int nLastMerges=0;
	int nEvent=0;
	int *pnCount=new int[PatRecog.nPatterns+1];
	memset(pnCount, 0, sizeof(int)*PatRecog.nPatterns+1);
	while (lstEventsIt!=lstEvents.end())
	{
		SEvent *pEvent=(*lstEventsIt);
		bool bMerge=false;
		if (pEvent->nLen<MINLENGTH)
		{
			if (!nTotLen)
				lstLastEventsIt=lstEventsIt;
			nTotLen+=pEvent->nLen;
			nMerged++;
			nLastMerges++;
			int n=pEvent->nPat;
			if (n<0)
				n=PatRecog.nPatterns;
			pnCount[n]+=pEvent->nLen;
			if (nTotLen>MAXSMOOTH)
				bMerge=true;
		}else
			bMerge=true;
		if (bMerge)
		{
			if (nTotLen)
			{
				// predict the real pattern
				SEvent *pNextEvent=NULL;
				std::list<SEvent*>::iterator lstNextIt=lstEventsIt;
				lstNextIt++;
				if (lstNextIt!=lstEvents.end())
				{
					pNextEvent=(*lstNextIt);
				}
				// calc which pattern is used most
				int nPat=0;
				int nMax=0;
				for (int i=0;i<PatRecog.nPatterns+1;i++)
				{
					if (pnCount[i]>nMax)
					{
						nMax=pnCount[i];
						nPat=i;
					}
				}
				// remove unneccessary shit...
				if (nPat==PatRecog.nPatterns)
					nPat=-1;
				for (i=0;i<nLastMerges;i++)
				{
					delete (*lstLastEventsIt);
					lstLastEventsIt=lstEvents.erase(lstLastEventsIt);
				}
				lstEventsIt=lstLastEventsIt;
			}
			pLastEvent=pEvent;
			nTotLen=0;
			nLastMerges=0;
			memset(pnCount, 0, sizeof(int)*PatRecog.nPatterns+1);
			nEvent++;
		}
		lstEventsIt++;
	}
	delete[] pnCount;
	// delete duplicate events
	lstEventsIt=lstEvents.begin();
	int nLastLen=0;
	float fLastAmp=0.0f;
	pLastEvent=NULL;
	while (lstEventsIt!=lstEvents.end())
	{
		SEvent *pEvent=(*lstEventsIt);
		if (pLastEvent)
		{
			if (pEvent->nPat==pLastEvent->nPat)
			{
				pLastEvent->nLen+=pEvent->nLen;
				if (pEvent->fAmp>pLastEvent->fAmp)
					pLastEvent->fAmp=pEvent->fAmp;
				delete (*lstEventsIt);
				lstEventsIt=lstEvents.erase(lstEventsIt);
			}else
				lstEventsIt++;
		}else
			lstEventsIt++;
		pLastEvent=pEvent;
	}
	lstEvents.push_back(new SEvent(nInputDataLen, -1, 0.0f));
	// dump to file
	unsigned long dwEndTime=GetTickCount();
	printf("%d final events (%d merged)\n", lstEvents.size(), nMerged);
	printf("%d samples processed in %d milliseconds (%5.5f samples/second)\n", nOfs, dwEndTime-dwStartTime, (float)nOfs/((float)(dwEndTime-dwStartTime)/1000.0f));
	printf("Saving to file...\n");
	pFile=fopen(sName.c_str(), "wb");
	if (!pFile)
		return;
	// lets write the header
	fwrite(&(PatRecog.nPatterns), 4, 1, pFile);
	for (i=0;i<PatRecog.nPatterns;i++)
	{
		unsigned char c=strlen(PatRecog.Pattern[i].sName);
		fwrite(&c, 1, 1, pFile);
		for (int j=0;j<c;j++)
		{
			fwrite(&(PatRecog.Pattern[i].sName[j]), 1, 1, pFile);
		}
	}
	lstEventsIt=lstEvents.begin();
	nOfs=lstEvents.size();
	fwrite(&nOfs, 4, 1, pFile);
	while (lstEventsIt!=lstEvents.end())
	{
		fwrite(&((*lstEventsIt)->nOfs), 4, 1, pFile);
		fwrite(&((*lstEventsIt)->nPat), 4, 1, pFile);
		fwrite(&((*lstEventsIt)->fAmp), 4, 1, pFile);
		delete (*lstEventsIt);
		lstEventsIt=lstEvents.erase(lstEventsIt);
	}
	// try to include expressions from script-file...
/*	sName=arg[1];
	sName+=".exp";
	FILE *pExprFile=fopen(sName.c_str(), "r");
	if (pExprFile)
	{
		printf("Reading expressions...\n");
		int nRet=1;
		char sExprName[256];
		float fStart, fAttack, fSustain, fRelease;
		int nStart, nAttack, nSustain, nRelease;
		float fBlend;
		do
		{
			nRet=fscanf(pExprFile, "%s%f%f%f%f%f", sExprName, &fStart, &fAttack, &fSustain, &fRelease, &fBlend);
			if (nRet==6)
			{
				nStart=(int)(fStart*(float)WaveHeader.dwSRate);
				nAttack=(int)(fAttack*(float)WaveHeader.dwSRate);
				nSustain=(int)(fSustain*(float)WaveHeader.dwSRate);
				nRelease=(int)(fRelease*(float)WaveHeader.dwSRate);
				int nId=0;
				lstExprNameIt=lstExprName.begin();
				while (lstExprNameIt!=lstExprName.end())
				{
					if ((*lstExprNameIt)==sExprName)
						goto alreadyadded;
					nId++;
					lstExprNameIt++;
				}
				lstExprName.push_back(sExprName);
alreadyadded:;
				lstExpr.push_back(new SExpr(nId, nStart, nAttack, nSustain, nRelease, fBlend));
			}
		}while (nRet==6);
		fclose(pExprFile);
	}
	nOfs=lstExprName.size();
	fwrite(&nOfs, 4, 1, pFile);
	lstExprNameIt=lstExprName.begin();
	while (lstExprNameIt!=lstExprName.end())
	{
		unsigned char nNameLen=(*lstExprNameIt).length();
		fwrite(&nNameLen, 1, 1, pFile);
		for (i=0;i<nNameLen;i++)
		{
			fwrite(&((*lstExprNameIt)[i]), 1, 1, pFile);
		}
		printf("Integrate expression %s...\n", (*lstExprNameIt).c_str());
		lstExprNameIt=lstExprName.erase(lstExprNameIt);
	}
	printf("Dumping %i expressions...\n", lstExpr.size());
	nOfs=lstExpr.size();
	fwrite(&nOfs, 4, 1, pFile);
	lstExprIt=lstExpr.begin();
	while (lstExprIt!=lstExpr.end())
	{
		SExpr *pExpr=(*lstExprIt);
		fwrite(&pExpr->nExpr, 1, 1, pFile);
		fwrite(&pExpr->nOfs, 4, 1, pFile);
		fwrite(&pExpr->nAttack, 4, 1, pFile);
		fwrite(&pExpr->nSustain, 4, 1, pFile);
		fwrite(&pExpr->nRelease, 4, 1, pFile);
		fwrite(&pExpr->fBlend, 4, 1, pFile);
		delete (*lstExprIt);
		lstExprIt=lstExpr.erase(lstExprIt);
	}*/
	fclose(pFile);
	free(pInputData);
	printf("Complete...");
	getch();
}