#include <windows.h>

#define MAXPATTERNS			64
#define MAXPEAKS				512

#define PEAKWINDOWSIZE	10
#define PEAKDIFF				20

struct SPeak
{
	int nIdx;
	float fAmp;
};

struct SPattern
{
	char sName[32];
	int nPeaks;
	SPeak Peak[MAXPEAKS];
	float fLastErrVal;
};

class CPatRecog
{
public:
	void CalcPeaks(float *AvgFFTData);
	int ApproximatePattern(float *pfError=NULL);
	float *FFTData;
	float *pFFTInput;
	int nPeaks;
	SPeak PeakWnd[PEAKWINDOWSIZE];
	int nPatterns;
	SPattern Pattern[MAXPATTERNS];
public:
	CPatRecog();
	~CPatRecog();
	int LoadPatternSet(const char *pszFilename);														// returns number of read patterns
	int Analyze(float *pInputData, int nInputDataLen, float fThreshold, float *pfError=NULL, float *pfAmp=NULL);		// returns the index of the recognized pattern, -1 if nothing is detected, -2 if signal is too low
};