#include <vector>

struct ChunkDesc
{
	CHUNK_HEADER hdr;
	int size;
	std::vector<char> data;

	ChunkDesc() {}
	ChunkDesc( const ChunkDesc& d ) { *this = d; }
	ChunkDesc& operator=( const ChunkDesc &d )
	{
		hdr = d.hdr;
		size = d.size;
		data = d.data;
		return *this;
	}
};

struct AnimRange
{
	int start;
	int end;
};

class ChunkFile
{
public:
	ChunkFile();
	~ChunkFile();

	bool Read( const char *file );
	bool Write( const char *file );

	void MergeAnim( const char *cafFile,const char *animFile,const char *animName,bool bExportNew=false );
	void SaveCalFile( const char *calFile );

private:
	bool ReadChunkTable( int ofs );
	void Close();

	ChunkDesc* FindChunkByType( int type );
	ChunkDesc* FindChunkById( int id );

	void LoadTimeChunk();
	void SaveTimeChunk();

	void LoadControllerKeys( ChunkDesc* cd,std::vector<CryBoneKey> &keys );
	void SaveControllerKeys( ChunkDesc* cd,std::vector<CryBoneKey> &keys );

	void MergeKeys( std::vector<CryBoneKey> &keys1,AnimRange range1,std::vector<CryBoneKey> &keys2,AnimRange range2 );

	TIMING_CHUNK_DESC timeChunk;

private:
	FILE*	m_file;
	int m_fileSize;

	FILE_HEADER m_fileHeader;
	std::vector<ChunkDesc> m_chunks;

	std::vector<RANGE_ENTITY> m_ranges;
};