//===========================================================================*\
//	Part of Crytek Character Studio and Object Export Plug-in
//
//  Copyright:  Cuneyt Ozdas 2000, 2001
//				 cuneyt@cuneytozdas.com
//===========================================================================*/

#include "stdafx.h"
#include "Utility.h"


#define CONFIG_VERSION_1 0x0953
#define CONFIG_VERSION_2 0x0954
#define CONFIG_VERSION_3 0x0955
#define CONFIG_MAGIC 0xC0FAF11E
struct CONFIG_FILE_1
{
	DWORD	ConfigMagic;
	int		ConfigVersion;

	//PB_NODES;
	BOOL	PB_ADD_RELATED;
	BOOL	PB_ADD_WHOLE_SKEL;
	BOOL	PB_EXPORT_MAT;
	BOOL	PB_ALLOW_MULTIUV;
	BOOL	PB_WRITE_WEIGHTS;
	BOOL	PB_WRITE_VCOL;
	int		PB_LINK_TYPE;
	BOOL	PB_WRITE_VA;
	int		PB_VERT_ANIM_RATE;

	//PB_BONES;
	BOOL	PB_BONE_ANIM_ATKEYS;
	BOOL	PB_BONE_ANIM_EVERY;
	int		PB_BONE_ANIM_RATE;
	BOOL	PB_IGNORE_DUMMY;
	BOOL	PB_CHILD_TIMES;
	BOOL	PB_PARENT_TIMES;
	BOOL	PB_STABILIZE_FEET;
	
	BOOL	PB_WARN_NONRIGID;
	BOOL	PB_WARN_ORPHAN_TV;
	BOOL	PB_WARN_DLL;
	BOOL	PB_WARN_MULTI_VCOL;
	BOOL	PB_WARN_OFFAXIS_SCL;

	BOOL	PB_MAN_RANGE;
	int		PB_RANGE_START;
	int		PB_RANGE_END;

	int		nNodes;
	int		nBones;

	//BOOL	PB_AUTO_SAVE;
};

struct CONFIG_FILE_2
{
	BOOL bEnableKeyCleanup;
	float fRotationPrecision;
	float fPositionPrecision;
};

struct CONFIG_FILE_3
{
	float fMorphMinOffset;
};

int CSExportUtility::ConfigSave(bool autosave)
{
	if(!pb_options) return 0;

	//save the state of the AutoSave option
	DWORD ass=pb_options->GetInt(PB_AUTO_SAVE);

	HKEY prefKey;
	DWORD	isOK;
	LONG res=RegCreateKeyEx(HKEY_CURRENT_USER,"Software\\CuneytOzdas\\CryTek Exporter",0,_T(""),REG_OPTION_NON_VOLATILE,KEY_READ | KEY_WRITE,NULL,&prefKey,&isOK);
	if(res==ERROR_SUCCESS)
	{
		RegSetValueEx(prefKey,"AutoSave"   ,0,REG_DWORD,(unsigned char *)&ass   ,sizeof(ass));
		RegCloseKey(prefKey);
	}
	
	//if called to autosave but autosave option is turned off exit now
	if(autosave && !ass) return 0;
	
	//save the other parameters' states to the file
	static char		FileName[256];
	OPENFILENAME	ofn;	
	FilterList		filter;
	char def_ext[16];
	filter.Append(_T("Crytek Config File (*.ccf)"));
	filter.Append(_T("*.ccf"));
	strcpy(def_ext,"ccf");
	FileName[0]=0;
	
	if(autosave)
	{
		strcpy(FileName,ip->GetDir(APP_PLUGCFG_DIR));
		strcat(FileName,"\\_default.ccf");
	}
	else
	{
		//Set dialog box options
		ofn.lStructSize       = sizeof(OPENFILENAME);
		ofn.hwndOwner         = hwnd_nodes;
		ofn.hInstance         = NULL;	
		ofn.lpstrTitle        = "Select Config File to Save";
		ofn.lpstrFilter       = filter;
		ofn.lpstrCustomFilter = NULL;
		ofn.nMaxCustFilter    = 0;
		ofn.nFilterIndex      = 1;
		ofn.lpstrFile         = FileName;
		ofn.nMaxFile          = sizeof(FileName)-1;
		ofn.lpstrFileTitle    = NULL;
		ofn.nMaxFileTitle     = 0;
		ofn.lpstrInitialDir   = ip->GetDir(APP_PLUGCFG_DIR);
		ofn.Flags             = OFN_OVERWRITEPROMPT|OFN_PATHMUSTEXIST|OFN_HIDEREADONLY;
		ofn.nFileOffset       = 0;
		ofn.nFileExtension    = 0;
		ofn.lpstrDefExt       = def_ext;
		ofn.lCustData         = 0;
		ofn.lpfnHook          = NULL;
		ofn.lpTemplateName    = NULL;

		if(!GetSaveFileName(&ofn))
		{
			return NULL; //cancelled (no error though, it is ok)
		}
	}

	FILE *f=fopen(FileName,"wb");
	if(!f) return 1;

	//
	CONFIG_FILE_1 cf;
	cf.ConfigMagic		= CONFIG_MAGIC;
	cf.ConfigVersion	= CONFIG_VERSION_3;

	cf.PB_ADD_RELATED		= pb_nodes->GetInt(PB_ADD_RELATED		);
	cf.PB_ADD_WHOLE_SKEL	= pb_nodes->GetInt(PB_ADD_WHOLE_SKEL	);
	cf.PB_EXPORT_MAT		= pb_nodes->GetInt(PB_EXPORT_MAT		);
	cf.PB_ALLOW_MULTIUV		= pb_nodes->GetInt(PB_ALLOW_MULTIUV		);
	cf.PB_WRITE_WEIGHTS		= pb_nodes->GetInt(PB_WRITE_WEIGHTS		);
	cf.PB_WRITE_VCOL		= pb_nodes->GetInt(PB_WRITE_VCOL		);
	cf.PB_LINK_TYPE			= pb_nodes->GetInt(PB_LINK_TYPE			);
	cf.PB_WRITE_VA			= pb_nodes->GetInt(PB_WRITE_VA			);
	cf.PB_VERT_ANIM_RATE	= pb_nodes->GetInt(PB_VERT_ANIM_RATE	);

	cf.PB_BONE_ANIM_ATKEYS	= pb_bones->GetInt(PB_BONE_ANIM_ATKEYS	);
	cf.PB_BONE_ANIM_EVERY	= pb_bones->GetInt(PB_BONE_ANIM_EVERY	);
	cf.PB_BONE_ANIM_RATE	= pb_bones->GetInt(PB_BONE_ANIM_RATE	);
	cf.PB_IGNORE_DUMMY		= pb_bones->GetInt(PB_IGNORE_DUMMY		);
	cf.PB_CHILD_TIMES		= pb_bones->GetInt(PB_CHILD_TIMES		);
	cf.PB_PARENT_TIMES		= pb_bones->GetInt(PB_PARENT_TIMES		);
	cf.PB_STABILIZE_FEET	= pb_bones->GetInt(PB_STABILIZE_FEET	);

	cf.PB_WARN_NONRIGID		= pb_options->GetInt(PB_WARN_NONRIGID	);
	cf.PB_WARN_ORPHAN_TV	= pb_options->GetInt(PB_WARN_ORPHAN_TV	);
	cf.PB_WARN_DLL			= pb_options->GetInt(PB_WARN_DLL		);
	cf.PB_WARN_MULTI_VCOL	= pb_options->GetInt(PB_WARN_MULTI_VCOL	);
	cf.PB_WARN_OFFAXIS_SCL	= pb_options->GetInt(PB_WARN_OFFAXIS_SCL	);

	cf.PB_MAN_RANGE			= pb_timing->GetInt(PB_MAN_RANGE		);
	cf.PB_RANGE_START		= pb_timing->GetInt(PB_RANGE_START		);
	cf.PB_RANGE_END			= pb_timing->GetInt(PB_RANGE_END		);

	cf.nNodes				= pb_nodes->Count(PB_NODES);
	cf.nBones				= pb_bones->Count(PB_BONES);
	
	res=fwrite(&cf,sizeof(cf),1,f);

	//save Node List
	char Name[256];
	for(int i=0;i<cf.nNodes;i++)
	{
		Name[0]=0;
		INode *node=pb_nodes->GetINode(PB_NODES,0,i);
		if(node) strcpy(Name,node->GetName());
	
		res=fwrite(&Name,sizeof(Name),1,f);
	}

	//save Bone List
	for(i=0;i<cf.nBones;i++)
	{
		Name[0]=0;
		INode *node=pb_bones->GetINode(PB_BONES,0,i);
		if(node) strcpy(Name,node->GetName());
	
		res=fwrite(&Name,sizeof(Name),1,f);
	}
	fflush(f);
	// save v2 options
	CONFIG_FILE_2 cf2;
	cf2.bEnableKeyCleanup = pb_bones->GetInt(PB_KEY_CLEANUP_ENABLE);
	cf2.fRotationPrecision = pb_bones->GetFloat(PB_KEY_CLEANUP_ROTATION);
	cf2.fPositionPrecision = pb_bones->GetFloat(PB_KEY_CLEANUP_POSITION);
	res = fwrite(&cf2, sizeof(cf2), 1, f);
	fflush(f);
	CONFIG_FILE_3 cf3;
	cf3.fMorphMinOffset = pb_nodes->GetFloat(PB_MORPH_MIN_OFFSET);
	res = fwrite (&cf3, sizeof(cf3), 1, f);

	fclose(f);

	return res;
}

int CSExportUtility::ConfigLoad(bool autosave)
{
	if(!pb_options) return 0;

	//Load the state of the AutoSave option
	int ass;
	HKEY prefKey;
	DWORD	size;
	LONG res=RegOpenKeyEx(HKEY_CURRENT_USER,"Software\\CuneytOzdas\\CryTek Exporter",0,KEY_ALL_ACCESS ,&prefKey);
	if(res==ERROR_SUCCESS)
	{
		RegQueryValueEx(prefKey,"AutoSave"   ,0,NULL,(unsigned char *)&ass   ,&size);
		pb_options->SetValue(PB_AUTO_SAVE	,0, ass);
		RegCloseKey(prefKey);
	}

	//load the other params from the file
	static char		FileName[256];
	OPENFILENAME	ofn;	
	FilterList		filter;
	char def_ext[16];
	filter.Append(_T("Crytek Config File (*.ccf)"));
	filter.Append(_T("*.ccf"));
	strcpy(def_ext,"ccf");
	FileName[0]=0;
	
	if(autosave)
	{
		strcpy(FileName,ip->GetDir(APP_PLUGCFG_DIR));
		strcat(FileName,"\\_default.ccf");
	}
	else
	{
		//Set dialog box options
		ofn.lStructSize       = sizeof(OPENFILENAME);
		ofn.hwndOwner         = hwnd_nodes;
		ofn.hInstance         = NULL;	
		ofn.lpstrTitle        = "Select Config File to Save";
		ofn.lpstrFilter       = filter;
		ofn.lpstrCustomFilter = NULL;
		ofn.nMaxCustFilter    = 0;
		ofn.nFilterIndex      = 1;
		ofn.lpstrFile         = FileName;
		ofn.nMaxFile          = sizeof(FileName)-1;
		ofn.lpstrFileTitle    = NULL;
		ofn.nMaxFileTitle     = 0;
		ofn.lpstrInitialDir   = ip->GetDir(APP_PLUGCFG_DIR);
		ofn.Flags             = OFN_PATHMUSTEXIST|OFN_FILEMUSTEXIST;
		ofn.nFileOffset       = 0;
		ofn.nFileExtension    = 0;
		ofn.lpstrDefExt       = def_ext;
		ofn.lCustData         = 0;
		ofn.lpfnHook          = NULL;
		ofn.lpTemplateName    = NULL;

		if(!GetOpenFileName(&ofn))
		{
			return NULL; //cancelled (no error though, it is ok)
		}
	}

	FILE *f=fopen(FileName,"rb");
	if(!f) return 1;

	CONFIG_FILE_1 cf;
	res=fread(&cf,sizeof(cf),1,f);

	if(res && (cf.ConfigMagic = CONFIG_MAGIC) && (cf.ConfigVersion>=CONFIG_VERSION_1))
	{

		pb_nodes->SetValue(PB_ADD_RELATED		,0, cf.PB_ADD_RELATED		);
		pb_nodes->SetValue(PB_ADD_WHOLE_SKEL	,0, cf.PB_ADD_WHOLE_SKEL	);
		pb_nodes->SetValue(PB_EXPORT_MAT		,0, cf.PB_EXPORT_MAT		);
		pb_nodes->SetValue(PB_ALLOW_MULTIUV		,0, cf.PB_ALLOW_MULTIUV		);
		pb_nodes->SetValue(PB_WRITE_WEIGHTS		,0, cf.PB_WRITE_WEIGHTS		);
		pb_nodes->SetValue(PB_WRITE_VCOL		,0, cf.PB_WRITE_VCOL		);
		pb_nodes->SetValue(PB_LINK_TYPE			,0, cf.PB_LINK_TYPE			);
		pb_nodes->SetValue(PB_WRITE_VA			,0, cf.PB_WRITE_VA			);
		pb_nodes->SetValue(PB_VERT_ANIM_RATE	,0, cf.PB_VERT_ANIM_RATE	);

		pb_bones->SetValue(PB_BONE_ANIM_ATKEYS	,0, cf.PB_BONE_ANIM_ATKEYS	);
		pb_bones->SetValue(PB_BONE_ANIM_EVERY	,0, cf.PB_BONE_ANIM_EVERY	);
		pb_bones->SetValue(PB_BONE_ANIM_RATE	,0, cf.PB_BONE_ANIM_RATE	);
		pb_bones->SetValue(PB_IGNORE_DUMMY		,0, cf.PB_IGNORE_DUMMY		);
		pb_bones->SetValue(PB_CHILD_TIMES		,0, cf.PB_CHILD_TIMES		);
		pb_bones->SetValue(PB_PARENT_TIMES		,0, cf.PB_PARENT_TIMES		);
		pb_bones->SetValue(PB_STABILIZE_FEET	,0, cf.PB_STABILIZE_FEET	);

		pb_options->SetValue(PB_WARN_NONRIGID	,0,	cf.PB_WARN_NONRIGID		);
		pb_options->SetValue(PB_WARN_ORPHAN_TV	,0,	cf.PB_WARN_ORPHAN_TV	);
		pb_options->SetValue(PB_WARN_DLL		,0,	cf.PB_WARN_DLL			);
		pb_options->SetValue(PB_WARN_MULTI_VCOL	,0,	cf.PB_WARN_MULTI_VCOL	);
		pb_options->SetValue(PB_WARN_OFFAXIS_SCL,0,	cf.PB_WARN_OFFAXIS_SCL	);

		pb_timing->SetValue(PB_MAN_RANGE		,0, cf.PB_MAN_RANGE			);
		pb_timing->SetValue(PB_RANGE_START		,0, cf.PB_RANGE_START		);
		pb_timing->SetValue(PB_RANGE_END		,0, cf.PB_RANGE_END			);
		
		//Load Node List
		if (cf.nNodes > 0)
		{
			char Name[256];
			pb_nodes->ZeroCount(PB_NODES);
			for(int i=0;i<cf.nNodes;i++)
			{
				res = fread(&Name,sizeof(Name),1,f);
				INode *node=ip->GetINodeByName(Name);
				if(node) pb_nodes->Append(PB_NODES,1,&node);
			}
		}

		//if add realated bones option is on, this will add the bones: so we do not need to do that
		char Name[256];
		if(!cf.PB_ADD_RELATED)
		{
			pb_bones->ZeroCount(PB_BONES);
			for (int i=0;i<cf.nBones;i++)
			{
				res=fread(&Name,sizeof(Name),1,f);
				INode *node=ip->GetINodeByName(Name);
				if(node) pb_bones->Append(PB_BONES,1,&node);
			}
		}
		else
			fseek (f,sizeof(Name)*cf.nBones,SEEK_CUR);

		// if this is a new format config, then read it
		if (cf.ConfigVersion >= CONFIG_VERSION_2)
		{
			CONFIG_FILE_2 cf2;
			res = fread(&cf2, sizeof(cf2), 1, f);
			if (res == 1)
			{
				pb_bones->SetValue (PB_KEY_CLEANUP_ENABLE, 0, cf2.bEnableKeyCleanup);
				pb_bones->SetValue (PB_KEY_CLEANUP_ROTATION, 0, cf2.fRotationPrecision);
				pb_bones->SetValue (PB_KEY_CLEANUP_POSITION, 0, cf2.fPositionPrecision);
			}
		}

		if (cf.ConfigVersion >= CONFIG_VERSION_3)
		{
			CONFIG_FILE_3 cf3;
			res = fread(&cf3, sizeof(cf3), 1, f);
			if (res == 1)
			{
				pb_nodes->SetValue (PB_MORPH_MIN_OFFSET, 0, cf3.fMorphMinOffset);
			}
		}
	}

	fclose(f);
	return res;
}