////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   cfgfile.h
//  Version:     v1.00
//  Created:     4/11/2002 by Timur.
//  Compilers:   Visual Studio.NET
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __cfgfile_h__
#define __cfgfile_h__
#pragma once

#include <list>
#include <string>
#include <vector>

class Config;

/** Configuration file class.
		Use format similar to windows .ini files.
*/
class CfgFile
{
public:
	// Config file entry structure, filled by readSection method.
	struct Entry {
		std::string key;
		std::string value;
	};

	// Ctors/Dtor.
	CfgFile();
	explicit CfgFile( const std::string &fileName );	// Automatically load new config file.
	CfgFile( const char *buf,int bufSize ); // Load config from memory buffer.
	~CfgFile();

	//////////////////////////////////////////////////////////////////////////
	bool Load( const std::string &fileName );	// Load configuration file.

	bool GetSection( const char *section,std::vector<Entry> &entries );

private:
	void	LoadBuf( const char *buf,int bufSize );

	struct Section
	{
		std::string name;	// Section name.
		std::list<Entry> entries;	// List of entries.
	};

	// Private methods.
	Section* FindSection( const std::string &section );

	// Private fields.
	std::string	m_fileName;	// Configuration file name.
	int			m_modified;	// Set to true if config file been modified.

	std::list<Section> m_sections;	// List of sections in config file.
};


#endif // __cfgfile_h__
