//===========================================================================*\
//	Part of Crytek Character Studio and Object Export Plug-in
//
//  Copyright:  Cuneyt Ozdas 2000, 2001
//				 cuneyt@cuneytozdas.com
//===========================================================================*/

#ifndef __CS_HEADERS_H__
#define __CS_HEADERS_H__

#pragma warning( once : 4244 4800)

//#pragma pack(push,1)

struct CryMatrix;	//prototype

// Mathematical Primitives ______________________________________________________________________________________________________
struct CryPoint3
{
	float x,y,z;

	CryPoint3() {}
	CryPoint3(float _x, float _y, float _z) {x=_x; y=_y; z=_z; }

	
	//operator bodies are in CryMath.cpp file
	CryPoint3 operator *(CryMatrix &m);
	CryPoint3 operator+(CryPoint3 b);
	CryPoint3 operator-(CryPoint3 b);
	CryPoint3 operator+=(CryPoint3 b);
	CryPoint3 operator*(float f);
	CryPoint3 operator^(CryPoint3 p); //cross product
	float     operator*(CryPoint3 p); //dot product
};

struct CryQuat
{
	float x,y,z,w;

	CryQuat() {}
	CryQuat(float _x, float _y, float _z, float _w) {x=_x; y=_y; z=_z; w=_w;}

	void Slerp(const CryQuat &p, const CryQuat &q, float t);
};

struct CryMatrix
{
	float		data[16];			//in GL format
	void		Build(const CryQuat &q, const CryPoint3 &p,const  CryPoint3 &s);
	void		Build(const CryQuat &q, const CryPoint3 &p);
	void		Multiply(const CryMatrix &m1, const CryMatrix &m2);
	void		Init();
	void		Translate(const CryPoint3 &off);
	void		Scale(float k); 
	void		RotateX(float a);
	void		RotateY(float a);
	void		RotateZ(float a);
};

// Geometric and Color Primitives ______________________________________________________________________________________________________
struct CryVertex
{
	CryPoint3 p;			//position
	CryPoint3 n;			//normal vector
};

struct CryFace
{
	int v0,v1,v2;			//vertex indices
	int MatID;				//mat ID
	int SmGroup;			//smoothing group
};

struct CryUV
{
	float u,v;				//texture coordinates
};

struct CryTexFace
{
	int t0,t1,t2;			//texture vertex indices
};

struct CryLink
{
	int			BoneID;
	CryPoint3	offset;
	float		Blending;
};

struct CryIRGB
{
	unsigned char r,g,b;
};

struct CryFRGB
{
	float r,g,b;
};

/*
struct CryQuadPatch
{
	int v[16];
};

struct CryTriPatch
{
	int v[12];
};

struct CryTexPatch
{
	int t0,t1,t2,t3;		//texture vertex indices
};
*/

// Keyframe and Timing Primitives __________________________________________________________________________________________________________________
struct BaseKey
{
	int time;
};

struct BaseTCB
{
	float t,c,b;
	float ein, eout;
};

struct BaseKey1 : BaseKey { float		val; };
struct BaseKey3 : BaseKey { CryPoint3	val; };
struct BaseKeyQ : BaseKey { CryQuat		val; };

struct CryLin1Key : BaseKey1 {};
struct CryLin3Key : BaseKey3 {};
struct CryLinQKey : BaseKeyQ {};
struct CryTCB1Key : BaseKey1 , BaseTCB {};
struct CryTCB3Key : BaseKey3 , BaseTCB {};
struct CryTCBQKey : BaseKeyQ , BaseTCB {};
struct CryBez1Key : BaseKey1 { float		intan, outtan; };
struct CryBez3Key : BaseKey3 { CryPoint3	intan, outtan; };
struct CryBezQKey : BaseKeyQ {};
struct CryBoneKey : BaseKey
{
	CryPoint3	abspos;
	CryPoint3	relpos;
	CryQuat		relquat;
};

struct RANGE_ENTITY
{
	char name[32];
	int start;
	int end;
};

// Material & Texture Primitives _____________________________________________________________________________________________________
enum TextureMappingType
{
	TEXMAP_NORMAL = 0,
	TEXMAP_ENVIRONMENT,
	TEXMAP_SCREENENVIRONMENT,
	TEXMAP_CUBIC,
	TEXMAP_AUTOCUBIC
};

enum TextureMappingFlags
{
	TEXMAP_NOMIPMAP = 0x01,
};


//////////////////////////////////////////////////////////////////////////
struct TextureMap
{
	char	path[128];	// Name and path of file.

	unsigned char	type;		// Mapping type.
	unsigned char flags;	// Texture map flags.
	unsigned char	ammount;// Ammopunt of blending (0-100).
	unsigned char	reserved[32];	// Some reserved variables.

	//tiling and mirror
	bool	utile;
	bool	umirror;
	bool	vtile;
	bool	vmirror;

	int		nthFrame;	// Update reflection every Nth frame.
	int		refSize;	// Reflection size.
	float	refBlur;	// Reflection blur.
	
	//texture position values
	float	uoff_val;
	float	uscl_val;
	float	urot_val;
	float	voff_val;
	float	vscl_val;
	float	vrot_val;
	float	wrot_val;

	//texture position controller chunk id's (if not animated they are -1)
	int	uoff_ctrlID;
	int	uscl_ctrlID;
	int	urot_ctrlID;
	int	voff_ctrlID;
	int	vscl_ctrlID;
	int	vrot_ctrlID;
	int	wrot_ctrlID;
};

// Other Primitives __________________________________________________________________________________________________________________
struct NAME_ENTITY
{
	char	name[64];
};

struct SCENEPROP_ENTITY
{
	char	name[32];
	char	value[64];
};

struct BONE_PHYSICS
{
	int		MeshID; // id of a separate mesh for this bone
	// additional joint parameters
	int		flags;
	float min[3],max[3];
	float spring_angle[3];
	float spring_tension[3];
	float damping[3];
	float framemtx[3][3];
};

struct BONE_ENTITY
{
	int		BoneID;
	int		ParentID;
	int		nChildren;

	// Id of controller (CRC32 From name of bone).
	unsigned int	ControllerID;

	char	prop[32];	// do not forget to update strncpy len
	BONE_PHYSICS phys;
};

struct MAT_ENTITY		//##OBSOLUTE##
{
	char	name[64];	//material name
	bool	IsStdMat;	//if false the below values are meaningless

	CryIRGB	col_d;		//diffuse color
	CryIRGB	col_s;		//specular color
	CryIRGB	col_a;		//ambiant color
	
	char	map_d[32];	//diffuse map file name
	char	map_o[32];	//opacity map file name
	char	map_b[32];	//bump map file name

	float	Dyn_Bounce;
	float	Dyn_StaticFriction;
	float	Dyn_SlidingFriction;
};

struct KEY_HEADER
{
	int		KeyTime;	//in ticks
};

//========================================
//File Headers
//========================================
#define FILE_SIGNATURE	"CryTek"

enum FileTypes { FileType_Geom = 0xFFFF0000, FileType_Anim};

struct FILE_HEADER
{
	char		Signature[7];
	FileTypes	FileType;
	int			Version;
	int			ChunkTableOffset;
};


#define GeomFileVersion		0x0744
#define AnimFileVersion		0x0744

//========================================
//Chunk Table Entity
//========================================
enum ChunkTypes
{
	ChunkType_ANY			= 0,
	ChunkType_Mesh			= 0xCCCC0000,
	ChunkType_Helper,
	ChunkType_VertAnim,
	ChunkType_BoneAnim,
	ChunkType_GeomNameList,	//Obsolute
	ChunkType_BoneNameList,
	ChunkType_MtlList,		//obsolute
	ChunkType_MRM,			//obsolute
	ChunkType_SceneProps,
	ChunkType_Light,
	ChunkType_PatchMesh,	//not implemented
	ChunkType_Node,
	ChunkType_Mtl,
	ChunkType_Controller,
	ChunkType_Timing,
	ChunkType_BoneMesh,
};

struct CHUNK_HEADER_0623
{
	ChunkTypes	ChunkType;
	int			ChunkVersion;
	int			FileOffset;
};

struct CHUNK_HEADER_0744
{
	ChunkTypes	ChunkType;
	int			ChunkVersion;
	int			FileOffset;
	int			ChunkID;		//new in version 0x0744

	CHUNK_HEADER_0744()
	{
		FileOffset = -1;
	}
};

typedef CHUNK_HEADER_0744 CHUNK_HEADER;



// SCENE RELATED CHUNKS_____________________________________________________________________________________________________________________
//========================================
//SceneProps Chunk Header
//========================================
struct SCENEPROPS_CHUNK_DESC_0201
{
	int		ChunkType;		//must be ChunkType_SceneProps
	int		ChunkVersion;
	int		nProps;
};

struct SCENEPROPS_CHUNK_DESC_0744
{
	CHUNK_HEADER	chdr;

	int		nProps;
};

typedef SCENEPROPS_CHUNK_DESC_0744 SCENEPROPS_CHUNK_DESC;
#define SCENEPROPS_CHUNK_DESC_VERSION 0x0744

//========================================
//Timing Chunk Header
//========================================
struct TIMING_CHUNK_DESC_0918
{
	CHUNK_HEADER	chdr;

	float			SecsPerTick;		// seconds/ticks
	int				TicksPerFrame;		// ticks/Frame

	RANGE_ENTITY	global_range;		// covers all of the time ranges
	int				nSubRanges;
};

typedef TIMING_CHUNK_DESC_0918 TIMING_CHUNK_DESC;
#define TIMING_CHUNK_DESC_VERSION 0x0918










// OBJECT RELATED CHUNKS____________________________________________________________________________________________________________________
//========================================
//Light Chunk Header
//========================================
enum LightTypes { LT_OMNI, LT_SPOT, LT_DIRECT, LT_AMBIENT };
struct LIGHT_CHUNK_DESC_0351
{
	int			ChunkType;		//must be ChunkType_Light
	int			ChunkVersion;	

	char		name[64];		// light name
    int			type;			// one of the LightTypes values
    bool 		on;				// light is on
	CryPoint3	pos;			// world position
	CryMatrix	tm;				// transformation matrix
	CryIRGB		color;			// RGB color
	float 		intens;			// multiplier value

	float 		hotsize;		// for spot and direct lights hotspot value
	float 		fallsize;		// for spot and direct lights falloff value
	bool		useNearAtten;	// near atten. on
	float		nearAttenStart;	// near attenuation ranges
	float		nearAttenEnd;
	bool   		useAtten;		// far atteniation
	float 		attenStart;		// far attenuation ranges
	float 		attenEnd;
	bool   		shadow;			// shadow is on
};

struct LIGHT_CHUNK_DESC_0744
{
	CHUNK_HEADER	chdr;

	LightTypes	type;			// one of the LightTypes values
    bool 		on;				// light is on
	CryIRGB		color;			// RGB color
	float 		intens;			// multiplier value

	float 		hotsize;		// for spot and direct lights hotspot value
	float 		fallsize;		// for spot and direct lights falloff value
	bool		useNearAtten;	// near atten. on
	float		nearAttenStart;	// near attenuation ranges
	float		nearAttenEnd;
	bool   		useAtten;		// far atteniation
	float 		attenStart;		// far attenuation ranges
	float 		attenEnd;
	bool   		shadow;			// shadow is on

	CryPoint3	vDirection;			//spot light direction
	char		szLightImage[256];	//spot light texture
};

typedef LIGHT_CHUNK_DESC_0744 LIGHT_CHUNK_DESC;
#define LIGHT_CHUNK_DESC_VERSION 0x0744

//========================================
//Helper Chunk Header
//========================================
enum HelperTypes
{
	HP_POINT=0,
	HP_DUMMY=1,
	HP_XREF=2,
	HP_CAMERA=3
};
struct HELPER_CHUNK_DESC_362
{
	int			ChunkType;		//must be ChunkType_Helper
	int			ChunkVersion;	

	char		name[64];		// helper name
    int			type;			// one of the HelperTypes values
	CryPoint3	pos;			// world position
	CryMatrix	tm;				// transformation matrix
};

struct HELPER_CHUNK_DESC_0744
{
	CHUNK_HEADER	chdr;

    HelperTypes	type;			// one of the HelperTypes values
	CryPoint3	size;			// size in local x,y,z axises (for dummy only)
};

typedef HELPER_CHUNK_DESC_0744 HELPER_CHUNK_DESC; 
#define HELPER_CHUNK_DESC_VERSION 0x0744	

//========================================
//Mesh Chunk Header
//========================================
struct MESH_CHUNK_DESC_0623
{
	int		ChunkType;		//must be ChunkType_Mesh
	int		ChunkVersion;
	int		GeomID;
	bool	HasBoneInfo;
	bool	HasVertexCol;
	bool	InWorldSpace;
	int		nVerts;
	int		nTVerts;		// # of texture vertices
	int		nFaces;
	int		MatID;
	int		PropStrLen;		//lenght of the property string
};

struct MESH_CHUNK_DESC_0744
{
	CHUNK_HEADER	chdr;

	bool	HasBoneInfo;
	bool	HasVertexCol;
	int		nVerts;
	int		nTVerts;		// # of texture vertices
	int		nFaces;
	int		VertAnimID;		// id of the related vertAnim chunk if present. otherwise it is -1
};
typedef MESH_CHUNK_DESC_0744 MESH_CHUNK_DESC;
#define MESH_CHUNK_DESC_VERSION 0x0744

//========================================
//MRM Chunk Header
//========================================
struct MRM_CHUNK_DESC_0201
{
	int		ChunkType;		//must be ChunkType_MRM
	int		ChunkVersion;
	int		GeomID;
};

struct MRM_CHUNK_DESC_0744
{
	CHUNK_HEADER	chdr;
	int				GeomID;	//id of the related mesh chunk
};

typedef MRM_CHUNK_DESC_0744 MRM_CHUNK_DESC; 
#define MRM_CHUNK_DESC_VERSION 0x0744


//========================================
//BezierPatch Chunk Header ##REMOVED##
//========================================
/*
enum PatchTypes { TRI_PATCH=3, QUAD_PATCH};
struct PATCHMESH_CHUNK_DESC
{
	int		ChunkType;		//must be ChunkType_Patch
	int		ChunkVersion;
	int		GeomID;
	bool	HasBoneInfo;
	bool	InWorldSpace;
	int		nVerts;
	int		nTVerts;		// # of texture vertices
	int		nPatches;
	int		MatID;
	int		PropStrLen;		//lenght of the property string
};
#define PATCHMESH_CHUNK_DESC_VERSION 0x0644
*/











// ANIMATION RELATED CHUNKS____________________________________________________________________________________________________________________
//========================================
//Vertex Anim Chunk Header
//========================================
struct VERTANIM_CHUNK_DESC_0201
{
	int		ChunkType;		// must be ChunkType_VertAnim
	int		ChunkVersion;
	bool	InWorldSpace;
	int		GeomID;			// node ID
	int		nKeys;			// # of keys
	int		nVerts;			// # of vertices this object has
	int		nFaces;			// # of faces this object has (for double check purpose)		
	float	SecsPerTick;	// seconds/ticks
	int		TicksPerFrame;	// ticks/Frame
};

struct VERTANIM_CHUNK_DESC_0744
{
	CHUNK_HEADER	chdr;

	int		GeomID;			// ID of the related mesh chunk
	int		nKeys;			// # of keys
	int		nVerts;			// # of vertices this object has
	int		nFaces;			// # of faces this object has (for double check purpose)		
};

typedef VERTANIM_CHUNK_DESC_0744 VERTANIM_CHUNK_DESC;
#define VERTANIM_CHUNK_DESC_VERSION 0x0744

//========================================
//Controller Chunk Header
//========================================
enum CtrlTypes 
{ 
	CTRL_NONE, 
	CTRL_CRYBONE, 
	CTRL_LINEER1,	CTRL_LINEER3,	CTRL_LINEERQ, 
	CTRL_BEZIER1,	CTRL_BEZIER3,	CTRL_BEZIERQ, 
	CTRL_TCB1,		CTRL_TCB3,		CTRL_TCBQ
};

struct CONTROLLER_CHUNK_DESC_0826
{
	CHUNK_HEADER	chdr;

	CtrlTypes		type;		//one ot the CtrlTypes values
	int				nKeys;		// # of keys this controller has

	int	nSubCtrl;	// # of sub controllers
	// CRC32 autogenerated from node name.
	unsigned int nControllerId;
};

typedef CONTROLLER_CHUNK_DESC_0826 CONTROLLER_CHUNK_DESC;
#define CONTROLLER_CHUNK_DESC_VERSION 0x0826

//========================================
//Bone Anim Chunk Header
//========================================
struct BONEANIM_CHUNK_DESC_0290
{
	int		ChunkType;		// must be ChunkType_BoneAnim
	int		ChunkVersion;
	float	SecsPerTick;	// seconds/ticks
	int		TicksPerFrame;	// ticks/Frame
	int		startframe;		// in frames
	int		endframe;		// in frames
};

struct BONEANIM_CHUNK_DESC_0825
{
	CHUNK_HEADER	chdr;

	int		nBones;
};

typedef BONEANIM_CHUNK_DESC_0825 BONEANIM_CHUNK_DESC;
#define BONEANIM_CHUNK_DESC_VERSION 0x0825











// LIST CHUNKS ____________________________________________________________________________________________________________________
//========================================
//GeomList Chunk Header ##OBSOLUTE##
//========================================
struct GEOMNAMELIST_CHUNK_DESC_0201
{
	int		ChunkType;		//must be ChunkType_GeomNameList
	int		ChunkVersion;
	int		nEntities;
};

typedef GEOMNAMELIST_CHUNK_DESC_0201 GEOMNAMELIST_CHUNK_DESC;
#define GEOMNAMELIST_CHUNK_DESC_VERSION 0x0201

//========================================
//Bonelist Chunk Header 
//========================================
struct BONENAMELIST_CHUNK_DESC_0201
{
	int		ChunkType;		//must be ChunkType_BoneNameList
	int		ChunkVersion;
	int		nEntities;
};

struct BONENAMELIST_CHUNK_DESC_0744
{
	CHUNK_HEADER chdr;
	int			 nEntities;
};
typedef BONENAMELIST_CHUNK_DESC_0744 BONENAMELIST_CHUNK_DESC;
#define BONENAMELIST_CHUNK_DESC_VERSION 0x0744

//========================================
//MtlList Chunk Header  ##OBSOLUTE##
//========================================
struct MTLLIST_CHUNK_DESC_0201
{
	int		ChunkType;		//must be ChunkType_MtlList
	int		ChunkVersion;
	int		nEntities;
};
typedef MTLLIST_CHUNK_DESC_0201 MTLLIST_CHUNK_DESC;
#define MTLLIST_CHUNK_DESC_VERSION 0x0201











// OTHER CHUNKS ____________________________________________________________________________________________________________________
//========================================
//Node Chunk Header
//========================================
struct NODE_CHUNK_DESC_0823
{
	CHUNK_HEADER	chdr;

	char		name[64];

	int			ObjectID;		// ID of this node's object chunk (if present)
	int			ParentID;		// chunk ID of the parent Node's chunk
	int			nChildren;		// # of children Nodes
	int			MatID;			// Material chunk No

	bool		IsGroupHead;	
	bool		IsGroupMember;

	CryMatrix	tm;				// transformation matrix
	CryPoint3	pos;			// pos component of matrix
	CryQuat		rot;			// rotation component of matrix
	CryPoint3	scl;			// scale component of matrix

	int			pos_cont_id;	// position controller chunk id
	int			rot_cont_id;	// rotation controller chunk id
	int			scl_cont_id;	// scale controller chunk id

	int			PropStrLen;		// lenght of the property string
};
typedef NODE_CHUNK_DESC_0823 NODE_CHUNK_DESC;
#define NODE_CHUNK_DESC_VERSION 0x0823

//========================================
//Material Chunk Header
//========================================
enum MtlTypes { MTL_UNKNOWN, MTL_STANDARD, MTL_MULTI, MTL_2SIDED};

enum MTL_CHUNK_FLAGS
{
	MTLFLAG_WIRE =		0x001,
	MTLFLAG_2SIDED =	0x002,
	MTLFLAG_FACEMAP = 0x004,
	MTLFLAG_FACETED = 0x008,
	MTLFLAG_ADDITIVE= 0x010,
	MTLFLAG_SUBTRACTIVE= 0x020,
};

struct MTL_CHUNK_DESC_0746
{
	CHUNK_HEADER	chdr;
	char			name[64];			//material/shader name 
	char			reserved[64];	// Some reserved bytes.
	MtlTypes		MtlType;	//one of the MtlTypes enum values
	
	union
	{
		struct
		{
			CryIRGB		col_d;		//diffuse color
			CryIRGB		col_s;		//specular color
			CryIRGB		col_a;		//ambient color
			float     specLevel; // Specular level.
      float     specShininess;
			float			selfIllum;	// self illumination.
			float			opacity;		// Opacity 0-1.
			
			TextureMap	tex_a;		//Ambient Texture settings
			TextureMap	tex_d;		//Diffuse Texture settings
			TextureMap	tex_s;		//Specular Texture settings
			TextureMap	tex_o;		//Opacity Texture settings
			TextureMap	tex_b;		//Bump Texture settings
      TextureMap	tex_g;		//Gloss Texture settings
      TextureMap	tex_fl;		//Filter texture (Detail Texture settings)
      TextureMap	tex_rl;		//Reflection Texture settings
			TextureMap	tex_rr;		//Refraction Texture settings
      TextureMap	tex_det;  //Displacment Texture settings

			int			flags;
			
			float		Dyn_Bounce;
			float		Dyn_StaticFriction;
			float		Dyn_SlidingFriction;
		};
		
		struct
		{
			int		nChildren;
		};
	};
};

typedef MTL_CHUNK_DESC_0746 MTL_CHUNK_DESC;
#define MTL_CHUNK_DESC_VERSION 0x0746

//#pragma pack(pop)

#endif
