#ifndef _CRY_MAX_EXPORTER_MODIFIER_UTILS_HDR_
#define _CRY_MAX_EXPORTER_MODIFIER_UTILS_HDR_

void PrintDebugModifiers (INode* pNode);
class MorphR3* FindMorpherModifier (INode* pNode);

// returns the reference to the (sometimes base) object before the physique, skin or morph modifier(s)
Object* GetObjectBeforeSkin (INode* pNode);

// returns the enabled skin and morpher modifiers
void GetSkinModifiers (INode* pNode, Tab<Modifier*>& arrModifiers);

// enables/disables the modifiers
void EnableModifiers (Tab<Modifier*>& arrModifiers, bool bEnable = true);

enum {g_nMaxMorphChannels = 100};

// Used to determine the physique modified object initial pose
// PARAMETERS:
//  pNode - the node to extract the information from (must have physique modifier assigned)
//  pVertices [OUT] - array with enough space to take the vertices; may be NULL
// RETURNS:
//  if pVertices == NULL : number of vertices to pass; 0 if no modifier found, or the geometry is empty
//  otherwise: the initial pose vertices in the array pointed to by pVertices; returns the number of vertices; 0 in case of an error
extern unsigned CalculatePhysiqueInitialPose (INode* pNode, Point3* pVertices);

// Calculates the initial position of each bone from arrBones, in context of
// physique modifier in pNode
// Returns the number of bone transformations got from physique, or 0 if not successful
// PARAMETERS:
//  pSkinNode    - the node that contains the skin
//  pBoneInitPos - [IN] Must be the buffer of at least arrBones.Count() elements
//                [OUT] the initial position of the bone
//
extern unsigned CalculateBoneInitPos (INode* pSkinNode, INodeTab& arrBones, Matrix3* pBoneInitPos);
extern unsigned CalculatePhysiqueBoneInitPos (INode* pSkinNode, Modifier *pPhysique, INodeTab& arrBones, Matrix3* pBoneInitPos);
extern unsigned CalculateSkinBoneInitPos (INode* pSkinNode, Modifier *pSkin, INodeTab& arrBones, Matrix3* pBoneInitPos);

extern Modifier* FindPhysiqueModifier(Object* ObjectPtr);
extern Modifier *FindSkinModifier(Object* ObjectPtr);

#endif