//===========================================================================*\
//	Part of Crytek Character Studio and Object Export Plug-in
//
//  Copyright:  Cuneyt Ozdas 2000, 2001
//				 cuneyt@cuneytozdas.com
//===========================================================================*/

#ifndef __RFXUTIL__H
#define __RFXUTIL__H

#include "stdafx.h"
#include "resource.h"
#include "NameList.h"
#include "VNormal.h"

#include "shtypes.h"

// IMPORTANT:
// The ClassID must be changed whenever a new project
// is created using this skeleton
#define	SKUTIL_CLASSID		Class_ID(0x13fb54aa, 0x13051305)


TCHAR *GetString(int id);
extern ClassDesc* GetCSExportUtilDesc();
StdUVGen *GetTextureStdUVGen(Texmap* tex);


// Paramblock2 name
enum 
{ 
	pbid_Nodes, 
	pbid_Bones, 
	pbid_Options,
	pbid_Timing,

	n_pblocks
}; 

// Paramblock2 parameter list
enum 
{ 
	PB_NODES,
	PB_ADD_RELATED,
	PB_ADD_WHOLE_SKEL,
	PB_EXPORT_MAT,
	PB_ALLOW_MULTIUV,
	PB_WRITE_WEIGHTS,
	PB_GENERATE_DEFAULT_UVS,
	PB_WRITE_VCOL,
	PB_LINK_TYPE,
	PB_WRITE_VA,
	PB_VERT_ANIM_RATE,
	PB_BUILDING,
	PB_INDIVIDUAL_FILES,
	PB_EXPORT_GEOM,
	PB_MORPH_MIN_OFFSET
};

enum 
{ 
	PB_BONES,
	PB_BONE_ANIM_ATKEYS,
	PB_CHILD_TIMES,
	PB_PARENT_TIMES,
	PB_STABILIZE_FEET,
	PB_BONE_ANIM_EVERY,
	PB_BONE_ANIM_RATE,
	PB_IGNORE_DUMMY,
	PB_KEY_CLEANUP_ENABLE,
	PB_KEY_CLEANUP_ROTATION,
	PB_KEY_CLEANUP_POSITION,
};

enum 
{ 
	PB_AUTO_SAVE,
	PB_WARN_NONRIGID,
	PB_WARN_ORPHAN_TV,
	PB_WARN_DLL,
	PB_WARN_MULTI_VCOL,
	PB_WARN_OFFAXIS_SCL,
};

enum
{
	PB_MAN_RANGE,
	PB_RANGE_START,
	PB_RANGE_END,
};

/*===========================================================================*\
 |	CSExportUtilClassDesc class defn
\*===========================================================================*/
class CSExportUtilClassDesc:public ClassDesc2 
{
	public:
	int 			IsPublic()					{ return TRUE; }
	void *			Create( BOOL loading );
	const TCHAR *	ClassName()					{ return GetString(IDS_CLASSNAME); }
	SClass_ID		SuperClassID()				{ return UTILITY_CLASS_ID; }
	Class_ID 		ClassID()					{ return SKUTIL_CLASSID; }
	const TCHAR* 	Category()					{ return GetString(IDS_CATEGORY);  }
	BOOL			NeedsToSave()				{ return TRUE; }
	IOResult		Save(ISave *s);
	IOResult		Load(ILoad *l);
	//void			ResetClassParams (BOOL fileReset);

	// Hardwired name, used by MAX Script as unique identifier
	const TCHAR*	InternalName()				{ return _T("CSExport"); }
	HINSTANCE		HInstance()					{ return hInstance; }

};
/*
struct MeshInfo
{
	Tab<Face>		Faces;
	Tab<Point3>	Verts;
	Tab<Point3>	Normals;
	Tab<Point3>	VColors;

	Tab<TVFace> TexFaces;
	Tab<UVVert> TexVerts;
};
*/

/*===========================================================================*\
 |	CSExportUtility class defn
\*===========================================================================*/
class CSExportUtility : public UtilityObj, public ReferenceMaker 
{
	public:
		IUtil*			iu;
		Interface*		ip;

		HIMAGELIST		ButtonImages;

		IParamBlock2*	pb_nodes;
		IParamBlock2*	pb_bones;
		IParamBlock2*	pb_options;
		IParamBlock2*	pb_timing;
		IParamMap2*		pmap_nodes;
		IParamMap2*		pmap_bones;
		HWND			hwnd_nodes;
		HWND			hwnd_bones;
		HWND			hwnd_about;

		NameList			BoneList;
		CHUNK_LIST			ChunkList;
		Tab<RANGE_ENTITY>	Ranges;

		std::vector<SBoneLightBind> m_arrLightBinding;
		void PrepareBoneLightBinding ();

		HWND hProgressWindow;
		HWND hProgressBar;
		TSTR lastSavedFile;
		bool m_bLastSavedIndividualFiles;
		TSTR m_strLastChosenSaveFile;
		unsigned m_numSkippedMorphTargets;

		TSTR animationName;
		bool bExportNew;
		bool bBuilding;

		LPITEMIDLIST m_pidlLast;
		
	
		//Constructor/Destructor
		CSExportUtility();
		~CSExportUtility();

		void			BeginEditParams		(Interface *ip,IUtil *iu);
		void			EndEditParams		(Interface *ip,IUtil *iu);
		void			DeleteThis			()			{}

		int				NumRefs				()			{ return n_pblocks; }
		RefTargetHandle GetReference		(int i);
		void			SetReference		(int i, RefTargetHandle rtarg);
		RefTargetHandle Clone				(RemapDir& remap = NoRemap());
		RefResult		NotifyRefChanged	(Interval changeInt,RefTargetHandle hTarget, PartID& partID, RefMessage message);

		int				NumParamBlocks		()			{ return n_pblocks; }			// return number of ParamBlocks in this instance
		IParamBlock2*	GetParamBlock		(int i);
		IParamBlock2*	GetParamBlockByID	(short id);

		//Common
		void			VariantToString		(const PROPVARIANT* pProp, TCHAR* szString, int bufSize);
		int				SaveFileDlg			(int FileType, char *filename=NULL, char *title=NULL, char *def_name=NULL);
		int				SaveDirDlg			(int FileType, char *filename=NULL, char *title=NULL, char *def_name=NULL);
		static int CALLBACK SaveDirDlg_BrowseCallbackProc
		(
			HWND hwnd, 
			UINT uMsg, 
			LPARAM lParam, 
			LPARAM lpData
		)
		{
			return ((CSExportUtility*)lpData)->SaveDirDlgCallback(hwnd, uMsg, lParam);
		}
		int SaveDirDlgCallback (HWND hwnd, UINT uMsg, LPARAM lParam);

		bool			WriteChunkList		(FILE *f, FILE_HEADER &header);
		void			CallExtensionDLLs	(char *fname, int Flags);
		int				ConfigSave			(bool autosave);
		int				ConfigLoad			(bool autosave);
		void			CleanUpIntTab		(IntTab &tab);
		void			EnableDisableControls();
		void			UpdateProgress		(int percent, char *c, ...);
		bool			SaveController		(FILE* f, Control* cont);
		bool			SaveTiming			(FILE* f);



		//Geom Export
		int				PrepareVertexColors	(CryIRGB *col, Mesh *mesh);
		int				CheckNodeProblems	(INode *node);
		void			RecursePrepareMtlChunks(Mtl* mtl);
		void			FillTextureInfo		(TextureMap3 &des, StdMat *mtl,int id);
		void 			FillStdMaterial( StdMat* mat,MTL_CHUNK_DESC_EXPORTER &chunk );
		void 			FillCrytekMaterial( StdMat2* mat,MTL_CHUNK_DESC_EXPORTER &chunk );
		void			CalcVertexNormals	(Tab<VNormal> &vnorms, Mesh *mesh, BOOL ConsiderSmoothing, BOOL negate=false, Point3* pVertexSubstitute = NULL);
		
		// Generate new mesh according to smoothing groups.
		// Duplicate vertices if normals not shared.
		void			SplitSmoothGroups( Mesh &mesh,Mesh &outMesh,std::vector<int> &arrVertexMap,BOOL negate=false , Point3* pActualVerts = NULL);

		// Generate the default texture coordinates for the mesh
		void GenerateDefaultUVs (Mesh& mesh);

		// generates a default material chunk if needed, and returns its index (in the numbering of standard materials)
		int getDefaultMtlIndex ();
		int m_nDefaultMtlChunkId, m_nDefaultMtlIndex;

		// saves the default material chunk, if needed
		bool SaveDefaultMaterial (FILE* f, bool bBuilding);

		void FillDefaultTextureInfo (TextureMap3 &dst, int id);


		INode*			DerObj2Node			(Object *obj);
		void SaveSourceInfo (FILE*f, int ChunkId);
		enum {
			// all are by default no
			nSMF_DontApplyObjOffset = 1,     // 
			nSMF_DontSaveBoneInfo   = 1<< 1, // 
			nSMF_IsBoneMeshChunk= 1<< 2,	 // should be set if the bone chunk is being saved
			nSMF_SaveMorphTargets   = 1<< 3, // should be set if the morph target chunks are also to be saved 
			nSMF_SaveInitBonePos    = 1<< 4  // if set, a chunk with initial bone positions is added
		};
		bool			SaveMeshObject		(FILE* f, INode* node, int ChunkId, INodeTab& arrBones, unsigned nFlags = 0);
		bool			SaveMeshObject_1  (FILE* f, INode* node, int ChunkId, INodeTab& arrBones, unsigned nFlags = 0);
		bool			SaveVertAnim		(FILE* f, INode *node);
		bool			SavePatchObject		(FILE* f, Object* der_obj);
		bool			SaveLightObject		(FILE* f, INode* der_obj);
		bool			SaveHelperObject	(FILE* f, INode* der_obj);
		bool			SaveNode( FILE* f, INode* node );
		bool			SaveSceneProps		(FILE* f);
		bool			SaveBoneNameList	(FILE* f);
		bool      SaveBoneInitialPos (FILE* f, INode* pSkin, INodeTab &arrBones, int nChunkIdMesh);
		// saves the light-bone binding info
		bool			SaveBoneLightBinding (FILE* f);
		bool			SaveMaterial		(FILE* f, Mtl* mat);

		int SaveGeomFile( TSTR fileName );
		bool			PreviewGeomFile( TSTR fileName );
		bool			PreviewGame( TSTR fileName );
		
		//Bone Export
		void			AddRelatedBones		();
		void			RemoveChildBones	(INode *parent);
		bool			IsFootPrint			(INode *bone);
		bool			IsLegBone			(INode *bone);
		bool			IsBipedBone			(INode *bone);
		bool			IsBipedRoot			(INode *bone);
		INode*			FindRootBone		(INode *node);
		INode*			FindLThigh			(INode *root, bool forward);
		INode*			FindRThigh			(INode *root, bool forward);

		//bool SaveBoneController (FILE *f, INode* node);
		bool			SaveBoneController (FILE *f, INode* node, IntTab *parentkeytimes=NULL);
		bool			SaveBoneHierarchy	(FILE *f, INodeTab &allnodes);
		bool			GetBoneNodeKeyTimes	(INode *node, IntTab &keytimes, INodeTab *children=NULL);
		
		// Given the list of key times, generate linear CryBoneKey's for all those times.
		void GetBoneNodeKeys (INode *pNode, const IntTab &tabKeyTimes, Tab<CryBoneKey> &tabOutKeys);
		
		bool			GetValidChildrenList(INode *node, INodeTab &children, bool recurse);
		int SaveBoneAnimFile	();

		TSTR			GetRelativePath( const TSTR &path );

		int				GetTime();
private:
protected:
	bool AddSkinRelatedBones(Modifier *skin, INode *node);
	bool SaveSkinInfo(FILE *f, INode *node, Modifier *m,  Point3 *Vertices,std::vector<int> &arrVertexMap );
	bool SaveBoneInfo(FILE *f, INode *node, Point3 *Vertices,std::vector<int> &arrVertexMap );
	bool SavePhysiqueInfo	(FILE* f, INode* node, Point3 *Verts,std::vector<int> &arrVertexMap);
	bool IsHaveBoneInfo( INode* node );

	bool SaveMorphTargets (FILE* f, INode* pNode, const Matrix3& tm, std::vector<int> &arrVertexMap, int nChunkIdMesh);

	// arrVertexMap maps compacted vertices -> original Max vertices (through the split vertices)
	// returns error bit
	bool SaveMorphTarget (FILE* f,const Matrix3& tm,  class morphChannel& rChannel, std::vector<int> &arrVertexMap, int nChunkIdMesh);
};

extern CSExportUtility theCSExportUtility;


/*===========================================================================*\
 |	Dialog Processors
\*===========================================================================*/
class OptionsDlgProc : public ParamMap2UserDlgProc 
{
	public:
	CSExportUtility *tsu;
	
	OptionsDlgProc(CSExportUtility *tsu_in) { tsu = tsu_in; }
	BOOL DlgProc(TimeValue t, IParamMap2 *map, HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	void DeleteThis() {delete this; }
};

class TimingDlgProc : public ParamMap2UserDlgProc 
{
	public:
	CSExportUtility *tsu;
	
	TimingDlgProc(CSExportUtility *tsu_in) { tsu = tsu_in; }
	BOOL DlgProc(TimeValue t, IParamMap2 *map, HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	void DeleteThis() {delete this; }
};
class NodesDlgProc : public ParamMap2UserDlgProc 
{
	public:
		CSExportUtility *tsu;

		NodesDlgProc() {}
		NodesDlgProc(CSExportUtility *tsu_in) { tsu = tsu_in; }

		BOOL DlgProc(TimeValue t, IParamMap2 *map, HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
		void DeleteThis() {delete this;  }

		void SetThing(ReferenceTarget *m) 
		{
			tsu = (CSExportUtility*)m;
		}
};

class BonesDlgProc : public ParamMap2UserDlgProc 
{
	public:
		CSExportUtility *tsu;

		BonesDlgProc() {}
		BonesDlgProc(CSExportUtility *tsu_in) { tsu = tsu_in; }

		BOOL DlgProc(TimeValue t, IParamMap2 *map, HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
		void DeleteThis() {delete this;  }

		void SetThing(ReferenceTarget *m) 
		{
			tsu = (CSExportUtility*)m;
		}
};
#endif