// Declaration of the class implementing CryBrowseForDir command
// facilitating user choise of the target directory for exporting multiple CGF files
#pragma once

// CmdBrowseForDir command
class CCmdBrowseForDir: public MPxCommand
{
public:
	CCmdBrowseForDir(void);
	~CCmdBrowseForDir(void);

	virtual MStatus	doIt ( const MArgList& );					
	
	static void*	creator()
	{
		return new CCmdBrowseForDir();
	}

	static MSyntax newSyntax();

protected:
	// parses the common arguments passed to the command
	virtual MStatus parseArgs (const MArgList& args);

	static int CALLBACK SaveDirDlg_BrowseCallbackProc
	(
		HWND hwnd, 
		UINT uMsg, 
		LPARAM lParam, 
		LPARAM lpData
	)
	{
		return ((CCmdBrowseForDir*)lpData)->SaveDirDlgCallback(hwnd, uMsg, lParam);
	}

	int SaveDirDlgCallback (HWND hwnd, UINT uMsg, LPARAM lParam);


protected:	
	MString m_strDirectory, m_strTitle;
};