///////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CmdExportCaf.h
// Declaration of class CCmdExportCaf,
// A proxy that implements the CryExportCaf command in Maya
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma once

#include "MayaUtils.h"
#include "CmdExportCryFile.h"

// class CCmdExportCaf 
// Exports the caf file, given the parameters in the text string.
// Extra Features included:
//  manual range
//  detection of skeleton by shape and vice versa
class CCmdExportCaf :
	public CCmdExportCryFile
{
public:
	CCmdExportCaf(void);
	~CCmdExportCaf(void);

	// does the actual job of executing the command
	virtual MStatus	doIt ( const MArgList& );					
	
	static void*	creator()
	{
		return new CCmdExportCaf();
	}
	// constructs a syntax object
	static MSyntax newSyntax();
protected:

	// parses the common arguments passed to the command (file name)
	MStatus parseArgs (const MArgList& args);

	// determines whether this joint is a root. This is needed to determine whether
	// to export it in the world space or in the space of its parent
	bool isRootJoint (const MDagPath& pathJoint);

	// exports the bone
	void exportSingleBone (const MDagPath& pathJoint);

	// exports the name entity array into a single chunk
	void exportNameEntities();

	// adds the exported bone name to the table of bone names that's exported together
	// with the other chunks. throws an error if the bone with such name has already been exported.
	void addNameEntity (const std::string& strBoneName);

	// prepares the array of shapes for export (fills the arrays in)
	void prepareObjectsToExport(const MSelectionList& listSelection);

	// 1. Prepares for export into controller chunks the bone and all its children.
	// 2. Collects the bone names in the name entity array.
	// 3. Ignores bones that have already been exported
	void prepareBoneHierarchyToExport(const MDagPath& pathJoint);

	// Determines the bones that may influence the given object (shape)
	// Returns true if at least one bone was found
	bool prepareNonBoneToExport (const MDagPath& pathDagNode);

	// logs the exported shape names
	void dumpExportedBones();
protected:// attributes

	// the set of bones having been exported
	std::set<std::string> m_setExportedBones;

	// the set of nodes TO EXPORT
	MDagPathSet m_setExportedJoints;
	MDagPathSet m_setDummiesToExport;

	// array of bone names that are used to export the name entity chunk
	typedef std::vector<std::string> StringArray;
	StringArray m_arrBoneNames;
};
