//
// This header declares class CCmdExportCryFile, a base for .c*f file exporter
// commands
//
#ifndef _MAYA_CRY_EXPORT_CMD_EXPORT_CRY_FILE_HDR_
#define _MAYA_CRY_EXPORT_CMD_EXPORT_CRY_FILE_HDR_

#include "CryHeaders.h"
#include "ChunkFileWriter.h"

//////////////////////////////////////////////////////////////////////////
// Class with the base functionality for exporter commands:
// parses arguments, clamps time, exports time chunk, understands and puts some arguments
// into the predefined member variables.
// 
class CCmdExportCryFile: public MPxCommand
{
public:
	// flags parsed by the MSyntax of this class
	static const char
		*g_szFlagFileLong,
		*g_szFlagFile,
		*g_szManualRangeStart,
		*g_szManualRangeStartLong,
		*g_szManualRangeEnd,
		*g_szManualRangeEndLong,
		*g_szFlagIgnoreBones,
		*g_szFlagIgnoreBonesLong,
		*g_szDontConvertCS,
		*g_szDontConvertCSLong,
		*g_szExportVertexColors,
		*g_szExportVertexColorsLong,
		*g_szConvertTGAtoDDS,
		*g_szConvertTGAtoDDSLong,
		*g_szIgnoreDummies,
		*g_szIgnoreDummiesLong,
		*g_szDontAllowMultiUV,
		*g_szDontAllowMultiUVLong,
		*g_szAnimationStep,
		*g_szAnimationStepLong,
		*g_szRotationPrecision,
		*g_szRotationPrecisionLong,
		*g_szPositionPrecision,
		*g_szPositionPrecisionLong,
		*g_szDisableKeyOptimization,
		*g_szDisableKeyOptimizationLong,
		*g_szIgnoreMaterials,
		*g_szIgnoreMaterialsLong,
		*g_szMaxWeightsPerLink,
		*g_szMaxWeightsPerLinkLong,
		*g_szProgressBarName,
		*g_szProgressBarNameLong,
		*g_szExportIndividualFiles,
		*g_szExportIndividualFilesLong
		;

	// constructs a syntax object
	static MSyntax newSyntax();
protected:
	// only the descendant may construct this object
	CCmdExportCryFile ();


	// parses the common arguments passed to the command (file name)
	virtual MStatus parseArgs (const MArgList& args);

	// exports the timing chunk (scene start/end times etc.)
	void exportTiming();

	// applies fixed rotation to the point, to convert from the Maya coordinate system (y up) to Cry coordinate system (z up)
	void convertMayaToCryCS (Vec3d& pt);

	// applies fixed rotation to the matrix, to convert from the Maya coordinate system (y up) to Cry coordinate system (z up)
	void convertMayaToCryCS (MMatrix& mx);

	// applies fixed rotation to the point and normal, to convert from the Maya coordinate system (y up) to Cry coordinate system (z up)
	void convertMayaToCryCS (CryVertex& cryVtx);

	// applies a fixed rotation to the position and orientation, to convert from the Maya coordinate system (y up) to Cry coordinate system (z up)
	void convertMayaToCryCS (CryBoneKey& cryBoneKey);

	void convertMayaToCryCS (CryQuat& qCry);

	// progress window/bar status signals, call these from the descendant

	// start progress indication;  
  void progressStart (const char* szTitle, unsigned nTotalSteps = 100);
	void progressIncrement(unsigned nStep = 1);
	void progressEnd();
	void progressThrowOnCancel();

	// executes a MEL command
	void executeCommand (const char* szCommand);

	// generates a unique chunk id
	int newChunkId();
protected:
	// the name of the file to export
	MString m_strFileName;

	// the file object to use for exporting
	CChunkFileWriterRefTgt_AutoPtr m_pFile;

	// the arguments
	//MArgDatabase m_ArgDB;

	// the start and end of the manual range
	MTime m_tManualRangeStart, m_tManualRangeEnd;
	bool m_bManualRangeStart, m_bManualRangeEnd;

	// do not export bones
	bool m_bIgnoreBones;

	// do not convert the Maya to Cry coordinate system
	bool m_bDontConvertCS;

	// do not allow array of UVs to be different from array of vertices by size
	bool m_bDontAllowMultiUV;

	// ignore the pure transform nodes
	bool m_bIgnoreDummies;

	// don't export materials
	bool m_bIgnoreMaterials;

	// indicates if the exported shape(s) will have the per-vertex color info
	bool m_bExportVertexColors;

	// if true, all files with .tga extension are converted into .dds files
	bool m_bConvertTGAtoDDS;

	// the step to take when exporting animation
	bool m_bAnimationStep;
	MTime m_tAnimationStep;

	bool m_bRotationPrecision;
	double m_dRotationPrecision;
	bool m_bPositionPrecision;
	double m_dPositionPrecision;

	bool m_bDisableKeyOptimization;

	// export multiple files into the same directory
	bool m_bExportIndividualFiles;

	unsigned m_nMaxWeightsPerLink;

	// the list of objects to export, passed in the command arguments
	MSelectionList m_lstSelection;

	// the progress bar 
	MString m_strProgressBar;
	int m_nIsProgressBarMain;

	// the next generated chunk Id
	int m_numChunkIdsGenerated;
};

#endif