// MayaCryExport.cpp : Defines the entry point for the Maya plugin.
// Initializes and registers the plugins, and initializes the log
//

#include "stdafx.h"
#include <maya/MFnPlugin.h>
#include "CmdExportCaf.h"
#include "CmdExportCgf.h"
#include "TranslatorCgf.h"
#include "TranslatorCaf.h"
#include "CmdExportUtil.h"
#include "CmdBrowseForDir.h"

HMODULE g_hModule = NULL;

BOOL APIENTRY DllMain( HMODULE hModule, 
                       DWORD  dwReason, 
                       LPVOID lpReserved )
{
	switch (dwReason)
	{
	case DLL_PROCESS_ATTACH:
		DisableThreadLibraryCalls(hModule);
		InitLog (hModule);
		g_hModule = hModule;
		return TRUE;
	}
	return TRUE;
}


MStatus initializePlugin ( MObject _obj )
{
	Log ("The plugin is initializing");
	MFnPlugin	plugin( _obj, "CryTek GmbH Germany", "1.2");				
	MStatus		status;											
	status = plugin.registerCommand ( "CryExportCaf", CCmdExportCaf::creator, CCmdExportCaf::newSyntax );
	if ( !status )
	{
		status.perror("registerCommand CryExportCaf");
		return status;
	}
	
	status = plugin.registerCommand ( "CryExportCgf", CCmdExportCgf::creator, CCmdExportCgf::newSyntax);
	if ( !status )												
	{
		status.perror("registerCommand CryExportCgf");
		return status;
	}

	status = plugin.registerCommand ( "CryBrowseForDir", CCmdBrowseForDir::creator, CCmdBrowseForDir::newSyntax);
	if ( !status )												
	{
		status.perror("registerCommand CryBrowseForDir");
		return status;
	}

	status = plugin.registerFileTranslator (
		"crytekGeometry",
		"MayaCryExportCGF.bmp",
		CTranslatorCgf::creatorCgf,
		"CryExportOptions \"CGF\"",
		"", // set the default options that are passed to the Options MEL
    false // set to true if executeCommand is needed in the reader
		);
	if (!status)
	{
		status.perror("registerFileTranslator crytekGeometry");
		return status;
	}

	status = plugin.registerFileTranslator (
		"crytekBuilding",
		"MayaCryExportCGF.bmp",
		CTranslatorCgf::creatorBld,
		"CryExportOptions \"CGF\" ",
		"exportAsBuilding=1;", // set the default options that are passed to the Options MEL
    false // set to true if executeCommand is needed in the reader
		);
	if (!status)
	{
		status.perror("registerFileTranslator crytekBuilding");
		return status;
	}

	status = plugin.registerFileTranslator (
		"crytekAnimation",
		"MayaCryExportCAF.bmp",
		CTranslatorCaf::creatorCaf,
		"CryExportOptions \"CAF\" ",
		"", // set the default options that are passed to the Options MEL
    false // set to true if executeCommand is needed in the reader
		);
	if (!status)
	{
		status.perror("registerFileTranslator crytekAnimation");
		return status;
	}

	status = plugin.registerCommand("CryExportUtil",CCmdExportUtil::creator,CCmdExportUtil::newSyntax);
	if (!status)
	{
		status.perror ("registerCommand CryExportUtil");
		return status;
	}

	return status;												
}																

MStatus uninitializePlugin( MObject _obj )						
{																
	MFnPlugin	plugin( _obj );									
	MStatus		status;											
	status = plugin.deregisterCommand( "CryExportCaf" );
	if ( !status )												
	{
		status.perror ("deregisterCommand CryExportCaf");	
		Log ("*ERROR* cannot deregister command CryExportCaf");
		return status;
	}

	status = plugin.deregisterCommand( "CryExportCgf" );
	if ( !status )												
	{
		status.perror ("deregisterCommand CryExportCgf");	
		Log ("*ERROR* cannot deregister command CryExportCgf");
		return status;
	}

	status = plugin.deregisterCommand( "CryBrowseForDir" );
	if ( !status )												
	{
		status.perror ("deregisterCommand CryBrowseForDir");	
		Log ("*ERROR* cannot deregister command CryBrowseForDir");
		return status;
	}

	status = plugin.deregisterFileTranslator("crytekGeometry");
	if (!status)
	{
		status.perror ("deregisterFileTranslator Cgf");
		Log ("*ERROR* cannot deregister translator Cgf");
		return status;
	}

	status = plugin.deregisterFileTranslator("crytekBuilding");
	if (!status)
	{
		status.perror ("deregisterFileTranslator Bld");
		Log ("*ERROR* cannot deregister translator Bld");
		return status;
	}

	status = plugin.deregisterFileTranslator("crytekAnimation");
	if (!status)
	{
		status.perror ("deregisterFileTranslator Caf");
		Log ("*ERROR* cannot deregister translator Caf");
		return status;
	}

	status = plugin.deregisterCommand("CryExportUtil");
	if (!status)
	{
		status.perror("deregisterCommand CryExportUtil");
		Log ("*ERROR* cannot deregister command CryExportUtil");
		return status;
	}

	Log ("The plugin has been uninitialized");
	return status;												
}
