// Translator plugin.
// Used to export Cgf files.
// In fact, translates the translation request into a command CryExoprt* and executes that command.
#include "StdAfx.h"
#include "translatorcgf.h"
#include "MayaUtils.h"

CTranslatorCgf::CTranslatorCgf(const char* szDefaultExtension):
	m_szDefaultExtension(szDefaultExtension)
{
}

CTranslatorCgf::~CTranslatorCgf(void)
{
}

void*	CTranslatorCgf::creatorCgf()
{
	return new CTranslatorCgf("cgf");
}

void*	CTranslatorCgf::creatorBld()
{
	return new CTranslatorCgf("bld");
}

MStatus CTranslatorCgf::reader ( const MFileObject& file,
								const MString& optionsString,
								MPxFileTranslator::FileAccessMode mode)
{
	return MS::kNotImplemented;
}

MStatus CTranslatorCgf::writer ( const MFileObject& file,
								const MString& optionsString,
								MPxFileTranslator::FileAccessMode mode)
{
	Log ("CTranslatorCgf::writer(file:\"%s\", options: \"%s\", mode: %d)", file.fullName().asChar(), optionsString.asChar(), mode);
	return MGlobal::executeCommand(
		MString("CryExportCgf -file \"") + escapeMString(file.fullName()) + "\" " + convertOptionsToFlags(optionsString),
		true, false);
}

bool CTranslatorCgf::haveReadMethod () const
{
	return false;
}

bool CTranslatorCgf::haveWriteMethod () const
{
	return true;
}

MString CTranslatorCgf::defaultExtension () const
{
	return m_szDefaultExtension;
}

bool CTranslatorCgf::canBeOpened() const
{
	return false; // file opening is not implemented 
}
