// Base class for Cry file translator plugins.
// Parses options, identifies the file
#pragma once

#include "CryHeaders.h"

// Base class for CryTek Maya translators.
// defines the common functionality. All CryTek Engine format (cgf, bld, caf) translators are derived from this.
class CTranslatorCryFile:
	public MPxFileTranslator
{
public:
	CTranslatorCryFile(void);
	~CTranslatorCryFile(void);

	virtual FileTypes getMyFileType()const = 0;
	virtual int getMyFileVersion() const{return 0x744;}

	// converts the string with UI-settable options (delimited with ';')
	// to the string with flags that are understandable by the export commands
	MString convertOptionsToFlags (const MString& strOptions);

	// converts the given option with the value into a flag with the value (or "" if not recognized)
	MString convertOptionToFlag (const MString& strOption, const MString& strValue);

	// optional feature of Maya translator: identifies if the file is likely to be the correct format
	MFileKind identifyFile (	const MFileObject& fileName,
		const char* buffer,
		short size) const;

protected:
	int m_nExportWeightsOption, m_nNumLinksPerVertexOption;
	bool m_bEnableManualRange;
	MString m_strManualRangeStart, m_strManualRangeEnd;
};
