#pragma once


class CBezierVec3dApproximation;
////////////////////////////////////////////////////////////////////
// Bezier 3D Piecewise approximation
class CB3PApproximation
{
public:
	CB3PApproximation(void);
	CB3PApproximation(Vec3d* pData, int nSamples, int nDegree, float fMaxAveError);
	~CB3PApproximation(void);

	float init (Vec3d* pData, int nSamples, int nDegree, float fMaxAveError);
	void clear();
	
	// number of pieces
	int numPieces ()const;

	// returns one of the approximated pieces
	const CBezierVec3dApproximation& getPiece(int nPiece);
	
	// returns the boundaries of the piece in the global enumeration
	std::pair<int,int> getPieceInterval (int nPiece)const;

	// returns the length, in samples, of the nPiece'th piece
	int getPieceSize(int nPiece)const;

protected:
	typedef std::vector<CBezierVec3dApproximation*> PieceArray;
	PieceArray m_arrPieces;
};
