#include "StdAfx.h"
#include "bsplinesimpletest.h"
#include "GLUtils.h"
#include "MotionOptimizerView.h"

BSplineSimpleTest::BSplineSimpleTest(unsigned nKnots):
	m_nCPMoving (-1)
{
	m_pBSpline = new BSplineVec3d (nKnots, 4, true);

	FloatArray arrKnots;
	arrKnots.push_back(0);
	arrKnots.push_back(1);
	while (arrKnots.size() < nKnots)
	{
		float fKnotTime = ((rand()%999)+1)/1000.0f;
		FloatArray::iterator itInsertion = std::lower_bound (arrKnots.begin(), arrKnots.end(), fKnotTime);
		arrKnots.insert (itInsertion, fKnotTime);
	}

	for (unsigned nKnot = 0; nKnot < arrKnots.size(); ++nKnot)
	{
		m_pBSpline->setKnotTime(nKnot, arrKnots[nKnot]);
	}
	for (int nCP = 0; nCP < m_pBSpline->numCPs(); ++nCP)
	{
		Vec3d ptValue (((rand()%999)+1)/1000.0f, ((rand()%999)+1)/1000.0f, /*((rand()%999)+1)/1000.0f*/0);
		(*m_pBSpline)[nCP] = ptValue;
	}

	assert ((m_pBSpline->getCP(0)-m_pBSpline->getValue(0)).Length() < 1e-3);
	assert ((m_pBSpline->getCP(m_pBSpline->numCPs()-1)-m_pBSpline->getValue(1)).Length() < 1e-3);
}

BSplineSimpleTest::~BSplineSimpleTest(void)
{
}


void BSplineSimpleTest::onDraw (CDC* pDC, CMotionOptimizerView* pView)
{
	setSize (pView);

	drawSplineProj (pDC, m_pBSpline);
}
/*
void BSplineSimpleTest::onLButtonDown (const CPoint&pt, CMotionOptimizerView* pView)
{
	RECT rcClient;
	pView->GetClientRect (&rcClient);
	m_szView = CSize (rcClient.right, rcClient.bottom);

	int nNumCPs = m_pBSpline->numCPs();
	
	m_nCPMoving = -1;
	float fMin = 1e+10;
	for (int i = 0; i < nNumCPs; ++i)
	{
		float fDist = (PointToVec (pt)-m_pBSpline->getCP(i)).Length2();
		if (fDist < fMin)
		{
			fMin = fDist;
			m_nCPMoving = i;
		}
	}

	if (m_nCPMoving >= 0)
		m_pBSpline->setCP (m_nCPMoving, PointToVec(pt));
}

void BSplineSimpleTest::onLButtonUp (const CPoint& pt, CMotionOptimizerView* pView)
{
	if (m_nCPMoving >= 0)
		m_pBSpline->setCP (m_nCPMoving, PointToVec(pt));

	m_nCPMoving = -1;
}

void BSplineSimpleTest::onMouseMove (const CPoint&pt, CMotionOptimizerView* pView)
{
	if (m_nCPMoving >= 0)
		m_pBSpline->setCP (m_nCPMoving, PointToVec(pt));
}
*/