// BigVector.h: interface for the CBigVector class.
//
// Implementation of a vector of any arbitrary size.
// The storage for the vector elements is a double array heap
// (see DoubleArrayHeap.h) which amortizes often reallocations
// of a small number of vectors.
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BIGVECTOR_H__E0D78EC7_A32A_41C9_9AF2_3F57ADA196BB__INCLUDED_)
#define AFX_BIGVECTOR_H__E0D78EC7_A32A_41C9_9AF2_3F57ADA196BB__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

///////////////////////////////////////////////////////////////
//a vector of any arbitrary size. see the header comments
///////////////////////////////////////////////////////////////
class CBigVector  
{
public:
	// returns the maximum element in the vector
	double GetMaxElement();
	double GetMinElement();

	// creates an empty vector
	CBigVector();
	
	// copies the source vector
	CBigVector (const CBigVector& vThat);

	// creates a vector with the given size,
	// the vector is initially filled with garbage
	CBigVector (int nLength);

	~CBigVector();

	// returns the current vector size
	int GetSize () const;
	
	// vector maximum capacity
	int GetCapacity() const;

	// nCell-th vector element
	double& operator [] (int nCell);
	double operator [] (int nCell)const;

	// returns norm of this matrix
	double GetNorm ()const;

	// it is guaranteed that as long as capacity is not reached,
	// the content of this vector won't be altered
	void Resize (int nNewSize);

	// zeroes out the vector elements
	void SetZero();

	// sorts all the elements in the vector
	void Sort();

	CBigVector& operator = (const CBigVector& vThat);

	void DebugDump();
protected:
	// the elements of the vector, or NULL of the vector is empty
	double * m_pCells;
	// the size and capacity of the vectors
	int m_nSize, m_nCapacity;
};

// subtracts the vectors
CBigVector operator - (const CBigVector& vLeft, const CBigVector& vRight);

#endif // !defined(AFX_BIGVECTOR_H__E0D78EC7_A32A_41C9_9AF2_3F57ADA196BB__INCLUDED_)
