#include "StdAfx.h"
#include "cputickcounter.h"

//#define IMPLEMENT_THREAD_TIMES

// returns the counter core frequency, in Hertz, or 0 if cannot determine
unsigned __int64 PerfCounterFrequency()
{
#if defined(IMPLEMENT_THREAD_TIMES)
	return 10000000;
#else
	static unsigned __int64 g_nFrequency = 0;
	if (!g_nFrequency)
		QueryPerformanceFrequency((LARGE_INTEGER*)&g_nFrequency);
	return g_nFrequency;
#endif
}

// returns the current tick count, analog of the QueryPerformanceCounter
void PerfCounterTick(unsigned __int64& nResult)
{
#if defined(IMPLEMENT_THREAD_TIMES)
	FILETIME ftCreation, ftExit, ftKernel, ftUser;
	if (GetThreadTimes (GetCurrentThread(), &ftCreation, &ftExit, &ftKernel, &ftUser))
	{
		nResult = (__int64&)ftUser + (__int64&)ftKernel;
	}
	else
		nResult = 0;
#else
	QueryPerformanceCounter ((LARGE_INTEGER*)&nResult);
#endif
}

// returns the current tick count, analog of the QueryPerformanceCounter
unsigned __int64 PerfCounterTick()
{
	unsigned __int64 nResult;
	PerfCounterTick(nResult);
	return nResult;
}

// initializes the timer (paused by default)
CProfilerTimer::CProfilerTimer():
	m_nTime(0)
{
}

// initializes the timer (paused by default)
CProfilerTimer::CProfilerTimer(bool bStart ):
	m_nTime(0)
{
	if (bStart)
		resume();
}

// resumes the timer
void CProfilerTimer::resume()
{
	m_nTime -= PerfCounterTick();
}

// pauses the timer
void CProfilerTimer::pause()
{
	m_nTime += PerfCounterTick();
}

// returns the current time, in seconds
// can only be called after pause()
double CProfilerTimer::seconds()
{
	return double (m_nTime) / PerfCounterFrequency();
}

// resets the timer to 0 and sets it to a paused state
void CProfilerTimer::reset()
{
	m_nTime = 0;
}
