#include "stdafx.h"
#include "DbgLog.h"

static std::string g_sLogPath;



void LogToDbg (const char* szFormat, ...)
{
	va_list vargs;
	va_start(vargs, szFormat);
	//static char szBuf[0x800];
	//_vsnprintf (szBuf, sizeof(szBuf), szFormat, vargs);
	//OutputDebugString (szBuf);

	if (g_sLogPath.empty())
	{
		char szBuf[MAX_PATH];
		GetModuleFileName(AfxGetInstanceHandle(), szBuf, sizeof(szBuf));
		char *p;
		for (p = szBuf + strlen(szBuf)-1; p > szBuf && *p != '.'; --p);
		if (p > szBuf)
			strcpy (p, ".log");
		else
			strcat (szBuf, ".log");
		g_sLogPath = szBuf;
	}

	FILE* fLog = fopen (g_sLogPath.c_str(), "at");
	if (fLog)
	{
		vfprintf (fLog, szFormat, vargs);
		fclose (fLog);
	}
	va_end(vargs);
}
