///////////////////////////////////////////////////////////////////////////
// This header contains declarations of the linear approximation utility
// class that is used to approximate a set of sample points with a linear
// function y = a[0] + a[1]*x
///////////////////////////////////////////////////////////////////////////

#ifndef _MIGDALSKIY_APPROXIMATION_UTILS_HDR_
#define _MIGDALSKIY_APPROXIMATION_UTILS_HDR_

/////////////////////////////////////////////////////////
// linear approximation of a set of points
/////////////////////////////////////////////////////////
class CLinearApproximation
{
public:
	// constructs the approximation from the given set of points
	CLinearApproximation (double* pData, int nCount);

	//returns the term near the nTerm's power of x
	double GetTerm (int nTerm) const {return m_fTerm[nTerm];}

	// calculates the error - since this is the least-square method,
	// the error is the sum of squares of differencies
	double GetError (double * pData, int nCount) const;

	// gets the linear value
	double GetValue(double x)const;

	// returns the coefficient of the nTerm-th power of the parameter variable
	double operator [] (int nTerm)const {return m_fTerm[nTerm];}

	// returns the approximation line value at the given argument
	double operator () (double x) const {return GetValue(x);}
protected:
	// the equation is f[x] = a + b*x, coef[0]+coef[1]*x
	double m_fTerm[2];
};


#endif