// MotionOptimizerDoc.h : interface of the CMotionOptimizerDoc class
//


#pragma once

#include "MotionOptimizerInterfaces.h"

class CMotionOptimizerDoc : public CDocument
{
protected: // create from serialization only
	CMotionOptimizerDoc();
	DECLARE_DYNCREATE(CMotionOptimizerDoc)

// Attributes
public:

// Operations
public:

// Overrides
	public:
	virtual BOOL OnNewDocument();
	void Test();
	virtual void Serialize(CArchive& ar);

// Implementation
public:
	virtual ~CMotionOptimizerDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	void OnFileImportCaf();
	std::string GetDirDlg();
	static int CALLBACK GetDirDlg_BrowseCallbackProc
	(
		HWND hwnd, 
		UINT uMsg, 
		LPARAM lParam, 
		LPARAM lpData
	)
	{
		return ((CMotionOptimizerDoc*)lpData)->GetDirDlgCallback(hwnd, uMsg, lParam);
	}
	int GetDirDlgCallback (HWND hwnd, UINT uMsg, LPARAM lParam);
	std::string m_strLastDir;
protected:
	IDrawable_AutoArray m_vDrawables;
	bool m_b8Bit;
// Generated message map functions
protected:
	DECLARE_MESSAGE_MAP()
public:
	// draws all drawables in the doc
	void onDraw(CDC* pDC, CMotionOptimizerView* pView);
	void onMouseWheel (UINT nFlags, short zDelta, CPoint pt, CMotionOptimizerView* pView);
	void onLButtonDown(const CPoint&, CMotionOptimizerView* pView);
	void onLButtonUp (const CPoint&, CMotionOptimizerView* pView);
	void onMouseMove (const CPoint&, CMotionOptimizerView* pView);
	afx_msg void OnTestBsplineInterpolator();
	afx_msg void OnEditCleanup();
	afx_msg void OnTestBsplineApproximator();
	afx_msg void OnFileImportCafTest();
	afx_msg void OnFileExportCaf();
	afx_msg void OnReoptimize();
	afx_msg void OnFileBatchConvertCaf();
	afx_msg void On8bit();
	afx_msg void OnUpdate8bit(CCmdUI *pCmdUI);
	afx_msg void OnTestTriangulator();
	afx_msg void OnFileOptimizeall();
};


