#ifndef _MOTION_OPTIMIZER_INTERFACES_HEADER_
#define _MOTION_OPTIMIZER_INTERFACES_HEADER_

class CMotionOptimizerView;
#include "BSplineOpen.h"

class IDrawable: public _reference_target_t
{
public:
	IDrawable ();
	CPen m_penKnot;
	CPen m_penCage;
	CPen m_penSpline;
	CPen m_penGreen;
	CPen m_penRGB[3];
	CPen m_penGrid;
	CPen m_penGridRGB[3];
	CPen m_penWeakSpline;
	CPen m_penWeakSplineRGB[3];
	CPen m_penCPRGB[3];
	CFont m_fntMain;

	virtual void onDraw (CDC* pDC, CMotionOptimizerView* pView) = 0;

	virtual void onLButtonDown(const CPoint&, CMotionOptimizerView* pView) {}
	virtual void onLButtonUp (const CPoint&, CMotionOptimizerView* pView) {}
	virtual void onMouseMove (const CPoint&, CMotionOptimizerView* pView) {}

	virtual void onCommand (int nCommand) {}

	virtual void onMouseWheel (UINT nFlags, short zDelta, CPoint pt, CMotionOptimizerView* pView) {}

	static const float g_fMargin, g_fField ;
	CPoint VecToPoint (const Vec3d& pt)
	{
	return CPoint (int((g_fMargin+pt.x*(g_fField-2*g_fMargin)) * m_szView.cx), int((g_fMargin+pt.y*(g_fField-2*g_fMargin)) * m_szView.cy));
	}

	Vec3d PointToVec (const CPoint& pt)
	{
	return Vec3d((pt.x - m_szView.cx*g_fMargin)/(g_fField-2*g_fMargin),(pt.y - m_szView.cy*g_fMargin)/(g_fField-2*g_fMargin),0);
	}
	CSize m_szView;
	void setSize (CView* pView)
	{
		RECT rcClient;
		pView->GetClientRect (&rcClient);
		m_szView = CSize (rcClient.right, rcClient.bottom);
	}

	float m_fMinY, m_fMaxY, m_fMinX, m_fMaxX;
	CPoint point (float fTime, float fY)
	{
		return CPoint (int(3+(m_szView.cx-6) * (fTime-m_fMinX)/(m_fMaxX-m_fMinX)), 20+int((m_szView.cy-25) * (m_fMaxY-fY) / (m_fMaxY-m_fMinY)));
	}

	void drawSplineProj (CDC* pDC, BSplineVec3d* pSpline);
	void drawSplineCurves (CDC* pDC, BSplineVec3d* pSpline);
};

TYPEDEF_AUTOPTR(IDrawable);

#endif