// MotionOptimizerView.cpp : implementation of the CMotionOptimizerView class
//

#include "stdafx.h"
#include "MotionOptimizer.h"

#include "MotionOptimizerDoc.h"
#include "MotionOptimizerView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CMotionOptimizerView

IMPLEMENT_DYNCREATE(CMotionOptimizerView, CView)

BEGIN_MESSAGE_MAP(CMotionOptimizerView, CView)
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_MOUSEWHEEL()
	ON_COMMAND(ID_ACCEL_MOUSE_WHEEL_DOWN, OnAccelMouseWheelDown)
	ON_COMMAND(ID_ACCEL_MOUSE_WHEEL_UP, OnAccelMouseWheelUp)
END_MESSAGE_MAP()

// CMotionOptimizerView construction/destruction

CMotionOptimizerView::CMotionOptimizerView()
{
	// TODO: add construction code here

}

CMotionOptimizerView::~CMotionOptimizerView()
{
}

BOOL CMotionOptimizerView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

// CMotionOptimizerView drawing

void CMotionOptimizerView::OnDraw(CDC* pDC)
{
	CMotionOptimizerDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	pDoc->onDraw (pDC, this);
}


// CMotionOptimizerView printing

BOOL CMotionOptimizerView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CMotionOptimizerView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CMotionOptimizerView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}


// CMotionOptimizerView diagnostics

#ifdef _DEBUG
void CMotionOptimizerView::AssertValid() const
{
	CView::AssertValid();
}

void CMotionOptimizerView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CMotionOptimizerDoc* CMotionOptimizerView::GetDocument() const // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMotionOptimizerDoc)));
	return (CMotionOptimizerDoc*)m_pDocument;
}
#endif //_DEBUG


// CMotionOptimizerView message handlers

void CMotionOptimizerView::OnLButtonDown(UINT nFlags, CPoint point)
{
	GetDocument()->onLButtonDown(point, this);

	CView::OnLButtonDown(nFlags, point);
}

void CMotionOptimizerView::OnLButtonUp(UINT nFlags, CPoint point)
{
	GetDocument()->onLButtonUp(point, this);

	CView::OnLButtonUp(nFlags, point);
}

void CMotionOptimizerView::OnMouseMove(UINT nFlags, CPoint point)
{
	//GetDocument()->onMouseMove(point, this);
	CView::OnMouseMove(nFlags, point);
}

BOOL CMotionOptimizerView::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
	GetDocument()->onMouseWheel (nFlags, zDelta, pt, this);
	return CView::OnMouseWheel(nFlags, zDelta, pt);
}

void CMotionOptimizerView::OnAccelMouseWheelDown()
{
	GetDocument()->onMouseWheel (0, -30, CPoint(0,0), this);
}

void CMotionOptimizerView::OnAccelMouseWheelUp()
{
	GetDocument()->onMouseWheel (0, 30, CPoint(0,0), this);
}
