#pragma once

#include "Cry_Math.h"							// Vec3

#include <vector>									// STL vector
#include "SimpleIndexedMesh.h"		// CSimpleIndexedMesh


class CSurfaceDataLayer
{
public:

	//! constructor
	//! \param indwMaterialID material id or 0xffffffff
	//! \param indwWidth >=0
	//! \param indwHeight >=0
	CSurfaceDataLayer( const DWORD indwMaterialID, const DWORD indwWidth, const DWORD indwHeight );

	//! destructor
	virtual ~CSurfaceDataLayer();




	// ****************************************************************************************

private:

	class CSingleRay
	{
	public:
	
		//! \invDir has to be normalized
		void SetDirection( const Vec3 &invDir )
		{
			dx=(char)(invDir.x*127.0f);
			dy=(char)(invDir.y*127.0f);
			dz=(char)(invDir.z*127.0f);
		}

		Vec3 GetDirection( void )
		{
			return(Vec3( (float)dx*(1.0f/127.0f),(float)dy*(1.0f/127.0f),(float)dz*(1.0f/127.0f) ));
		}

	private:
		char dx,dy,dz;				//!< -127..127 = -1..1 compressed ray direction in objectspace
		char dummy;						//!<

	};

	class CRayBundle
	{
	public:
	
		std::vector<CSingleRay>			m_Rays;
	};

	
	DWORD											m_MaterialID;				//!< material id or 0xffffffff

	DWORD											m_dwWidth;					//!< >=0
	DWORD											m_dwHeight;					//!< >=0

	// high precision displacement
	float	*										m_pDisplacement;		//!< [0..m_dwWidth*m_dwHeight-1]

	// high poly normal
	Vec3 *										m_pNormal;					//!< [0..m_dwWidth*m_dwHeight-1] in objectspace

	// high poly position
	Vec3 *										m_pPosition;				//!< [0..m_dwWidth*m_dwHeight-1] in objectspace

	// low poly mesh (position,uv,tangents) for converting between object/world/tangent/clonespace
	CSimpleIndexedMesh				m_LowPolyMesh;			//!<

	// raw ray shooting data ( ????? binary search or monte carlo ?????? )
	//
	// from this you can get:   * accessibility (1st band spherical harmonics)
	//                          * average sky direction (~ 2nd band spherical harmonics)
	//                          * spherical harmonics
	//                          * shadow horizon for bump self shadowing
	CRayBundle *							m_pRayShooting;			//!< [0..m_dwWidth*m_dwHeight-1]
};
