
//////////////////////////////////////////////////////////////////////
//
//	Crytek Common Source code
//	
//	File:Cry_Plane.h
//	Description: Implementation of Plane class.
//
//	History:
//	-Jan 31,2001:Created by Marco Corbetta
//
//////////////////////////////////////////////////////////////////////

#ifndef PLANE_H
#define PLANE_H

#if _MSC_VER > 1000
# pragma once
#endif



//////////////////////////////////////////////////////////////////////
#define	NORMAL_EPSILON	0.0001f
#define	DIST_EPSILON	0.01f

//////////////////////////////////////////////////////////////////////
class Plane
{
public:
	
	Vec3d	m_normal;
	float	m_dist;
	int		m_CRAPtype;		

//----------------------------------------------------------------	 
	
	Plane()	{	m_CRAPtype=PLANE_XYZ;	};

	//! Initialize a plane giving normal and dist
/*	Plane	(const Vec3d &vNormal,const float fDist)	{
	  m_normal = vNormal; 
		m_dist = fDist;
	  CalcPlaneType2();
	}*/

	//! set normal and dist for this plane and  then calculate plane type
	void	Set(const Vec3d &vNormal,const float fDist)	{	
		m_normal = vNormal; 
		m_dist = fDist;
		CalcPlaneType2(); 
	}

	//! calc the plane giving 3 points
	void	CalcPlane(const Vec3d &p0, const Vec3d &p1, const Vec3d &p2) {
	  m_normal = (p0-p1)^(p2-p1);
	  m_normal.Normalize();
	  m_dist = (p0*m_normal);
	  CalcPlaneType2();
	}

	//! Makes the plane by 3 given points
	void Init(const Vec3d & v1, const Vec3d & v2, const Vec3d & v3)
	{
		Vec3d u, v, t;
		u = v2 - v1;
		v = v2 - v3;
		t = u ^ v;
		t.Normalize();
		m_normal = t;
		m_dist = t*v1;
	}


	//! check for equality between two planes
	inline  friend	bool operator ==(const Plane &p1, const Plane &p2) {
    if (Ffabs(p1.m_normal.x-p2.m_normal.x)>NORMAL_EPSILON) return (false);
    if (Ffabs(p1.m_normal.y-p2.m_normal.y)>NORMAL_EPSILON) return (false);
    if (Ffabs(p1.m_normal.z-p2.m_normal.z)>NORMAL_EPSILON) return (false);
    if (Ffabs(p1.m_dist-p2.m_dist)<DIST_EPSILON) return(true);
    return (false);
  }

	//! same as above for const members
	float	DistFromPlane(const Vec3d &vPoint) const	{
	  return (m_normal*vPoint-m_dist);
	}


	Vec3d MirrorVector(Vec3d& i)  {
    return i - m_normal*((m_normal|i)*2);
  }
	//inline CVector vreflection( const CVector &i, const CPlane &p ) { return i - p.n*(p|i)*2; }

  Vec3d MirrorPosition(Vec3d& i) {
    return i - m_normal * (2.f * ((m_normal|i) - m_dist));
  }

	

	//----------------------------------------------------------
	//! calc the plane type (most x,y,z aligned)
	//----------------------------------------------------------
	void	CalcPlaneType2()	{
		if (((1.0f-m_normal.x)<0.001f) && ((1.0f-m_normal.x)>=0))
	    m_CRAPtype = PLANE_X;
	  else
	  if (((1.0f-m_normal.y)<0.001f) && ((1.0f-m_normal.y)>=0)) 
	    m_CRAPtype = PLANE_Y;
	  else
	  if (((1.0f-m_normal.z)<0.001f) && ((1.0f-m_normal.x)>=0)) 
	    m_CRAPtype = PLANE_Z;            
	  else
	  {
	    float ax = (float)Ffabs(m_normal[0]);
	    float ay = (float)Ffabs(m_normal[1]);
	    float az = (float)Ffabs(m_normal[2]);
	    
	    if (ax>=ay && ax>=az) 
	      m_CRAPtype=PLANE_MX;
	    else
	    if (ay>=ax && ay>=az) 
	      m_CRAPtype=PLANE_MY;
	    else 
	      m_CRAPtype=PLANE_MZ;	
	  }
	}



	//----------------------------------------------------------
	//! tell which side of the plane the box is
	//----------------------------------------------------------
  //used in indoor-engine
	int CalcBoxSide(const Vec3d &Mins, const Vec3d &Maxs) const
	{

	  //axial case
		if (m_CRAPtype <= PLANE_Z)
		{
			if (m_dist <= Mins[m_CRAPtype])
				return (SIDE_FRONT);
			if (m_dist >= Maxs[m_CRAPtype])
				return (SIDE_BACK);
			return (SIDE_CROSS);
		}

	  Vec3d Corners[2];

		for (int i=0;i<3;i++)
		{
			if (m_normal[i] < 0)
			{
				Corners[0][i] = Mins[i];
				Corners[1][i] = Maxs[i];
			}
			else
			{
				Corners[1][i] = Mins[i];
				Corners[0][i] = Maxs[i];
			}
		} //i

		float fDist1 = (m_normal*Corners[0]) - m_dist;
		float fDist2 = (m_normal*Corners[1]) - m_dist;

		bool bFront=(fDist1>=0);

		if (fDist2<0)
	  {
	    if (bFront)
	      return (SIDE_CROSS);

	    return (SIDE_BACK);
	  }
			
		return (SIDE_FRONT);
	}


	//----------------------------------------------------------
	//! snap a plane to the nearest grid
	//----------------------------------------------------------
	/*void	Snap()
	{
	for (int i=0 ; i<3 ; i++)
	{
	if (fabs(m_normal[i] - 1) < NORMAL_EPSILON)
	{
	m_normal(0,0,0);			
	m_normal[i] = 1;
	break;
	}

	if (fabs(m_normal[i]- -1) < NORMAL_EPSILON )
	{
	m_normal(0,0,0);
	m_normal[i] = -1;
	break;
	}
	}

	float newdist=(float)floor(m_dist+0.05f);	
	if (fabs(m_dist-newdist) < DIST_EPSILON) 
	m_dist = newdist;
	}*/



	//! calc the plane giving 3 points - skip some calculations not needed for shadow volumes
	/*void	CalcEasyPlane(const Vec3d &p0, const Vec3d &p1, const Vec3d &p2)	{
	m_normal = (p0-p1)^(p2-p1);	  
	m_dist = (p0*m_normal);		
	}*/


	//! invert plane's equation
	/*	void	Invert() {
	m_normal = -m_normal;
	m_dist = -m_dist; 
	CalcPlaneType2();
	}*/
	//! return an inverted plane
	//Plane	Inverted() { return (Plane(-m_normal, -m_dist));	}

};

#endif //plane