#pragma once

#include "Cry_Math.h"						// Vec3


// Helper class for storing compressed (3Bytes) base vectors for Clone-Space bumpmapping
// 
// part of Crytek Polybump
// 
// written by Martin Mittring
//

class CPBCloneMap
{
public:

	//! constructor
									CPBCloneMap				( void );

	//! destructor
	virtual					~CPBCloneMap			( void );

	//!
	//! /return true=success, false otherwise
	bool						Create						( const DWORD indwWidth, const DWORD indwHeight );

	//! save the clonemap (same directory and filename (except extension) as objectspace bumpmap is recommended)
	//! /param inszFileName pointer to the zero terminated filename (e.g. "C:\temp\Normalmap.cln" )
	//! /return true=map was saved successfully, false=save failed
	bool						SaveCloneMap			( const char *inszFileName );

	//! set the base for a UV triangle definition
	//! /param infU x position in texture (0..1) without range restrictions (currently unchecked for negative values)
	//! /param infV y position in texture (0..1) without range restrictions (currently unchecked for negative values)
	//! /param invBase input orthonormal base
	bool						Set								( float infU[3], float infV[3], Vec3 invBase[3] );

	//! free the 
	void						FreeData						( void );

private:

	DWORD *		m_pBitmap;						//! Bitmap with orthonormal base vectors (stored as 0RGB Color)
	DWORD			m_dwBitmapWidth;			//! width of the m_pBitmap bitmap
	DWORD			m_dwBitmapHeight;			//! height of the m_pBitmap bitmap
};
