#pragma once

#include <string>																			// STL string



class CProperties
{
public:

		float										m_fBumpmapStrength;				//!< strength of the bumpmap, only valid if m_pBumpMapBuffer!=0

		int											m_nHitMode;								//!< 0:nearest point, 1:latest hit, 3:best hit2
		float										m_fRayLength;							//!< ray length for ray shoothing (1=100%)

		int											m_iTextureSizePX;					//!< Texture Size horizontal 0=8, 1=16, 2=32, ..
		int											m_iTextureSizePY;					//!< Texture Size vertical   0=8, 1=16, 2=32, ..

		int											m_iAntiAliasingMode;			//!< antialiasing 0=none,1=low,2=med,3=high,4=max
		int											m_iExpandTextureMode;			//!< use expansion of the texture 0=0, 1=1, 2=2, 3=4, 4=8, 5=16, 6=32
		bool										m_bExtendFilename;				//!< extend the filename with render attributes

		bool										m_bOutputHighpolyNormals;	//!< output the high poly normal map
		bool										m_bOutputOccDirection;		//!< average direction to the occluding surface, only with m_bOutputAccessability=true
		float										m_fOccBrighter;						//!< 0=0%..1=100%to fake interreflection amount for the occlusion
		bool										m_bObjectSpace;						//!<   true=result is in objectspace, false=result is in tangentspace
		bool										m_bOutputClonemap;				//!<   output the clonemap (.cln)

		bool										m_bOutputAccessability;		//!< output the accessability map

		bool										m_bOutputDisplace;				//!< output the displacement map
		bool										m_bDisplaceSigned;				//!<   calculate a signed displacement
		bool										m_bDisplaceNPatch;				//!<   use N-Patch smoothing for displacement calcualtion
		bool										m_bDisplaceQuadratic;			//!<   use quadratic or linear interpolation for NPatches for displacement calcualtion
		float										m_fReturnDisplaceMag;			//!<   return value: displacement magnitude

		std::string							m_szOutputFilename;				//!< Output Base Filename e.g. "PolyBump"
		std::string							m_szOutputExtension;			//!< Output Base Extension e.g. ".bmp"

		bool										m_bOutputDebugInfo;				//!< for internal debug purpose (output internal representation als .OBJ files, RasterCube Bitmaps)

		std::string							m_bSummariesString;				//!< This string is used for putting the summaries together (use \n for seperating), this is only shown if m_bPrintSummary is true
		bool										m_bPrintSummary;					//!< activates after working a messagebox with the summaries (m_bSummariesString)
		bool										m_bNormalJitter;					//!< better quality but visible noise in the highlight
		int											m_iMaterialID;						//!< material id of the low poly that we want to calculate, -1 for every material id

		//! constructor
		CProperties()
		{
				m_iAntiAliasingMode=0;
				m_iExpandTextureMode=6;
				m_bOutputHighpolyNormals=true;
				m_bOutputOccDirection=false;
				m_bOutputAccessability=false;
				m_bOutputDisplace=false;
				m_bExtendFilename=true;
				m_fBumpmapStrength=30.0f;
				m_bObjectSpace=false;
				m_bOutputClonemap=false;
				m_fRayLength=0.10f;							// 10%
				m_fOccBrighter=0.0f;						//
				m_nHitMode=1;										// use latest hit
				m_iTextureSizePX=5;							// 256 
				m_iTextureSizePY=5;							//     x 256
				m_szOutputFilename="Polybump";
#ifdef USE_3DSSAVEFUNCTION_IFPOSSIBLE
				m_szOutputExtension=".bmp";
#else
				m_szOutputExtension=".tga";
#endif // USE_3DSSAVEFUNCTION_IFPOSSIBLE
				m_bOutputDebugInfo=false;
				m_bDisplaceSigned=true;
				m_bDisplaceNPatch=true;
				m_fReturnDisplaceMag=0.0f;
				m_bDisplaceQuadratic=true;
				m_bPrintSummary=false;
				m_bNormalJitter=false;
				m_iMaterialID=-1;
		}

		//!
		DWORD GetOutputWidth( void )
		{
			return(1<<(m_iTextureSizePX+3));
		}

		bool IsThereWorkToDo( void )
		{
			return(m_bOutputHighpolyNormals || m_bOutputAccessability || m_bOutputDisplace || m_bOutputOccDirection);
		}

		//!
		DWORD GetOutputHeight( void )
		{
			return(1<<(m_iTextureSizePY+3));
		}

		//! split filename and path, set m_szOutputFilename and m_szOutputExtension
		void SetOutputFilename( const char *inszFilename )
		{
			DWORD len=strlen(inszFilename);

			// works only for extensions with 3 characters
			if(len>=4 && inszFilename[len-4]=='.')
			{
				m_szOutputFilename.assign(inszFilename,len-4);
				m_szOutputExtension.assign(&(inszFilename[len-4]),4);
			}
			else
			{
				m_szOutputFilename=inszFilename;
#ifdef USE_3DSSAVEFUNCTION_IFPOSSIBLE
				m_szOutputExtension=".bmp";
#else
				m_szOutputExtension=".tga";
#endif // USE_3DSSAVEFUNCTION_IFPOSSIBLE

			}
		}

		bool DoNonAAStep( void )
		{
			return(m_iAntiAliasingMode!=4);
		}

		void GetAntialiasingParam( float &outfAntiAliasStep, float &outfAntialiasTreshold )
		{
			switch(m_iAntiAliasingMode)
			{
				case 1:	// low
					outfAntiAliasStep=1.0f/2.0f;			// 4 samples adaptive
					outfAntialiasTreshold=0.30f*0.30f;
					break;

				case 2:	// med
					outfAntiAliasStep=1.0f/3.0f;			// 9 samples adaptive
					outfAntialiasTreshold=0.22f*0.22f;
					break;

				case 3:	// high
					outfAntiAliasStep=1.0f/4.0f;			// 16 samples adaptive
					outfAntialiasTreshold=0.10f*0.10f;
					break;

				case 4:	// max
					outfAntiAliasStep=1.0f/4.0f;			// 16 samples
					outfAntialiasTreshold=0.00f;
					break;

				default: assert(0);
			}
		}

		bool DoAAJittering( void )
		{
			return(false);
		}
};




