#pragma once

#include <D3dx8math.h>									// D3DXMATRIX
#include "PBCloneMapDest.h"							// CPBCloneMapDest

#include <string>												// STL string
using namespace std;										// STL

typedef DWORD D3DCOLOR;
struct IDirect3DTexture8;
struct IDirect3DDevice8;
class C3DObject;
class C3DRenderer;
class C3DScene;
class C3DTriangleBunch;



// don't change the member variable order!
struct POLYBUMPVERTEX
{
	D3DXVECTOR3 pos;					// v0: vertex position
  D3DXVECTOR3 normal;				// v1: vertex normal

	FLOAT       tu, tv;				// v3: texture coordinates
	D3DXVECTOR3 binormal;     // v4: base[0], binormal
  D3DXVECTOR3 tangent;      // v5: base[1], tangent
	D3DXVECTOR3 tnormal;			// v6: base[2], normal
}; 


extern DWORD PolyBumpVertexDecl[];


// new and delete of materials should be done though C3DMaterialManager

class C3DMaterial
{
public:

	//! constructor
										C3DMaterial					( const char *inszName );

	//! destructor (FreeData is called)
	virtual						~C3DMaterial				( void );

	//! render a triangle bunch
	//! /param inRenderer reference to the renderer
	//! /param inTriBunch triangle bunch to render
	//! /param inScene for the environment (lights, ...)
	void							SetMaterialAndRender( C3DRenderer &inRenderer, C3DTriangleBunch &inTriBunch, C3DScene &inScene );

	// Attributes ************************************************************

	//! add to attribute (only used during LoadObj())
	void							AddTriangleCount		( void );

	//! get attribute (only used during LoadObj())
	DWORD							GetTriangleCount		( void );

	//! get attribute
	const char *			GetName							( void );

	//! set attribute
	void							SetAmbientColor			( D3DXCOLOR inColor );

	//! set attribute
	void							SetDiffuseColor			( D3DXCOLOR inColor );

	//! set attribute
	void							SetSpecularColor		( D3DXCOLOR inColor );

	//! set attribute
	void							SetSubsurfaceColor	( D3DXCOLOR inColor );

	//! set attribute (load the texture)
	//! /return true=success, false=failed
	bool							SetDiffuseTexture		( C3DRenderer &inRenderer, const char *inszFileName );

	//! set attribute (load the texture)
	//! /param inbLoadClonemap true=load the clonemap, false=don't load the clonemap (.cln)
	//! /return true=success, false=failed
	bool							SetPolyBumpTexture	( C3DRenderer &inRenderer, const char *inszFileName, bool inbLoadClonemap );

	//! set attribute (load the texture)
	//! /return true=success, false=failed
	bool							SetOcclusionDirectionTexture	( C3DRenderer &inRenderer, const char *inszFileName );

	//!
	//! /return reference 
	CPBCloneMapDest &	GetCloneMapRef			( void );

 	// ********************************************************************************

public:

	string								m_sName;											//!< used as connection between .OBJ and .MTL
	D3DXCOLOR							m_Ka;													//!< ambient color (DWORD)
	D3DXCOLOR							m_Kd;													//!< diffuse color (DWORD)
	D3DXCOLOR							m_Ks;													//!< specular color (DWORD)
	D3DXCOLOR							m_Kss;												//!< subsurface color (DWORD)
	IDirect3DTexture8 *		m_pDiffuseTexture;						//!< diffuse texture
	IDirect3DTexture8 *		m_pPolybumpTexture;						//!< polybump texture
	IDirect3DTexture8 *		m_pOccDirTexture;							//!< occlusion direction texture

	CPBCloneMapDest				m_PolybumpClonemap;						//!< used for CloneSpace
									
	DWORD									m_TriangleCount;							//!< only used while LoadOBJ & _InsertSurfaceData


	//! free textures (used by destructor)
	void							FreeData						( void );

	
	//! call this before rendering
	//! /param inRenderer reference to the renderer
	bool							SetMaterial					( C3DRenderer &inRenderer, const DWORD indwPass );

	//! render a triangle bunch
	//! /param inRenderer reference to the renderer
	//! /param inTriBunch triangle bunch to render
	//! /param inScene for the environment (lights, ...)
	void							RenderTriangleList	( C3DRenderer &inRenderer, C3DTriangleBunch &inTriBunch, C3DScene &inScene,
																					DWORD &inoutdwBackBufferLayers );
};




