#pragma once

class C3DMaterial;
struct IDirect3DVertexBuffer8;
struct IDirect3DIndexBuffer8;
class C3DRenderer;

// helperclass for C3DObject
// every triangle in one bunch has the same material,vertexbuffer and indexbuffer
class C3DTriangleBunch
{
public:

	//! constructor
							C3DTriangleBunch						( void );

	//! destructor
	virtual			~C3DTriangleBunch						( void );

	//! render the tangent space vectors of a triangle bunch
	//! /param inRenderer reference to the renderer
	//! /param infScale scale factor for the vectors
	//! /param inbVertexBaseVectors true=vertex base vectors (colored) show be displayed), false=otherwise
	//! /param inbTriBaseVectors true=triangle base vectors (colored) show be displayed), false=otherwise
	//! /param inbNormals true=normal vectors (grey) show be displayed), false=otherwise
	void				RenderDebugHelper						( C3DRenderer &inRenderer, float infScale );

	// ***************************************************************************

private:

	IDirect3DVertexBuffer8 *		m_IVertexBuffer;			//!< interface pointer to the VertexBuffer
	IDirect3DIndexBuffer8 *			m_IIndexBuffer;				//!< interface pointer to the IndexBuffer

	C3DMaterial	*								m_pMaterial;					//!< pointer to the material

	DWORD												m_localIndex;					//!< start index in the IndexBuffer
	DWORD												m_PrimitiveCount;			//!< number of triangles

	DWORD												m_minlocalVertex;			//!< information only used for optimization (redundant)
	DWORD												m_maxlocalVertex;			//!< information only used for optimization (redundant)


	friend class C3DObject;
	friend class C3DMaterial;
};
