#include "stdafx.h"							// for precompiled headers (has to be in first place)

#include <malloc.h>							// malloc(), free()
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>							// assert()
#include <mmreg.h>							// WAVEFORMATEX
#include "shellapi.h"						// ShellExecute()

#include "error.h"
#include "ProcessorClock.h"			// CProcessorClock

#include <dsound.h>
#include <direct.h>
#include <ddraw.h>
#include <dinput.h>
#include <dplay.h>
#include <d3d.h>


// Extract the error code from an HRESULT
#define CODEFROMHRESULT(hRes) ((hRes) & 0x0000FFFFUL)





ErrorC Error(1000,1);					  // wird mittels Extern den anderen Modules zugnglich gemacht
																// bei Fehlern druckt der Destruktor diese aus
ErrorC Message(12000,2);






ErrorC::ErrorC( int len, int fin )       // Verhalten des Destruktors: 
{                                        //    0=keine Ausgabe,1=auf Konsole,2=in Datei
  list=0;last=0;count=0;
  fin_act=fin;maxlist=len;
}

ErrorC::~ErrorC()
{
  if(fin_act==1)	{ Save("error.txt");Print(); }
  if(fin_act==2)	Save("message.txt");
  
  struct ListElement *ptr=list;

  while(ptr!=0)
  {
    struct ListElement *ptr2=ptr->next;

    if(ptr->data!=0)free(ptr->data);
    free(ptr);

    ptr=ptr2;
  }
}

void ErrorC::Add( char *txt, ... )       // etwas ineffizient
{
	if(count==0)
		internaltime=MyProcessorClock.GetActualTime();

	count++;

	if(count>maxlist)
	{
		DeleteFirstElement();
	}


  char str[1024];
  va_list argptr;

  va_start(argptr,txt);

  vsprintf(str,txt,argptr);

	assert(strlen(str)<1023);

  struct ListElement *ptr=(struct ListElement *)malloc(sizeof(ListElement));
  ptr->data=(char *)malloc(strlen(str)+1+9);strcpy(ptr->data+9,str);
	sprintf(ptr->data,"%8d",MyProcessorClock.GetActualTime()-internaltime);
	ptr->data[8]=' ';
    
	internaltime=MyProcessorClock.GetActualTime();

  va_end(argptr);

	ptr->next=0;

	if(list==0)
	{
		list=ptr;
	}
	else last->next=ptr;

	last=ptr;
}



void ErrorC::DeleteFirstElement( void )
{
	assert(list!=0);	// Wenn das passiert, knne es sein, Objekt ist noch nicht initialisiert

	ListElement *newlist=list->next;

	free(list->data);
	free(list);

	list=newlist;
}








void ErrorC::Print( void )
{
    if(count==0)return;




	// open the output with the standard text viewer (notepad)
	HINSTANCE	h=ShellExecute(NULL,"open","error.txt",NULL,NULL,SW_SHOWNORMAL);

	if((UINT)h<=32)
		MessageBeep(0);	// failed
}




void ErrorC::Save( char *name )
{
    struct ListElement *ptr=list;
    FILE *handle;
    char str[1024];

    handle=fopen(name,"wb");
    if(handle==NULL){ Error.Add("ErrorC::open of file <%s> failed",name);return; }

    if(count>=maxlist)sprintf(str,"%d von %d messages: \r\n",maxlist,count);
	else 
	{
		if(count==1)sprintf(str,"one message: \r\n");
			else sprintf(str,"%d messages: \r\n",count);
    }
	fwrite(str,strlen(str),1,handle);

    while(ptr!=0)
    {
        if(ptr->data!=0)sprintf(str," - %s\r\n",ptr->data); else sprintf(str," - ***\r\n");
        fwrite(str,strlen(str),1,handle);

		ptr=ptr->next;
    }
    sprintf(str,"\r\n");fwrite(str,strlen(str),1,handle);
    fclose(handle);
}










void ErrorC::AddDirectX( char *txt, HRESULT hRes )       // Evtl. ineffizient (2x strcpy)
{
    Add("DirectX %s:%s (#%d)", txt, GetDirectXErrorText(hRes), CODEFROMHRESULT(hRes));
}

char *ErrorC::GetDirectXErrorText( HRESULT hRes ) 
{
  switch(hRes)
  {
    case DD_OK: return "DD_OK";
    case D3DERR_BADMAJORVERSION: return "D3DERR_BADMAJORVERSION";
    case D3DERR_BADMINORVERSION: return "D3DERR_BADMINORVERSION";

    case D3DERR_EXECUTE_CREATE_FAILED: return "D3DERR_EXECUTE_CREATE_FAILED";
    case D3DERR_EXECUTE_DESTROY_FAILED: return "D3DERR_EXECUTE_DESTROY_FAILED";
    case D3DERR_EXECUTE_LOCK_FAILED: return "D3DERR_EXECUTE_LOCK_FAILED";
    case D3DERR_EXECUTE_UNLOCK_FAILED: return "D3DERR_EXECUTE_UNLOCK_FAILED";
    case D3DERR_EXECUTE_LOCKED: return "D3DERR_EXECUTE_LOCKED";
    case D3DERR_EXECUTE_NOT_LOCKED: return "D3DERR_EXECUTE_NOT_LOCKED";

    case D3DERR_EXECUTE_FAILED: return "D3DERR_EXECUTE_FAILED";
    case D3DERR_EXECUTE_CLIPPED_FAILED: return "D3DERR_EXECUTE_CLIPPED_FAILED";

    case D3DERR_TEXTURE_NO_SUPPORT: return "D3DERR_TEXTURE_NO_SUPPORT";
    case D3DERR_TEXTURE_CREATE_FAILED: return "D3DERR_TEXTURE_CREATE_FAILED";
    case D3DERR_TEXTURE_DESTROY_FAILED: return "D3DERR_TEXTURE_DESTROY_FAILED";
    case D3DERR_TEXTURE_LOCK_FAILED: return "D3DERR_TEXTURE_LOCK_FAILED";
    case D3DERR_TEXTURE_UNLOCK_FAILED: return "D3DERR_TEXTURE_UNLOCK_FAILED";
    case D3DERR_TEXTURE_LOAD_FAILED: return "D3DERR_TEXTURE_LOAD_FAILED";
    case D3DERR_TEXTURE_SWAP_FAILED: return "D3DERR_TEXTURE_SWAP_FAILED";
    case D3DERR_TEXTURE_LOCKED: return "D3DERR_TEXTURE_LOCKED";
    case D3DERR_TEXTURE_NOT_LOCKED: return "D3DERR_TEXTURE_NOT_LOCKED";
    case D3DERR_TEXTURE_GETSURF_FAILED: return "D3DERR_TEXTURE_GETSURF_FAILED";
    case D3DERR_MATRIX_CREATE_FAILED: return "D3DERR_MATRIX_CREATE_FAILED";
    case D3DERR_MATRIX_DESTROY_FAILED: return "D3DERR_MATRIX_DESTROY_FAILED";
    case D3DERR_MATRIX_SETDATA_FAILED: return "D3DERR_MATRIX_SETDATA_FAILED";
    case D3DERR_MATRIX_GETDATA_FAILED: return "D3DERR_MATRIX_GETDATA_FAILED";
    case D3DERR_SETVIEWPORTDATA_FAILED: return "D3DERR_SETVIEWPORTDATA_FAILED";
    case D3DERR_MATERIAL_CREATE_FAILED: return "D3DERR_MATERIAL_CREATE_FAILED";
    case D3DERR_MATERIAL_DESTROY_FAILED: return "D3DERR_MATERIAL_DESTROY_FAILED";
    case D3DERR_MATERIAL_SETDATA_FAILED: return "D3DERR_MATERIAL_SETDATA_FAILED";
    case D3DERR_MATERIAL_GETDATA_FAILED: return "D3DERR_MATERIAL_GETDATA_FAILED";
    case D3DERR_LIGHT_SET_FAILED: return "D3DERR_LIGHT_SET_FAILED";
    case D3DERR_SCENE_IN_SCENE: return "D3DERR_SCENE_IN_SCENE";
    case D3DERR_SCENE_NOT_IN_SCENE: return "D3DERR_SCENE_NOT_IN_SCENE";
    case D3DERR_SCENE_BEGIN_FAILED: return "D3DERR_SCENE_BEGIN_FAILED";
    case D3DERR_SCENE_END_FAILED: return "D3DERR_SCENE_END_FAILED";

    case DDERR_ALREADYINITIALIZED: return "DDERR_ALREADYINITIALIZED";
    case DDERR_CANNOTATTACHSURFACE: return "DDERR_CANNOTATTACHSURFACE";
    case DDERR_CANNOTDETACHSURFACE: return "DDERR_CANNOTDETACHSURFACE";
    case DDERR_CURRENTLYNOTAVAIL: return "DDERR_CURRENTLYNOTAVAIL";
    case DDERR_EXCEPTION: return "DDERR_EXCEPTION";
    case DDERR_GENERIC: return "DDERR_GENERIC";
    case DDERR_HEIGHTALIGN: return "DDERR_HEIGHTALIGN";
    case DDERR_INCOMPATIBLEPRIMARY: return "DDERR_INCOMPATIBLEPRIMARY";
    case DDERR_INVALIDCAPS: return "DDERR_INVALIDCAPS";
    case DDERR_INVALIDCLIPLIST: return "DDERR_INVALIDCLIPLIST";
    case DDERR_INVALIDMODE: return "DDERR_INVALIDMODE";
    case DDERR_INVALIDOBJECT: return "DDERR_INVALIDOBJECT";
    case DDERR_INVALIDPARAMS: return "DDERR_INVALIDPARAMS";
    case DDERR_INVALIDPIXELFORMAT: return "DDERR_INVALIDPIXELFORMAT";
    case DDERR_INVALIDRECT: return "DDERR_INVALIDRECT";
    case DDERR_LOCKEDSURFACES: return "DDERR_LOCKEDSURFACES";
    case DDERR_NO3D: return "DDERR_NO3D";
    case DDERR_NOALPHAHW: return "DDERR_NOALPHAHW";
    case DDERR_NOCLIPLIST: return "DDERR_NOCLIPLIST";
    case DDERR_NOCOLORCONVHW: return "DDERR_NOCOLORCONVHW";
    case DDERR_NOCOOPERATIVELEVELSET: return "DDERR_NOCOOPERATIVELEVELSET";
    case DDERR_NOCOLORKEY: return "DDERR_NOCOLORKEY";
    case DDERR_NOCOLORKEYHW: return "DDERR_NOCOLORKEYHW";
    case DDERR_NODIRECTDRAWSUPPORT: return "DDERR_NODIRECTDRAWSUPPORT";
    case DDERR_NOEXCLUSIVEMODE: return "DDERR_NOEXCLUSIVEMODE";
    case DDERR_NOFLIPHW: return "DDERR_NOFLIPHW";
    case DDERR_NOGDI: return "DDERR_NOGDI";
    case DDERR_NOMIRRORHW: return "DDERR_NOMIRRORHW";
    case DDERR_NOTFOUND: return "DDERR_NOTFOUND";
    case DDERR_NOOVERLAYHW: return "DDERR_NOOVERLAYHW";
    case DDERR_NORASTEROPHW: return "DDERR_NORASTEROPHW";
    case DDERR_NOROTATIONHW: return "DDERR_NOROTATIONHW";
    case DDERR_NOSTRETCHHW: return "DDERR_NOSTRETCHHW";
    case DDERR_NOT4BITCOLOR: return "DDERR_NOT4BITCOLOR";
    case DDERR_NOT4BITCOLORINDEX: return "DDERR_NOT4BITCOLORINDEX";
    case DDERR_NOT8BITCOLOR: return "DDERR_NOT8BITCOLOR";
    case DDERR_NOTEXTUREHW: return "DDERR_NOTEXTUREHW";
    case DDERR_NOVSYNCHW: return "DDERR_NOVSYNCHW";
    case DDERR_NOZBUFFERHW: return "DDERR_NOZBUFFERHW";
    case DDERR_NOZOVERLAYHW: return "DDERR_NOZOVERLAYHW";
    case DDERR_OUTOFCAPS: return "DDERR_OUTOFCAPS";
    case DDERR_OUTOFMEMORY: return "DDERR_OUTOFMEMORY";
    case DDERR_OUTOFVIDEOMEMORY: return "DDERR_OUTOFVIDEOMEMORY";
    case DDERR_OVERLAYCANTCLIP: return "DDERR_OVERLAYCANTCLIP";
    case DDERR_OVERLAYCOLORKEYONLYONEACTIVE: return "DDERR_OVERLAYCOLORKEYONLYONEACTIVE";
    case DDERR_PALETTEBUSY: return "DDERR_PALETTEBUSY";
    case DDERR_COLORKEYNOTSET: return "DDERR_COLORKEYNOTSET";
    case DDERR_SURFACEALREADYATTACHED: return "DDERR_SURFACEALREADYATTACHED";
    case DDERR_SURFACEALREADYDEPENDENT: return "DDERR_SURFACEALREADYDEPENDENT";
    case DDERR_SURFACEBUSY: return "DDERR_SURFACEBUSY";
    case DDERR_CANTLOCKSURFACE: return "DDERR_CANTLOCKSURFACE";
    case DDERR_SURFACEISOBSCURED: return "DDERR_SURFACEISOBSCURED";
    case DDERR_SURFACELOST: return "DDERR_SURFACELOST";
    case DDERR_SURFACENOTATTACHED: return "DDERR_SURFACENOTATTACHED";
    case DDERR_TOOBIGHEIGHT: return "DDERR_TOOBIGHEIGHT";
    case DDERR_TOOBIGSIZE: return "DDERR_TOOBIGSIZE";
    case DDERR_TOOBIGWIDTH: return "DDERR_TOOBIGWIDTH";
    case DDERR_UNSUPPORTED: return "DDERR_UNSUPPORTED";
    case DDERR_UNSUPPORTEDFORMAT: return "DDERR_UNSUPPORTEDFORMAT";
    case DDERR_UNSUPPORTEDMASK: return "DDERR_UNSUPPORTEDMASK";
    case DDERR_VERTICALBLANKINPROGRESS: return "DDERR_VERTICALBLANKINPROGRESS";
    case DDERR_WASSTILLDRAWING: return "DDERR_WASSTILLDRAWING";
    case DDERR_XALIGN: return "DDERR_XALIGN";
    case DDERR_INVALIDDIRECTDRAWGUID: return "DDERR_INVALIDDIRECTDRAWGUID";
    case DDERR_DIRECTDRAWALREADYCREATED: return "DDERR_DIRECTDRAWALREADYCREATED";
    case DDERR_NODIRECTDRAWHW: return "DDERR_NODIRECTDRAWHW";
    case DDERR_NOEMULATION: return "DDERR_NOEMULATION";
    case DDERR_REGIONTOOSMALL: return "DDERR_REGIONTOOSMALL";
    case DDERR_CLIPPERISUSINGHWND: return "DDERR_CLIPPERISUSINGHWND";
    case DDERR_NOCLIPPERATTACHED: return "DDERR_NOCLIPPERATTACHED";
    case DDERR_NOHWND: return "DDERR_NOHWND";
    case DDERR_HWNDSUBCLASSED: return "DDERR_HWNDSUBCLASSED";
    case DDERR_HWNDALREADYSET: return "DDERR_HWNDALREADYSET";
    case DDERR_NOPALETTEATTACHED: return "DDERR_NOPALETTEATTACHED";
    case DDERR_NOPALETTEHW: return "DDERR_NOPALETTEHW";
    case DDERR_BLTFASTCANTCLIP: return "DDERR_BLTFASTCANTCLIP";
    case DDERR_NOBLTHW: return "DDERR_NOBLTHW";
    case DDERR_NODDROPSHW: return "DDERR_NODDROPSHW";
    case DDERR_OVERLAYNOTVISIBLE: return "DDERR_OVERLAYNOTVISIBLE";
    case DDERR_NOOVERLAYDEST: return "DDERR_NOOVERLAYDEST";
    case DDERR_INVALIDPOSITION: return "DDERR_INVALIDPOSITION";
    case DDERR_NOTAOVERLAYSURFACE: return "DDERR_NOTAOVERLAYSURFACE";
    case DDERR_EXCLUSIVEMODEALREADYSET: return "DDERR_EXCLUSIVEMODEALREADYSET";
    case DDERR_NOTFLIPPABLE: return "DDERR_NOTFLIPPABLE";
    case DDERR_CANTDUPLICATE: return "DDERR_CANTDUPLICATE";
    case DDERR_NOTLOCKED: return "DDERR_NOTLOCKED";
    case DDERR_CANTCREATEDC: return "DDERR_CANTCREATEDC";
    case DDERR_NODC: return "DDERR_NODC";
    case DDERR_WRONGMODE: return "DDERR_WRONGMODE";
    case DDERR_IMPLICITLYCREATED: return "DDERR_IMPLICITLYCREATED";
    case DDERR_NOTPALETTIZED: return "DDERR_NOTPALETTIZED";
    case DDERR_UNSUPPORTEDMODE: return "DDERR_UNSUPPORTEDMODE";
    case DDERR_NOMIPMAPHW: return "DDERR_NOMIPMAPHW";
    case DDERR_INVALIDSURFACETYPE: return "DDERR_INVALIDSURFACETYPE";
    case DDERR_DCALREADYCREATED: return "DDERR_DCALREADYCREATED";
    case DDERR_CANTPAGELOCK: return "DDERR_CANTPAGELOCK";
    case DDERR_CANTPAGEUNLOCK: return "DDERR_CANTPAGEUNLOCK";
    case DDERR_NOTPAGELOCKED: return "DDERR_NOTPAGELOCKED";
    case DDERR_NOTINITIALIZED: return "DDERR_NOTINITIALIZED";
    case DI_NOTATTACHED: return "S_FALSE or DI_NOTATTACHED or DI_BUFFEROVERFLOW or DI_PROPNOEFFECT"; // have all the same error code: S_FALSE==1
    //case DI_BUFFEROVERFLOW: return "DI_BUFFEROVERFLOW";
    //case DI_PROPNOEFFECT: return "DI_PROPNOEFFECT";
    //case DI_NOEFFECT: return "DI_NOEFFECT";
    case DI_POLLEDDEVICE: return "DI_POLLEDDEVICE";
    case DI_DOWNLOADSKIPPED: return "DI_DOWNLOADSKIPPED";
    case DI_EFFECTRESTARTED: return "DI_EFFECTRESTARTED";
    case DI_TRUNCATED: return "DI_TRUNCATED";
    case DI_TRUNCATEDANDRESTARTED: return "DI_TRUNCATEDANDRESTARTED";
    case DIERR_OLDDIRECTINPUTVERSION: return "DIERR_OLDDIRECTINPUTVERSION";
    case DIERR_BETADIRECTINPUTVERSION: return "DIERR_BETADIRECTINPUTVERSION";
    case DIERR_BADDRIVERVER: return "DIERR_BADDRIVERVER";
    case DIERR_DEVICENOTREG: return "DIERR_DEVICENOTREG";
    case DIERR_NOTFOUND: return "DIERR_NOTFOUND or DIERR_OBJECTNOTFOUND";
    //case DIERR_OBJECTNOTFOUND: return "DIERR_OBJECTNOTFOUND";
    //case DIERR_INVALIDPARAM: return "DIERR_INVALIDPARAM";
    case DIERR_NOINTERFACE: return "DIERR_NOINTERFACE";
    //case DIERR_GENERIC: return "DIERR_GENERIC";
    //case DIERR_OUTOFMEMORY: return "DIERR_OUTOFMEMORY";
    //case DIERR_UNSUPPORTED: return "DIERR_UNSUPPORTED";
    case DIERR_NOTINITIALIZED: return "DIERR_NOTINITIALIZED";
    case DIERR_ALREADYINITIALIZED: return "DIERR_ALREADYINITIALIZED";
    case DIERR_NOAGGREGATION: return "DIERR_NOAGGREGATION";
    case DIERR_OTHERAPPHASPRIO: return "DIERR_OTHERAPPHASPRIO";
    case DIERR_INPUTLOST: return "DIERR_INPUTLOST";
    case DIERR_ACQUIRED: return "DIERR_ACQUIRED";
    case DIERR_NOTACQUIRED: return "DIERR_NOTACQUIRED";
    //case DIERR_READONLY: return "DIERR_READONLY";
    //case DIERR_HANDLEEXISTS: return "DIERR_HANDLEEXISTS";
    case E_PENDING: return "E_PENDING";
    case DIERR_INSUFFICIENTPRIVS: return "DIERR_INSUFFICIENTPRIVS";
    case DIERR_DEVICEFULL: return "DIERR_DEVICEFULL";
    case DIERR_MOREDATA: return "DIERR_MOREDATA";
    case DIERR_NOTDOWNLOADED: return "DIERR_NOTDOWNLOADED";
    case DIERR_HASEFFECTS: return "DIERR_HASEFFECTS";
    case DIERR_NOTEXCLUSIVEACQUIRED: return "DIERR_NOTEXCLUSIVEACQUIRED";
    case DIERR_INCOMPLETEEFFECT: return "DIERR_INCOMPLETEEFFECT";
    case DIERR_NOTBUFFERED: return "DIERR_NOTBUFFERED";
    case DIERR_EFFECTPLAYING: return "DIERR_EFFECTPLAYING";
    case DSERR_ALLOCATED: return "DSERR_ALLOCATED";
    case DSERR_CONTROLUNAVAIL: return "DSERR_CONTROLUNAVAIL";
    //case DSERR_INVALIDPARAM: return "DSERR_INVALIDPARAM";
    case DSERR_INVALIDCALL: return "DSERR_INVALIDCALL";
    //case DSERR_GENERIC: return "DSERR_GENERIC";
    case DSERR_PRIOLEVELNEEDED: return "DSERR_PRIOLEVELNEEDED";
    //case DSERR_OUTOFMEMORY: return "DSERR_OUTOFMEMORY";
    case DSERR_BADFORMAT: return "DSERR_BADFORMAT";
    //case DSERR_UNSUPPORTED: return "DSERR_UNSUPPORTED";
    case DSERR_NODRIVER: return "DSERR_NODRIVER";
    case DSERR_ALREADYINITIALIZED: return "DSERR_ALREADYINITIALIZED";
    //case DSERR_NOAGGREGATION: return "DSERR_NOAGGREGATION";
    case DSERR_BUFFERLOST: return "DSERR_BUFFERLOST";
    case DSERR_OTHERAPPHASPRIO: return "DSERR_OTHERAPPHASPRIO";
    case DSERR_UNINITIALIZED: return "DSERR_UNINITIALIZED";
    //case DSERR_NOINTERFACE: return "DSERR_NOINTERFACE";

    case DPERR_ALREADYINITIALIZED: return "DPERR_ALREADYINITIALIZED";
    case DPERR_ACCESSDENIED: return "DPERR_ACCESSDENIED";
    case DPERR_ACTIVEPLAYERS: return "DPERR_ACTIVEPLAYERS";
    case DPERR_BUFFERTOOSMALL: return "DPERR_BUFFERTOOSMALL";
    case DPERR_CANTADDPLAYER: return "DPERR_CANTADDPLAYER";
    case DPERR_CANTCREATEGROUP: return "DPERR_CANTCREATEGROUP";
    case DPERR_CANTCREATEPLAYER: return "DPERR_CANTCREATEPLAYER";
    case DPERR_CANTCREATESESSION: return "DPERR_CANTCREATESESSION";
    case DPERR_CAPSNOTAVAILABLEYET: return "DPERR_CAPSNOTAVAILABLEYET";
    case DPERR_EXCEPTION: return "DPERR_EXCEPTION";
    //case DPERR_GENERIC: return "DPERR_GENERIC";
    case DPERR_INVALIDFLAGS: return "DPERR_INVALIDFLAGS";
    case DPERR_INVALIDOBJECT: return "DPERR_INVALIDOBJECT";
    //case DPERR_INVALIDPARAM: return "DPERR_INVALIDPARAM";
    //case DPERR_INVALIDPARAMS: return "DPERR_INVALIDPARAMS";
    case DPERR_INVALIDPLAYER: return "DPERR_INVALIDPLAYER";
    case DPERR_INVALIDGROUP: return "DPERR_INVALIDGROUP";
    case DPERR_NOCAPS: return "DPERR_NOCAPS";
    case DPERR_NOCONNECTION: return "DPERR_NOCONNECTION";
    //case DPERR_NOMEMORY: return "DPERR_NOMEMORY";
    //case DPERR_OUTOFMEMORY: return "DPERR_OUTOFMEMORY";
    case DPERR_NOMESSAGES: return "DPERR_NOMESSAGES";
    case DPERR_NONAMESERVERFOUND: return "DPERR_NONAMESERVERFOUND";
    case DPERR_NOPLAYERS: return "DPERR_NOPLAYERS";
    case DPERR_NOSESSIONS: return "DPERR_NOSESSIONS";
    //case DPERR_PENDING: return "DPERR_PENDING";
    case DPERR_SENDTOOBIG: return "DPERR_SENDTOOBIG";
    case DPERR_TIMEOUT: return "DPERR_TIMEOUT";
    case DPERR_UNAVAILABLE: return "DPERR_UNAVAILABLE";
    //case DPERR_UNSUPPORTED: return "DPERR_UNSUPPORTED";
    case DPERR_BUSY: return "DPERR_BUSY";
    case DPERR_USERCANCEL: return "DPERR_USERCANCEL";
    //case DPERR_NOINTERFACE: return "DPERR_NOINTERFACE";
    case DPERR_CANNOTCREATESERVER: return "DPERR_CANNOTCREATESERVER";
    case DPERR_PLAYERLOST: return "DPERR_PLAYERLOST";
    case DPERR_SESSIONLOST: return "DPERR_SESSIONLOST";
    case DPERR_UNINITIALIZED: return "DPERR_UNINITIALIZED";
    case DPERR_NONEWPLAYERS: return "DPERR_NONEWPLAYERS";
    case DPERR_INVALIDPASSWORD: return "DPERR_INVALIDPASSWORD";
    case DPERR_CONNECTING: return "DPERR_CONNECTING";
    case DPERR_BUFFERTOOLARGE: return "DPERR_BUFFERTOOLARGE";
    case DPERR_CANTCREATEPROCESS: return "DPERR_CANTCREATEPROCESS";
    case DPERR_APPNOTSTARTED: return "DPERR_APPNOTSTARTED";
    case DPERR_INVALIDINTERFACE: return "DPERR_INVALIDINTERFACE";
    case DPERR_NOSERVICEPROVIDER: return "DPERR_NOSERVICEPROVIDER";
    case DPERR_UNKNOWNAPPLICATION: return "DPERR_UNKNOWNAPPLICATION";
    case DPERR_NOTLOBBIED: return "DPERR_NOTLOBBIED";
    case DPERR_SERVICEPROVIDERLOADED: return "DPERR_SERVICEPROVIDERLOADED";
    case DPERR_ALREADYREGISTERED: return "DPERR_ALREADYREGISTERED";
    case DPERR_NOTREGISTERED: return "DPERR_NOTREGISTERED";
    case DPERR_AUTHENTICATIONFAILED: return "DPERR_AUTHENTICATIONFAILED";
    case DPERR_CANTLOADSSPI: return "DPERR_CANTLOADSSPI";
    case DPERR_ENCRYPTIONFAILED: return "DPERR_ENCRYPTIONFAILED";
    case DPERR_SIGNFAILED: return "DPERR_SIGNFAILED";
    case DPERR_CANTLOADSECURITYPACKAGE: return "DPERR_CANTLOADSECURITYPACKAGE";
    case DPERR_ENCRYPTIONNOTSUPPORTED: return "DPERR_ENCRYPTIONNOTSUPPORTED";
    case DPERR_CANTLOADCAPI: return "DPERR_CANTLOADCAPI";
    case DPERR_NOTLOGGEDIN: return "DPERR_NOTLOGGEDIN";
    case DPERR_LOGONDENIED: return "DPERR_LOGONDENIED";
		case 2156: return "D3DCLEAR_ZBUFFER no zbuffer is associated with device";
		case 2154: return "D3DERR_NOTAVAILABLE";
  }
  return("unknown");
}

