; InstallerScript.nsi
;
; PolyBump Previewer Installer by Crytek
;

; The name of the installer
Name "PolyBump(tm) Previewer"

; The file to write
OutFile "PolyBumpPreviewerInstaller.exe"

; The default installation directory
InstallDir $PROGRAMFILES\PolyBumpPreviewer

; The text to prompt the user to enter a directory
DirText "Please choose the destination directory for the PolyBump(tm) Previewer"

;Installer Icon
;Icon "installer.ico"




; The stuff to install
Section "ThisNameIsIgnoredSoWhyBother?" ;  ************************************************

; Set output path to the system directory.
SetOutPath $SYSDIR

IfFileExists "$SYSDIR\MSVCP70.DLL" BranchOver1					; copy MSVCP70.DLL
  File "C:winnt\system32\MSVCP70.DLL"

BranchOver1:
IfFileExists "$SYSDIR\MSVCR70.DLL" BranchOver2					; copy MSVCR70.DLL
  File "C:winnt\system32\MSVCR70.DLL"

BranchOver2:


; Set output path to the installation directory.
  SetOutPath $INSTDIR


; Put file there
  File "PolyBumpPreviewer.exe"							; exe
  File "VariableSpecularPower.bmp"
  File "Irradiance.tga"
  File "PolyBumpDir.vsh"							; vertex shader
  File "PolyBumpPoint.vsh"
  File "StandardSpec.vsh"
  File "PolyBumpTDebug.vsh"
  File "PolyBumpDiffuseDirCM.psh"						; pixel shader
  File "PolyBumpSpecDir.psh"
  File "PolyBumpSpecDirCM.psh"
  File "PolyBumpTDebug.psh"
  File /r "InstallerData\*.*"

; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\PolyBumpMAXPlugin" "DisplayName" "PolyBump Previewer (remove only)"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\PolyBumpMAXPlugin" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteUninstaller "uninstall.exe"

; Shortcuts
  CreateDirectory "$SMPROGRAMS\Crytek\Polybump Previewer"
  CreateShortCut "$SMPROGRAMS\Crytek\Polybump Previewer\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\Crytek\Polybump Previewer\Readme.lnk" "$INSTDIR\PolyBumpPreviewer Product.pdf" "" "$INSTDIR\PolyBumpPreviewer Product.pdf" 0
  CreateShortCut "$SMPROGRAMS\Crytek\Polybump Previewer\PolyBump Previewer.lnk" "$INSTDIR\PolyBumpPreviewer.exe" "" "$INSTDIR\PolyBumpPreviewer.exe" 0


SectionEnd ; end the section **************************************************************






; uninstall stuff

UninstallText "This will uninstall PolyBump(tm) Previewer. Hit next to continue."

; special uninstall section.
Section "Uninstall"
  ; remove registry keys
;  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\PolyBumpMAXPlugin"
;  DeleteRegKey HKEY_CURRENT_USER "SOFTWARE\Crytek\PolyBumpMAXPlugin"
  ; remove files


  RMDir /r "$INSTDIR"

  ; MUST REMOVE UNINSTALLER, too
  Delete $INSTDIR\uninstall.exe
  ; remove shortcuts, if any.
  Delete "$SMPROGRAMS\Crytek\Polybump Previewer\*.*"
  ; remove directories used.
  RMDir "$SMPROGRAMS\Crytek\Polybump Previewer"
  RMDir "$SMPROGRAMS\Crytek"
SectionEnd




; eof
