#pragma once

class Vec3d_tpl;


// Helper class for storing compressed (3Bytes) base vectors for Clone-Space bumpmapping
// 
// part of Crytek Polybump
// 
// written by Martin Mittring
//

class CPBCloneMapDest
{
public:

	//! constructor
									CPBCloneMapDest		( void );

	//! destructor
	virtual					~CPBCloneMapDest	( void );

	//! load the clonemap (same directory and filename (except extension) as objectspace bumpmap is recommended)
	//! /param inszFileName pointer to the zero terminated filename (e.g. "C:\temp\Normalmap.cln" )
	//! /return true=map was loaded successfully, false=load failed
	bool						LoadCloneMap			( const char *inszFileName );

	//! get the base for a UV triangle definition
	//! /param infU x position in texture (0..1) without range restrictions (currently unchecked for negative values)
	//! /param infV y position in texture (0..1) without range restrictions (currently unchecked for negative values)
	//! /param outvBaseA output orthonormal base first vector
	//! /param outvBaseB output orthonormal base second vector
	//! /param outvBaseC output orthonormal base third vector
	//! /return true=operation was successful, false=otherwise
	bool						Get								( float infU[3], float infV[3], float outvBaseA[3], float outvBaseB[3], float outvBaseC[3] );

	//! free the 
	void						FreeData					( void );

	//!
	bool						IsAvailable				( void );

	// attributes *************************************************************************

	//!
	DWORD						GetWidth					( void );

	//!
	DWORD						GetHeight					( void );

private:

	DWORD *		m_pBitmap;						//! Bitmap with orthonormal base vectors (stored as 0RGB Color)
	DWORD			m_dwBitmapWidth;			//! width of the m_pBitmap bitmap
	DWORD			m_dwBitmapHeight;			//! height of the m_pBitmap bitmap

	//!
	bool						Create						( DWORD indwWidth, DWORD indwHeight );
};
