// ProcessorClock.h: Schnittstelle fr die Klasse CProcessorClock.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PROCESSORCLOCK_H__36C3223F_1CA8_44B3_B82F_2AFE1B892F7A__INCLUDED_)
#define AFX_PROCESSORCLOCK_H__36C3223F_1CA8_44B3_B82F_2AFE1B892F7A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <windows.h>
#include <winnt.h>
// erst ab Pentium funktionsfhig

class CProcessorClock  
{
public:

	//! constructor
									CProcessorClock				( void );

	//! destructor
	virtual					~CProcessorClock			( void );

	//! Init (set time=0)
	//! \return true=success, false=failed(no CPU with PerformanceCounter)
	bool						Init									( void );

	//! get ms value
	DWORD						GetActualTime					( void );		

	//! get 1/100 ms value
	DWORD						GetActualTimem100			( void );		

	//! get time in the internal precicion (use with GetDifference100() )
	LARGE_INTEGER		GetActualTimeAccurate	( void );

	//! (CurrentTime - )/m_PerformanceFrequency
	//! \return difference time in 1/100 ms (minimum=1)
	DWORD						GetDifference100		( LARGE_INTEGER inSavedTime );

private:

	LARGE_INTEGER				m_PerformanceFrequency;					//!< CPU ticks per second
	LARGE_INTEGER				m_PerformanceLevelStart;				//!< CPU start time
};



extern CProcessorClock MyProcessorClock;

#endif // !defined(AFX_PROCESSORCLOCK_H__36C3223F_1CA8_44B3_B82F_2AFE1B892F7A__INCLUDED_)
