#include "stdafx.h"										// precompiled headers
#include "SimpleTriangleFiller.h"			// CSimpleTriangleFiller
#include <math.h>											// sqrt()
#include <assert.h>										// assert()
//#include <limits.h>										// FLT_MAX

#define FLT_MAX 3.402823466e+38F


/* Draws a flat shaded horizontal line
*
* Arguments:
*  pixels                      - pointer to an 320*200 array of color triplets+alpha
*  x1, x2, y                   - defines the position and size of the line
*  r, g, b                     - color for the line
*
**/

//! /param x1 included
//! /param x1 excluded
_forceinline void lambertHorizline( DWORD *pBuffer, DWORD indwWidth, DWORD indwHeight, int x1, int x2, int y, 
																	 CSimpleTriangleFiller::CPixelCallback *inpCallback ) 
{
	if((DWORD)y>=(DWORD)indwHeight)return;

	if(x1<0)x1=0;
	if(x2>(int)indwWidth)x2=indwWidth;

	DWORD *pStart=&pBuffer[x1+y*indwWidth];

	for(int x=x1;x<x2;x++)
		inpCallback->ReturnPixel(x,y,*pStart++);
}



void CSimpleTriangleFiller::CallbackFill( DWORD *pBuffer, DWORD indwWidth, DWORD indwHeight, 
														float x1, float y1, float x2, float y2, float x3, float y3,
														CPixelCallback *inpSink, bool inbConservative ) 
{
	// Sort the coordinates, so that (x1, y1) becomes the highest coord
	float tmp;
	if(y1>y2) 
	{
		if (y2>y3) 
		{
			tmp=y1;y1=y2;y2=tmp;
			tmp=x1;x1=x2;x2=tmp;
			tmp=y2;y2=y3;y3=tmp;
			tmp=x2;x2=x3;x3=tmp;

			if (y1>y2) 
			{
				tmp=y1;y1=y2;y2=tmp;
				tmp=x1;x1=x2;x2=tmp;                            
			}
		} 
		else 
		{
			tmp=y1;y1=y2;y2=tmp;
			tmp=x1;x1=x2;x2=tmp;

			if (y2>y3)
			{
				tmp=y2;y2=y3;y3=tmp;
				tmp=x2;x2=x3;x3=tmp;                            
			}
		}
	} 
	else
	{
		if (y2>y3) 
		{
			tmp=y2;y2=y3;y3=tmp;
			tmp=x2;x2=x3;x3=tmp;

			if (y1>y2)
			{
				tmp=y1;y1=y2;y2=tmp;
				tmp=x1;x1=x2;x2=tmp;                            
			}
		}
	}

	if(inbConservative)
	{
/*
#ifdef _DEBUG
		bool bCornerHit[3]={ false, false, false };
#endif //_DEBUG
*/

//		if(fmodf(y1,1.0f)==0.0f)y1-=0.0001f;

		// Calculate interpolation steps
		float fX1toX2step=0.0f;	if(y2-y1!=0.0f)fX1toX2step=(x2-x1)/(float)(y2-y1);
		float fX1toX3step=0.0f; if(y3-y1!=0.0f)fX1toX3step=(x3-x1)/(float)(y3-y1);
		float fX2toX3step=0.0f;	if(y3-y2!=0.0f)fX2toX3step=(x3-x2)/(float)(y3-y2);


		// Go through the scanlines of the triangle
		float fX1toX2=x1, fX1toX3=x1, fX2toX3=x2;
		bool bFirstLine=true;

		for(int y=(int)floor(y1); y<=(int)floor(y3); y++) 
		{
			float fSubPixelYStart=0.0f,fSubPixelYEnd=1.0f;
			float start,end;

			// first line
			if(bFirstLine)
			{
				fSubPixelYStart=fmodf(y1,1.0f);
				start=x1;end=x1;bFirstLine=false;
			}
			else
			{
				// top part without middle corner line
				if(y<=(int)floor(y2))
				{
					start=min(fX1toX2,fX1toX3);end=max(fX1toX2,fX1toX3);
				}
				else
				{
					start=min(fX2toX3,fX1toX3);end=max(fX2toX3,fX1toX3);
				}
			}

			// middle corner line
			if(y==(int)floor(y2))
			{
				fSubPixelYEnd=fmodf(y2,1.0f);

				fX1toX3+=fX1toX3step*(fSubPixelYEnd-fSubPixelYStart);
				start=min(start,fX1toX3);end=max(end,fX1toX3);
				start=min(start,x2);end=max(end,x2);

				fSubPixelYStart=fSubPixelYEnd;fSubPixelYEnd=1.0f;
			}

			// last line
			if(y==(int)floor(y3))
			{
				start=min(start,x3);end=max(end,x3);
			}
			else
			{
				// top part without middle corner line
				if(y<(int)floor(y2))
				{
					fX1toX2+=fX1toX2step*(fSubPixelYEnd-fSubPixelYStart);
					start=min(start,fX1toX2);end=max(end,fX1toX2);
				}
				else
				{
					fX2toX3+=fX2toX3step*(fSubPixelYEnd-fSubPixelYStart);
					start=min(start,fX2toX3);end=max(end,fX2toX3);
				}

				fX1toX3+=fX1toX3step*(fSubPixelYEnd-fSubPixelYStart);
				start=min(start,fX1toX3);end=max(end,fX1toX3);
			}
/*
#ifdef _DEBUG
			if(y==(int)floor(y1) && (int)floor(x1)>=(int)start && (int)floor(x1)<=(int)floor(end)+1)
				bCornerHit[0]=true;

			if(y==(int)floor(y2) && (int)floor(x2)>=(int)start && (int)floor(x2)<=(int)floor(end)+1)
				bCornerHit[1]=true;

			if(y==(int)floor(y3) && (int)floor(x3)>=(int)start && (int)floor(x3)<=(int)floor(end)+1)
				bCornerHit[2]=true;
#endif //_DEBUG
*/
			inpSink->ReturnLine(start,end,y);
			lambertHorizline(pBuffer,indwWidth,indwHeight,(int)floor(start),(int)floor(end)+1,y,inpSink);
		}
/*
#ifdef _DEBUG
		assert(bCornerHit[0]);
		assert(bCornerHit[1]);
		assert(bCornerHit[2]);
#endif //_DEBUG
*/
	}
	else	// !inbConservative
	{
		y1-=0.5f;y2-=0.5f;y3-=0.5f;

		if(fmodf(y1,1.0f)==0.0f)y1-=0.0001f;

		// Calculate interpolation steps
		float fX1toX2step=0.0f;	if(y2-y1!=0.0f)fX1toX2step=(x2-x1)/(float)(y2-y1);
		float fX1toX3step=0.0f; if(y3-y1!=0.0f)fX1toX3step=(x3-x1)/(float)(y3-y1);
		float fX2toX3step=0.0f;	if(y3-y2!=0.0f)fX2toX3step=(x3-x2)/(float)(y3-y2);


		// Go through the scanlines of the triangle
		float fX1toX2=x1, fX1toX3=x1, fX2toX3=x2;
		bool bFirstLine=true;

		for(int y=(int)floor(y1); y<=(int)floor(y3); y++) 
		{
			float fSubPixelYStart=0.0f,fSubPixelYEnd=1.0f;
			float start,end;

			// first line
			if(bFirstLine)
			{
				fSubPixelYStart=fmodf(y1,1.0f);
				start=x1;end=x1;bFirstLine=false;
			}
			else
			{
				// top part without middle corner line
				if(y<=(int)floor(y2))
				{
					start=min(fX1toX2,fX1toX3);end=max(fX1toX2,fX1toX3);
				}
				else
				{
					start=min(fX2toX3,fX1toX3);end=max(fX2toX3,fX1toX3);
				}
			}

			// middle corner line
			if(y==(int)floor(y2))
			{
				fSubPixelYEnd=fmodf(y2,1.0f);

				fX1toX3+=fX1toX3step*(fSubPixelYEnd-fSubPixelYStart);

				fSubPixelYStart=fSubPixelYEnd;fSubPixelYEnd=1.0f;
			}

			// last line
			if(y!=(int)floor(y3))
			{
				// top part without middle corner line
				if(y<(int)floor(y2))
				{
					fX1toX2+=fX1toX2step*(fSubPixelYEnd-fSubPixelYStart);
				}
				else
				{
					fX2toX3+=fX2toX3step*(fSubPixelYEnd-fSubPixelYStart);
				}

				fX1toX3+=fX1toX3step*(fSubPixelYEnd-fSubPixelYStart);
			}

			if(start!=end)
			{
				inpSink->ReturnLine(start,end,y);
				lambertHorizline(pBuffer,indwWidth,indwHeight,(int)floor(start+0.5f),(int)floor(end-0.5f),y,inpSink);
			}
		}
	}
}


// shrink triangle by n pixel, optimizable
void CSimpleTriangleFiller::ShrinkTriangle( float inoutfX[3], float inoutfY[3], float infAmount )
{
	float fX[3]={ inoutfX[0], inoutfX[1], inoutfX[2] };
	float fY[3]={ inoutfY[0], inoutfY[1], inoutfY[2] };

	/* 
	// move edge to opposing vertex
	float dx,dy,fLength;

	for(int a=0;a<3;a++)
	{
		int b=a+1;if(b>=3)b=0;
		int c=b+1;if(c>=3)c=0;

		dx=fX[a]-(fX[b]+fX[c])*0.5f;
		dy=fY[a]-(fY[b]+fY[c])*0.5f;
		fLength=(float)sqrt(dx*dx+dy*dy);
		if(fLength>1.0f)
		{
			dx/=fLength;dy/=fLength;
			inoutfX[b]+=dx;inoutfY[b]+=dy;
			inoutfX[c]+=dx;inoutfY[c]+=dy;
		}
	}
	*/

	/*
	// move vertex to opposing edge
	float dx,dy,fLength;

	for(int a=0;a<3;a++)
	{
		int b=a+1;if(b>=3)b=0;
		int c=b+1;if(c>=3)c=0;

		dx=fX[a]-(fX[b]+fX[c])*0.5f;
		dy=fY[a]-(fY[b]+fY[c])*0.5f;
		fLength=(float)sqrt(dx*dx+dy*dy);
		if(fLength>1.0f)
		{
			dx/=fLength;dy/=fLength;
			inoutfX[a]-=dx;inoutfY[a]-=dy;
		}
	}
	*/

	// move vertex to get edges shifted perpendicual for 1 unit	
	for(int a=0;a<3;a++)
	{
		float dx1,dy1,dx2,dy2,fLength;

		int b=a+1;if(b>=3)b=0;
		int c=b+1;if(c>=3)c=0;

		dx1=fX[b]-fX[a];
		dy1=fY[b]-fY[a];
		fLength=(float)sqrt(dx1*dx1+dy1*dy1);
		if(infAmount>0)if(fLength<infAmount)continue;
		if(fLength==0.0f)continue;
		dx1/=fLength;dy1/=fLength;
		
		dx2=fX[c]-fX[a];
		dy2=fY[c]-fY[a];
		fLength=(float)sqrt(dx2*dx2+dy2*dy2);
		if(infAmount>0)if(fLength<infAmount)continue;
		if(fLength==0.0f)continue;
		dx2/=fLength;dy2/=fLength;
		
		inoutfX[a]+=(dx1+dx2)*infAmount;inoutfY[a]+=(dy1+dy2)*infAmount;
	}
}
