/***SDOF***********************************************************************
 *
 *                           UbiSoft Development Network
 *                           ---------------------------
 *
 * FILE........: version_manager.h
 *
 * DESCRIPTION.: This file is used to manage version of linked library module
 *               in executable.
 *               The class CModuleInfo manage module information and the
 *               class CGSVersion manages the version for linked modules.
 *               This file was generated by a script for version management.
 *               If you have problems with this file, you should contact
 *               Guillaume Plante at gplante@ubisoft.com.
 *
 ******************************************************************************
 *                                  FILE HISTORY
 ******************************************************************************
 *
 * DATE........: 2002/3/25 @ 16:44
 * AUTHOR......: gplante
 * DESCRIPTION.: Automatic generation
 *
 ***********************************************************************EDOF***/

// length defines
#define LIBSTRINGSIZE	70
#define INTROSTRINGSIZE	150

// generic headers
#include "GSTypes.h"

#include <cstdio>
#include <cstring>

// different library version definition
#include "version_libgschat.h"
#include "version_libgsclient.h"
#include "version_libgsclinkc.h"
#include "version_libgsclinkg.h"
#include "version_libgsgame.h"
#include "version_libgsgamestarter.h"
#include "version_libgslobbylan.h"
#include "version_libgsmsclient.h"
#include "version_libgsregserver.h"
#include "version_libgspeergame.h"
#include "version_libgsscore.h"
#include "version_libgsadmin.h"
#include "version_libgsconnect.h"
#include "version_libgsgameserver.h"
#include "version_libgslauncher.h"
#include "version_libgsmodule.h"
#include "version_libgsproxyclient.h"
#include "version_libgsresult.h"
#include "version_libgssocket.h"
#include "version_libgsthreads.h"
#include "version_libgsutility.h"
#include "version_libgscsp.h"
#include "version_libgsdatacontainer.h"
#include "version_libgsz.h"
#include "version_libgscdkey.h"
#include "version_libgscrypto.h"
#include "version_libgshttp.h"
#include "version_libgsnat.h"

//=============================================================================
// CLASS:     CModuleInfo
//
// DESCRIPTION: Manage the module information
//=============================================================================
class CModuleInfo
{
public:
        // pointer to the next module class
	CModuleInfo *m_Next;

	CModuleInfo(GSchar *szModuleName,GSuint uiModuleVersion)
	{
		m_Next = NULL;
		strncpy(m_szModuleName,szModuleName,31);
		m_uiModuleVersion = uiModuleVersion;
	};
	~CModuleInfo()
	{
		if(m_Next) delete m_Next;
		m_Next = NULL;
	};
	GSchar *GetModuleName(){return m_szModuleName;};
	GSuint GetModuleVersion(){return m_uiModuleVersion;};

private:
	GSchar m_szModuleName[32];
	GSuint m_uiModuleVersion;
};

//=============================================================================
// CLASS:     CGSVersion
//
// DESCRIPTION: Manage the module version
//=============================================================================
class CGSVersion
{
	public:
	CGSVersion()
	{
		m_ModuleHead = m_ModuleEnd = NULL;
		m_ubNbrModule = 0;

		#ifdef VERSION_LIBGSCHAT
			AddModule("libgschat",VERSION_LIBGSCHAT);
		#endif

		#ifdef VERSION_LIBGSCLIENT
			AddModule("libgsclient",VERSION_LIBGSCLIENT);
		#endif

		#ifdef VERSION_LIBGSCLINKC
			AddModule("libgsclinkc",VERSION_LIBGSCLINKC);
		#endif

		#ifdef VERSION_LIBGSCLINKG
			AddModule("libgsclinkg",VERSION_LIBGSCLINKG);
		#endif

		#ifdef VERSION_LIBGSGAME
			AddModule("libgsgame",VERSION_LIBGSGAME);
		#endif

		#ifdef VERSION_LIBGSGAMESTARTER
			AddModule("libgsgamestarter",VERSION_LIBGSGAMESTARTER);
		#endif

		#ifdef VERSION_LIBGSLOBBYLAN
			AddModule("libgslobbylan",VERSION_LIBGSLOBBYLAN);
		#endif

		#ifdef VERSION_LIBGSMSCLIENT
			AddModule("libgsmsclient",VERSION_LIBGSMSCLIENT);
		#endif

		#ifdef VERSION_LIBGSREGSERVER
			AddModule("libgsregserver",VERSION_LIBGSREGSERVER);
		#endif

		#ifdef VERSION_LIBGSPEERGAME
			AddModule("libgspeergame",VERSION_LIBGSPEERGAME);
		#endif

		#ifdef VERSION_LIBGSSCORE
			AddModule("libgsscore",VERSION_LIBGSSCORE);
		#endif

		#ifdef VERSION_LIBGSADMIN
			AddModule("libgsadmin",VERSION_LIBGSADMIN);
		#endif

		#ifdef VERSION_LIBGSCONNECT
			AddModule("libgsconnect",VERSION_LIBGSCONNECT);
		#endif

		#ifdef VERSION_LIBGSGAMESERVER
			AddModule("libgsgameserver",VERSION_LIBGSGAMESERVER);
		#endif

		#ifdef VERSION_LIBGSLAUNCHER
			AddModule("libgslauncher",VERSION_LIBGSLAUNCHER);
		#endif

		#ifdef VERSION_LIBGSMODULE
			AddModule("libgsmodule",VERSION_LIBGSMODULE);
		#endif

		#ifdef VERSION_LIBGSPROXYCLIENT
			AddModule("libgsproxyclient",VERSION_LIBGSPROXYCLIENT);
		#endif

		#ifdef VERSION_LIBGSRESULT
			AddModule("libgsresult",VERSION_LIBGSRESULT);
		#endif

		#ifdef VERSION_LIBGSSOCKET
			AddModule("libgssocket",VERSION_LIBGSSOCKET);
		#endif

		#ifdef VERSION_LIBGSTHREADS
			AddModule("libgsthreads",VERSION_LIBGSTHREADS);
		#endif

		#ifdef VERSION_LIBGSUTILITY
			AddModule("libgsutility",VERSION_LIBGSUTILITY);
		#endif

		#ifdef VERSION_LIBGSCSP
			AddModule("libgscsp",VERSION_LIBGSCSP);
		#endif

		#ifdef VERSION_LIBGSDATACONTAINER
			AddModule("libgsdatacontainer",VERSION_LIBGSDATACONTAINER);
		#endif

		#ifdef VERSION_LIBGSCRYPTO
			AddModule("libgscrypto",VERSION_LIBGSCRYPTO);
		#endif

		#ifdef VERSION_LIBGSCDKEY
			AddModule("libgscdkey",VERSION_LIBGSCDKEY);
		#endif

    #ifdef VERSION_LIBGSHTTP
        AddModule("libgshttp",VERSION_LIBGSHTTP);
    #endif
		
    #ifdef VERSION_LIBGSNAT
        AddModule("libgsnat",VERSION_LIBGSNAT);
    #endif
    }

    ~CGSVersion()
	{
		// delete previously stored object
		if(m_ModuleHead) delete m_ModuleHead;
		m_ModuleHead = m_ModuleEnd = NULL;
	}
	// print all registered module name and version
	GSbool PrintModulesVersion(GSchar *szBuffer = NULL,GSuint *puiBufSize = NULL);

private:
	// add a module to the module list
	GSvoid AddModule(GSchar *szModuleName,GSuint uiModuleVersion);
	CModuleInfo *m_ModuleHead;
	CModuleInfo *m_ModuleEnd;
	GSubyte m_ubNbrModule;
};

GSvoid CGSVersion::AddModule(GSchar *szModuleName,GSuint uiModuleVersion)
{
	CModuleInfo *_modinfo = new CModuleInfo(szModuleName,uiModuleVersion);
	++m_ubNbrModule;
	if(!m_ModuleHead)
	  m_ModuleHead = m_ModuleEnd = _modinfo;
	else
	  m_ModuleEnd = m_ModuleEnd->m_Next = _modinfo;
}

GSbool CGSVersion::PrintModulesVersion(GSchar *szBuffer,GSuint *puiBufSize)
{
	CModuleInfo *m_ModuleIt = m_ModuleHead;

	// in that case, print to stdout
	if((!szBuffer)&&(!puiBufSize))
	{
		printf("\n--- Begin Module Version Output ---\r\n\r\n");
		if(!m_ubNbrModule)
		{
		     printf(" - no linked gs library. \r\n");
		}
		else
		{

			while(m_ModuleIt != NULL)
			{
				printf(" - library: %s  -> version: %d\r\n",m_ModuleIt->GetModuleName(),
						m_ModuleIt->GetModuleVersion());
				m_ModuleIt =  m_ModuleIt->m_Next;
			}
		}
		printf("\r\n--- End Module Version Output ---\r\n\r\n");
		return GS_TRUE;
	}
	if(puiBufSize)
	{
		if(szBuffer)
		{
			sprintf(szBuffer,"--- Begin Module Version Output ---\r\n\r\n");
			if(!m_ubNbrModule)
			{
				strcat(szBuffer," - no linked gs library. \r\n");
			}
			else
			{
				while(m_ModuleIt != NULL)
			  {
					GSchar szTemp[LIBSTRINGSIZE];
					#ifdef GS_WIN32
					_snprintf(szTemp,LIBSTRINGSIZE," - library: %s  -> version: %d\r\n",
							m_ModuleIt->GetModuleName(),m_ModuleIt->GetModuleVersion());
					#else
					snprintf(szTemp,LIBSTRINGSIZE," - library: %s  -> version: %d\r\n",
							m_ModuleIt->GetModuleName(),m_ModuleIt->GetModuleVersion());
					#endif
					szTemp[LIBSTRINGSIZE-1] = 0;
					strcat(szBuffer,szTemp);
					m_ModuleIt =  m_ModuleIt->m_Next;
				}
		 	}
			strcat(szBuffer,"\r\n--- End Module Version Output ---\r\n");
			return GS_TRUE;
		}
		else  // return the size of the needed buffer
		{
			*puiBufSize = (INTROSTRINGSIZE+(LIBSTRINGSIZE*m_ubNbrModule));
			return GS_TRUE;
		}
	}
	return GS_TRUE;
}
