#include "stdafx.h"
#include "CNP.h"
#include "serversnooper.h"

#ifdef _DEBUG
static char THIS_FILE[] = __FILE__;
#define DEBUG_CLIENTBLOCK new( _NORMAL_BLOCK, THIS_FILE, __LINE__) 
#define new DEBUG_CLIENTBLOCK
#endif

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////
CServerSnooper::CServerSnooper(void)
{
	m_pSink=NULL;
}
/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////
CServerSnooper::~CServerSnooper(void)
{
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////
bool CServerSnooper::Init(IServerSnooperSink *pSink)
{
	m_pSink=pSink;
	if(NET_FAILED(m_socket.Create()))
		return false;
	return true;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////
void CServerSnooper::SearchForLANServers(unsigned int nTime)
{
	CStream stm;
	CQPInfoRequest cqpInfoRequest("status");

	CIPAddress ipMulticastAddress(SERVER_MULTICAST_PORT,SERVER_MULTICAST_ADDRESS);	
	cqpInfoRequest.Save(stm);
	m_nStartTime=nTime;
	m_socket.Send(stm.GetPtr(),BITS2BYTES(stm.GetSize()),&ipMulticastAddress);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////
void CServerSnooper::Update(unsigned int nTime)
{
	int nRecvBytes;
	m_nCurrentTime=nTime;
	static CStream buf;
	static CIPAddress ipFrom;
	do{
		buf.Reset();
		nRecvBytes=0;
		m_socket.Receive(buf.GetPtr(),
			(int)BITS2BYTES(buf.GetAllocatedSize()),
			nRecvBytes,
			ipFrom);
/////////////////////////////////////////////////////////
		if(nRecvBytes>0)
		{
			buf.SetSize(BYTES2BITS(nRecvBytes));
			ProcessPacket(buf,ipFrom);
		}
	}while(nRecvBytes>0);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////
void CServerSnooper::ProcessPacket(CStream &stmPacket,CIPAddress &ip)
{
	CNP cnp;
	cnp.LoadAndSeekToZero(stmPacket);

	if(cnp.m_cFrameType == FT_CQP_INFO_RESPONSE)
	{
		CQPInfoResponse cqpInfoResponse;

		cqpInfoResponse.Load(stmPacket);

		if(m_pSink)
			m_pSink->OnServerFound(ip, cqpInfoResponse.szResponse, m_nCurrentTime-m_nStartTime);
	}
}
