
#include "glover.h"


//#define ANIM_PRINTF if(anim==anim_to_log)PRINTF

//ACTOR_ANIMATION
void	ClearAnimQueue(ACTOR_ANIMATION *anim)
{
	ULONG	loop;

	for (loop=0;loop<ANIM_QUEUE_LENGTH;loop++)
	{
		anim->queueAnimation[loop]=-1;
		anim->queueLoopAnimation[loop]=-1;
		anim->queueAnimationSpeed[loop]=-1;
	}
	anim->numAnimations=0;
}
/////////////////////////////////////////////////////////////////////////////////

void	AddToQueue(ACTOR_ANIMATION *anim,USHORT animNum,BOOL loop,BOOL queue,SHORT speed)
{
	AnimType	*animInfo=anim->animInfo;

	if (anim->numAnimations==ANIM_QUEUE_LENGTH+1)
	{
#ifdef ANIM_PRINTF
		ANIM_PRINTF("anim error queue overflow\n");
#endif
//		return;
		anim->numAnimations = ANIM_QUEUE_LENGTH;	// make sure that what we asked for does, in fact, get queued
	}
	if (anim->numAnimations==0 || queue==NO)
	{
		anim->currentAnimation=animNum;
		anim->loopAnimation=loop;
		animInfo->num = (animNum);
		animInfo->length = animInfo->segInfo[(animNum)].segEnd-animInfo->segInfo[(animNum)].segStart;
		animInfo->frame = 0;
		animInfo->frameFixed = 0;
		animInfo->inc = 1;
		animInfo->speed = speed;
		anim->numAnimations=1;
		if (speed<0)
		{
			animInfo->frame = animInfo->length;		// If speed -ve animation will go backwards
			animInfo->frameFixed = animInfo->length*4096;
			animInfo->inc = -1;
			animInfo->speed = -speed;
		}
	}
	else
	{
		int i;

// ensure all previous animations in the queue are non-looping, so they run smoothly into this one
		anim->loopAnimation = 0;
		for(i = 0; i < anim->numAnimations-1; i++)
		{
			anim->queueLoopAnimation[ i ]=0;
		}

		anim->queueAnimation[ anim->numAnimations-1 ]=animNum;
		anim->queueLoopAnimation[ anim->numAnimations-1 ]=loop;
		anim->queueAnimationSpeed[ anim->numAnimations-1 ]=speed;
		anim->numAnimations++;
	}
#ifdef ANIM_PRINTF
	ANIM_PRINTF(" Added anim %d (loop %d queue %d) -> Numanims = %d\n",animNum, loop, queue, anim->numAnimations);
#endif
}

/////////////////////////////////////////////////////////////////////////////////

SHORT	animate(ACTOR_ANIMATION *anim)
{
	AnimType			*animInfo=anim->animInfo;
	objectSegDataType	*seg=anim->animInfo->segInfo;
	UBYTE				endFlag=FALSE;
	USHORT				loop;


	if(gameCtrl.gameActive==FALSE)
	{
		return anim->animInfo->frame + anim->animInfo->segInfo[anim->currentAnimation].segStart;
	}



	animInfo->frameFixed += animInfo->inc*animInfo->speed;
	if ( (animInfo->frameFixed/4096>=(animInfo->length+1)) && (animInfo->inc==1) ) endFlag=TRUE;
	if ( (animInfo->frameFixed/4096<=0) && (animInfo->inc==-1) ) endFlag=TRUE;
//	animInfo->frame = (animInfo->frameFixed/4096)% (animInfo->length+1);


	if ( endFlag )
	{	// reached end of sequence
		// check for loop

#ifdef ANIM_PRINTF
		ANIM_PRINTF("  Anim %d ended\n",anim->currentAnimation);
#endif
		if (anim->loopAnimation>0)
		{
#ifdef ANIM_PRINTF
			ANIM_PRINTF("  Anim looping\n");
#endif
//			printf ("looping segment\n");
			animInfo->frame =0;//-= animInfo->length;
			animInfo->frameFixed=0;
		}
		else // no loops to go
		{
//			if (anim->numAnimations==0)
			if (anim->numAnimations <= 1)	// 1,not zero. See AddToQueue - numAnims is 1 when the only one's the one playing
			{
//				printf ("  error in animate no more anims\n");
// dump it in a static pose at the end of whatever it was doing
//				ANIM_PRINTF ("  Holding at end of anim\n");
				if(animInfo->inc == 1)
				{
					animInfo->frameFixed = animInfo->length << 12;
					animInfo->frame = animInfo->length;

				}
				else
				{
					animInfo->frameFixed = animInfo->frame = 0;
				}
			}
			else
			{
#ifdef ANIM_PRINTF
				ANIM_PRINTF("  switching to anim %d... numanimations = %d\n",anim->queueAnimation[0],anim->numAnimations);
#endif
//				printf ("changing segment \n");
				anim->currentAnimation = anim->queueAnimation[0];//actorAnim;
				anim->loopAnimation = anim->queueLoopAnimation[0];//loop;
				anim->animationSpeed = anim->queueAnimationSpeed[0];//speed;
				anim->numAnimations--;

				animInfo->num = anim->currentAnimation;
				animInfo->frame = animInfo->frameFixed = 0;
				animInfo->length = animInfo->segInfo[animInfo->num].segEnd-animInfo->segInfo[animInfo->num].segStart;
				animInfo->inc = 1;
				animInfo->speed = anim->animationSpeed;//GLOBALSPEED;

				if (anim->animationSpeed<0)
				{
					animInfo->frame = animInfo->length;		// If speed -ve animation will go backwards
					animInfo->frameFixed = animInfo->length*4096;
					animInfo->inc = -1;
					animInfo->speed = -anim->animationSpeed;
				}
				for(loop = 0;loop < ANIM_QUEUE_LENGTH - 1;loop++)
				{
					anim->queueAnimation[loop] = anim->queueAnimation[loop + 1];
					anim->queueLoopAnimation[loop] = anim->queueLoopAnimation[loop + 1];
					anim->queueAnimationSpeed[loop] = anim->queueAnimationSpeed[loop + 1];
				}
			}
		}
	}
	else
	{
		animInfo->frame = (animInfo->frameFixed/4096)% (animInfo->length+1);
	}
//	printf ("frame num %d \n",(animInfo->frame+seg[anim->currentAnimation].segStart) );
#ifdef ANIM_PRINTF
	ANIM_PRINTF("   frame %d (%d)\n",animInfo->frame, animInfo->frame+seg[anim->currentAnimation].segStart);
#endif
	return (animInfo->frame+seg[anim->currentAnimation].segStart);
}