enum
{
	BALL_MODE_NORMAL,
	BALL_MODE_BOWLING,
	BALL_MODE_POWER,
	BALL_MODE_BEARING,
	BALL_MODE_BEACH,
	BALL_MODE_SNOW,
	BALL_MODE_CRYSTAL,
	NUM_BALL_MODES
};

typedef struct _BallCtrl
{
	VECTOR	squash;
	VECTOR	expand;
	VECTOR	squashUpdate;
	VECTOR	expandUpdate;
	VECTOR	squashDelta;
	VECTOR	expandDelta;
	int		waterHeight;
	SHORT	type;
	SHORT	lastType;
	USHORT	ballOnGround;
	USHORT	ballCloseToHand;
	USHORT	ballStopMove;
	USHORT	nextHitCount;
	SHORT	ballBob;
	//SHORT	ballBobVel;
	UBYTE	inWaterFlag;
	UBYTE	hurt;
	UBYTE	health;
//	VECTOR	holdPos;
//	USHORT	flag;
//	SHORT	squashX;
//	SHORT	squashY;
//	SHORT	squashZ;
//	SHORT	squashXupdate;
//	SHORT	squashYupdate;
//	SHORT	squashZupdate;
//	SHORT	squashXdelta;
//	SHORT	squashYdelta;
//	SHORT	squashZdelta;
//	SHORT	squashXdir;
//	SHORT	squashYdir;
//	SHORT	squashZdir;

}BALLCTRL;

#define	BALLTHROWSPEED	4096*8
#define	BALLCHANGERATE	5
#define	BALLDAMPENRATE	3584
#define	DAMPSTOP		256
#define	HITMOVESPEED	4096*12

extern SPRITE	*ballTex[7];

extern BEHAVIOUR_PHYSICS	BallBehaviour[NUM_BALL_MODES];

extern	BALLCTRL	BallCtrl;
extern	VECTOR		ballOldPos;

extern	char *ballNames[];
void	Load_And_Init_Ball();

void	ChangeBall(NEWOBJECT *world ,SPRITE *spr);
void ballHitBySpell(int spell_type);

long	BallCloseToHand(void);
void	moveBall(SHORT upDown,SHORT leftRight);

void	BallApplySquash(void);
void	BallUpdateSquash(void);
void	resetBall(void);

void	UpdateBallPos(void);
void	doBallHurt(void);
void	doBallBurst(void);