 
///////////////////////////////////////////////////////////////////////////////

#ifndef __H_CAMERA
#define __H_CAMERA

///////////////////////////////////////////////////////////////////////////////

//	Camera modes
#define	FAR		0
#define	MIDDLE	1
#define	CLOSE	2
#define	ZOOM	3
#define	SPECIAL	4

//	Camera targets
#define	GLOVE	0
#define	BALL	1

// Camera heights (mode dependant)
#define	FARHEIGHT		400/4
#define	MIDDLEHEIGHT	300/4
#define	CLOSEHEIGHT		200/4
#define ZOOMHEIGHT		10

#define	FARDISTANCE		800/4
#define	MIDDLEDISTANCE	600/4
#define	CLOSEDISTANCE	400/4
#define ZOOMDISTANCE	0


#define PROJECTION1 0x220
//#define PROJECTION1 0x50
#define GEOMSCREEN	2000

// definesfor camera dead zone

#define CAMMAXX		5
#define CAMMAXY		5
#define CAMMAXZ		5

#define CAMMINX		-5
#define CAMMINY		-5
#define CAMMINZ		-5


typedef	struct	_CAMERVARS
{
	GsRVIEW2	camera;
	VECTOR		oldVR;
	NEWMODEL	*targetmodel;
	LONG		requiredHeight;
	LONG		currentHeight;
	LONG		angle;
	SHORT		mode;
	LONG		distance;
	LONG		speed;
	VECTOR		oldModelPos;
	VECTOR		cameraVel;
	//VECTOR		deadZone;

}CAMERAVARS;

extern	CAMERAVARS	CamVars;
//extern	COLLDATA	cameraColl;//,cameraProbe[4];
void	moveCamera(CAMERAVARS *CamVars);
extern LONG	waterheight;
extern long    ballRadius; //shouldnt be here!
void	CameraCollision(CAMERAVARS *CamVars);
void 	objectDrawCheckWater(NEWMODEL *model);


#endif
#define cameraSetView(C){GsSetRefView2L((GsRVIEW2 *)C);SetGeomOffset(0,0);}



//void	moveCamera(CAMERAVARS *CamVars);
//extern LONG	waterheight;
//extern long    ballRadius; //shouldnt be here!
//void	CameraCollision(CAMERAVARS *CamVars);
//void 	objectDrawCheckWater(NEWMODEL *model);
