 
///////////////////////////////////////////////////////////////////////////////

#ifndef __H_CAMERA
#define __H_CAMERA

///////////////////////////////////////////////////////////////////////////////

//	Camera modes
#define	FAR		0
#define	MIDDLE	1
#define	CLOSE	2
#define	ZOOM	3
#define	SPECIAL	4

//	Camera targets
#define	GLOVE	0
#define	BALL	1


#define	GOTOZOOM	1
#define	ZOOMEDIN	2
#define	GOFROMZOOM	3


// Camera heights (mode dependant)
#define	FARHEIGHT		400/6
#define	MIDDLEHEIGHT	300/6
#define	CLOSEHEIGHT		200/6
#define ZOOMHEIGHT		10

#define	FARDISTANCE		800/4
#define	MIDDLEDISTANCE	600/4
#define	CLOSEDISTANCE	400/4
#define ZOOMDISTANCE	0

#define FIXEDNEGHEIGHT	20

#define	MINGROUNDHEIGHT	50


#define PROJECTION1 0x220
#define PROJECTION2 0x180

#define GEOMSCREEN	2000

// definesfor camera dead zone
#define FIXEDHEIGHT			(1<<0)
#define	FIXEDDISTANCE		(1<<1)

#define ADDITIONALHEIGHT	(1<<2)
#define ADDITIONALDISTANCE	(1<<3)

#define	FIXEDPOSITION		(1<<4)
#define	SETFIXEDPOSITION	(1<<5)

#define	FIXEDANGLE			(1<<6)
#define	FIXEDLOOKAT			(1<<7)
#define PARALLEL			(1<<8)
#define	CIRCLE				(1<<9)
#define LOOKATPLAT			(1<<10)

//////////////////////////////////

//defines to keep track of what the camera is doing at the moment

#define	NORMALCAM				1
#define	MOVINGTOPOSITION		2
#define	INPOSITION				3
#define	MOVEINGFROMPOSITION		4



//#define OUTOFHOOP			(1<<0)
#define CAMFLAG_CAMEO_POS		(1<<1)
#define CAMFLAG_CAMEO_TARG		(1<<2)

#define	ENABLE				127

#define	MOVETOFIXED			1
#define FIXED				2
#define	FIXEDTOMOVE			3
#define	MOVETOGLOVE			4
#define	CIRCLEFIXED			5

// defines for camera changing cases

#define	POSSTEPSSLOW	90
#define	POSSTEPSFAST	20

#define LOOKSTEPS	20
#define TARGETSTEPS	10

// defines to sort out circle end buggering up atboss
#define	INCIRCLE		11
#define	CIRCLESTOP		21
#define	MOVETOCIRCLE	31

typedef	struct	_CAMERVARS
{
 	GsRVIEW2	camera;
	VECTOR		oldVR;
	VECTOR		spare;
	NEWMODEL	*targetmodel;
	NEWMODEL	*oldTargetmodel;
	VECTOR		*pLookAt;

	LONG		requiredHeight;
	LONG		currentHeight;
	LONG		angle;
	LONG		rotationSpeed;
	LONG		fixedAngle;
	LONG		parallelAngle;
	LONG		fixedHeight;
	LONG		additionalHeight;
	LONG		fixedDistance;
	LONG		additionalDistance;
	LONG		groundHeight;
	SHORT		mode;
	SHORT		targetChangeTime;
	SHORT		fixedPosChangeTime;
	SHORT		fixedLookChangeTime;
	SHORT		zoomChangeTime;
	LONG		distance;
	LONG		lastY;
	LONG		lastHeightChange;
	VECTOR		oldModelPos;
	VECTOR		cameraVel;
	ULONG		flags;
	ULONG		flags2;
	VECTOR		lookAtPos;
	VECTOR		fixedPos;
	VECTOR		posChange;
//	VECTOR		parallelPos;
	VECTOR		circlePos;
	VECTOR		zoomCamVr;
	VECTOR		zoomCamVp;
	VECTOR		zoomCamLookAt;

	VECTOR		CamVr;
	VECTOR		CamVp;
	VECTOR		CamVel;

	UBYTE		fixedHeightFlag;
	UBYTE		doing;
	UBYTE		targetChangeFlag;
	UBYTE		fixedPosChangeFlag;
	UBYTE		setFixedPosFlag;
	UBYTE		fixedLookChangeFlag;
	UBYTE		zoomMode;
	UBYTE		showGlove;
	UBYTE		showBall;
	UBYTE		circleFinished;
//	UBYTE		hoop;
}CAMERAVARS;

extern	CAMERAVARS	CamVars;
//extern	COLLDATA	cameraColl;//,cameraProbe[4];
void	moveCamera(CAMERAVARS *CamVars);
void	normalCamera(CAMERAVARS *CamVars);
void	cameraOveride(CAMERAVARS *CamVars);
//extern LONG	waterheight;
void	CameraCollision(CAMERAVARS *CamVars);
void 	objectDrawCheckWater(NEWMODEL *model);

void	setCamera(CAMERAVARS *CamVars);
void  	UpdateCamera(long test);

void 	HitCameraPosition(VECTOR *pos, VECTOR *targ);
void 	Camera_BeginLookAtPlayer();

void 	Init_Camera();
void 	lightInitFlat(void);

// Special case camera for cabonus level
void	carnivalBonusCamera(void);
void	SpaceBossCamera(void);
void	CarnivalBossCamera(void);
void	FearBossCamera(void);
void	WayroomCamera(void);

void	cameraZoom(CAMERAVARS *CamVars);

#define cameraSetView(C){GsSetRefView2L((GsRVIEW2 *)C);SetGeomOffset(0,0);}

#endif

