/************************************************************************************
	GLOVER PS	(c) 1998-9 ISL

	card.h:		Memory card routines
************************************************************************************/

#define	CARD0		1
#define CARD1		2

#define MEMCARD_LOAD 1
#define MEMCARD_SAVE 1<<1

extern long	memExit;

void	InitCards(void);
void	StopCards(void);
long	GetCardInfo(long port,long card);
long	TestCardExist(long port,long card); 
void	CardResults(long results);
void	CardCommand(long cmds);
//MemCB	TestCardExist(long port,long card);


void	CardtestRoutine(void);

void	CheckCards(long *res0,long *res1);
//
long	NoCardsFound(void);
void	ReadCardDir(long *res0,long *res1);

//
// These should be the main functions maybe able to remove others later
int MemCardControl(int flags);
void	MemCardDisplay(void);
//long	getCardStatus(long *res0,long *res1);

void	getCardStatus(long *res,long channel);
void	getCardFiles(long *res,long channel);

long	noCardScreen(void);
long	noGamesFound(long *res0,long *res1);
long	GamesFound(long *res0,long *res1,char *loadBlock);
void	selectSaveSlot(long *res0,long *res1);
long	SaveGameScreen(long *res0,long *res1,char *loadBlock);

void	drawLine(long x1,long y1,long x2,long y2);
void	drawLineRGB(long x1,long y1,long x2,long y2,UBYTE r,UBYTE g, UBYTE b,UBYTE thickness);


void	fileSelection(long *card,long *slot,long *res0,long *res1,long typeFlag);

long	selectCardScreen(long *res0,long *res1);
void	formatCardScreen(long activeCard,long *res);


void	backDisplay(long angle);

//long	LoadSaveScreen(void);
//long	LoadSaveScreen(long *res0,long *res1,char *loadBlock, int want_to_save);


void	readCardDir(long *res0,long *res1);
void	JIS2Ascii(UBYTE	*outStr,UBYTE *inStr);
//
long PadRead2( short port );


void cardGrabMem();
void cardFreeMem();



// 128 byte header followed by...
#define CARD_DATA_SIZE (128*60)

typedef struct CARDSLOTSTR
{
	short	magic;	//	"SC"
	char	type;	//	0x11 for non animating (must be, in euro), 0x12,0x13 for animating
	char	slots;
	UBYTE	name[64];	// JIS, so 32 chars of ascii
	UBYTE	padding[28];
	UBYTE	clut[32];
	UBYTE	icon1[128];
	UBYTE	icon2[128];	// (optional)
	UBYTE	icon3[128];	// (optional)

	UBYTE	data[CARD_DATA_SIZE];

}CARDSLOT;

void cardBuildBlock(CARDSLOT *block);
void cardInitialGameState();
int cardExtractBlock(CARDSLOT *block);



