
#ifndef _COLLIDE_H_
#define _COLLIDE_H_

#define	MAXCOLLCUBES 16384
#define COLLISIONBOXES	32
#define TEMPARRAY		64

typedef struct tagCOLLBOX
{
	long	pX,pY,pZ;
	long	oldpX,oldpY,oldpZ;
	long	sX,sY,sZ;
	// bit 0  0=box 1=mesh
	ULONG	flags;
	ULONG	*generalPtr;
}COLLBOX;
// if mesh flag is set, the following data follows this structure:

// char    nVerts,nFaces
// SVECTOR vert[nVerts]
// ALIGN   (4)
// char    face[nFaces*4] (char 0=flags, chars 1&2=verts 0,1,2&3 in nybbles, char 3=pad (0) )
// ALIGN   (4)

// flags: bit 0:   0=tri, 1=quad
//        bit 1&2: 00=arbitrary poly, 01=XY plane, 10=XZ plane, 11=YZ plane

extern COLLBOX *collBox;
extern int bCtr;
extern long	numCollBoxes;

typedef struct tagREBDATA
{
	VECTOR		pos;
	VECTOR		vel;	// both changed from FVECTOR
	VECTOR		normal;
	COLLBOX		*pCollBox;
	short		plane;
	short		type;
}HITDATA;

extern	HITDATA 	pHitData[16]; // max number of hits

typedef	struct _Behaviour_Physics
{
	long	mass;
	long	gravity;
	long	bounce;		//(4096=full 0=none)
	long	drag;		//(4096=none 0=full)
	long	maxSpeed;
	long	radius;
	long	accel;

}BEHAVIOUR_PHYSICS;



typedef struct tagCOLLDATA
{
	int nBoxes;
//	int bounce;
	int radius;
	COLLBOX *pCollBox;
	VECTOR *pVel;
	VECTOR *pPos;
	VECTOR *pRot;	// changed from FVECTOR
	int nHits;

	BEHAVIOUR_PHYSICS	*physics;
	int		physicsModel;
	// internal use only
	VECTOR	oldPos;
	VECTOR	oldRot;
	VECTOR	oldVel;
	VECTOR	hitPos;	// changed from FVECTOR
	int lastHit;
}COLLDATA;

//const long g=4000/4;//long(4096.0*9.80665)/16;

// box orientations

#define N	0
#define NE	1
#define E	2
#define SE 	3
#define S	4
#define SW	5
#define	W	6
#define NW	7

// HIT types
#define PLANE		0
#define EDGE		1
#define CORNER		2
#define	CYLINDER	3
#define	SPHERE_H	4
#define RAMP_H		5


// Box types
#define BOX			0
#define RAMP		1
#define	CYLINDER_X	2	/* X axis aligned cylinder*/
#define	CYLINDER_Y	4	/* Y axis aligned cylinder*/
#define	CYLINDER_Z	8	/* Z axis aligned cylinder*/
#define	SPHERE		16

// Bits for type and special
#define TYPEPART	0xff
#define	SPECIALPART	0xff00
// Box special cases 
#define MOVE	0x100



#define XAXIS 1
#define YAXIS 2
#define ZAXIS 4

#define D_XZPLANE 1
#define D_XYPLANE 2
#define D_YZPLANE 4

#define U_XZPLANE 8
#define U_XYPLANE 16
#define U_YZPLANE 32

#define LARGERTOSMALLER 0
#define SMALLERTOLARGER 1
#define MAXCOLLOSIONS 20

extern int pFaceOrder[];

extern int pEdgeOrder[];

extern int pCornerOrder[];

extern long	xSteps,ySteps,zSteps;
extern long	xStepLen,yStepLen,zStepLen;
extern long	startX,startY,startZ;
extern long	endX,endY,endZ;
extern ULONG	*reducedCollBox;


ULONG	CheckCorners( COLLBOX *pB , COLLDATA *pD, HITDATA *pHitData );
int		collboxHasBallHitCorner(COLLDATA *pD, int x, int y, int z);
ULONG	CheckEdges(COLLBOX *pB , COLLDATA *pD , HITDATA *pHitData );
int		collboxHasBallHitEdge(COLLDATA *pD, int axis, int l1, int l2, int x, int y);
ULONG	CheckPlanes(COLLBOX *pB , COLLDATA *pD , HITDATA *pHitData );
int		collboxHasVectorCrossedPoly(COLLDATA *pD, int plane, int planePos, int r, int x1, int y1, int x2, int y2);
ULONG	CheckRamps(COLLBOX *pB , COLLDATA *pD , HITDATA *pHitData );

ULONG	CheckCylinders(COLLBOX *pB , COLLDATA *pD , HITDATA *pHitData );
ULONG	CheckSpheres(COLLBOX *pB , COLLDATA *pD , HITDATA *pHitData );

void	UpdateRampCollision(COLLDATA *pD , HITDATA *pHitData , VECTOR *collPos , VECTOR *rebound);
void	UpdateEdgeCollision(COLLDATA *pD , HITDATA *pHitData , VECTOR *collPos , VECTOR *rebound); 
void	UpdateCornerCollision(COLLDATA *pD , HITDATA *pHitData , VECTOR *collPos , VECTOR *rebound);
void	UpdatePlaneCollision(COLLDATA *pD , HITDATA *pHitData , VECTOR *collPos , VECTOR *rebound);

void	UpdateCylinderCollision(COLLDATA *pD , HITDATA *pHitData , VECTOR *collPos , VECTOR *rebound);
void	UpdateSphereCollision(COLLDATA *pD , HITDATA *pHitData , VECTOR *collPos , VECTOR *rebound);

void	CopyVector(VECTOR *U, VECTOR *V);
void collboxAddBox(int pX,int pY,int pZ, int sX,int sY,int sZ,
				   int orient, int boxType, int bColl);


void	ReduceCollision(COLLBOX *pcollbox,long offset,char * filename);
ULONG	checkIntersection(COLLBOX *pcollbox,long minX,long minY,long minZ,long maxX,long maxY,long maxZ);

void	setupCollision(char *);
int		collboxCheckSphere(COLLDATA *pD);
long	getHeightAt(long x,long y,long z);



#endif
