/* Attempt to seperate debugging stuff into another module, by CPW, June 1999 */

//int debugPrintf(char* fmt, ...);
int debugPrintf2(char* fmt, ...);

// Note: psxPrintf should be left alone EVEN ON GOLD (it's used for memory ov type reports)
int psxPrintf(char* fmt, ...);

void debugAssert(void);


#if (GOLDCD==YES)
#define POLLHOST() ;
#else
#define POLLHOST() asm("break 1024")
#endif




#if (GOLDCD==YES) || (RELEASE==YES)		//these if burning a gold disc

#define PRINTF	//printf
#define ERROR //printf
#define FPRINTF //printf
#define DB

#define PRINTNUM(V)
#define PRINTVECT(V)
#define PRINTNEWL

#define DEBUG_MEM NO


#define ASSERT
#define VALIDATE

#define debugPrintf

#define debugPrintfEvenOnGold __line=__LINE__,strcpy(__file, __FILE__),debugPrintf2


#else				//these if normal development

extern int __line;
extern char __file[16];

#define debugPrintf __line=__LINE__,strcpy(__file, __FILE__),debugPrintf2

#define DB debugPrintf

#define PRINTNUM(V) DB("VAR "#V"=(%d) ", V);
#define PRINTVECT(V) DB("VECTOR "#V"=(%d,%d,%d) ", (V)->vx,(V)->vy,(V)->vz);
#define PRINTNEWL DB("\n");

#define PRINTF	debugPrintf
#define ERROR debugPrintf
#define FPRINTF debugPrintf
#define DEBUG_MEM YES
//#define POLLHOST() asm("break 1024")

#define HEAPBASE (__heapbase & 0x0fffffff)

#define ASSERT(cond) if(!(cond)) {psxPrintf("\nASSERT FAILED at line %d, file %s, expression: %s\n",__LINE__, __FILE__, #cond);debugAssert();}

#define VALIDATE(p) if(((((ULONG)p)&0x7fffffff)<HEAPBASE)||(((((ULONG)p)&0x7fffffff)>STACKTOP)&&((((ULONG)p)&0x7fffffff)<DCACHE))||((((ULONG)p)&0x7fffffff)>DCACHETOP)) \
		{DB("\nPOINTER (%p) UP THE DUFF at line %d, file %s\n",p,__LINE__, __FILE__);CRASH;}

#endif

