
#ifndef __H_EFFECTS
#define __H_EFFECTS


//#define PLACEHOLDERS


void	Init_All_Effects();
void	Update_All_Effects();
void	Draw_All_Effects();
void	Kill_All_Effects();

// lots of drawlines
void RadiusCheckCheck(SVECTOR *pos, int r);


/****************************************************************************/
typedef struct tagRIPPLE{
	struct tagRIPPLE *next,*prev;			// list pointers
	VECTOR v;
	USHORT scale;
	UBYTE count;
	UBYTE speed;
}RIPPLE;

#define MAXRIPPLES 30
extern	RIPPLE ripples[MAXRIPPLES];
void	Start_Ripple(VECTOR *vector,ULONG scale,UBYTE count);
void	Update_Ripples();
void	Draw_Ripples();

extern	NEWMODEL	*pRipplePSA;
extern	NEWMODEL	*pWakePSA;
/*-------------------------------------*/	

//void	SetupSky();
//void	PrintSky();



extern SPRITEX*	overlayssprpointer;


//dont forget a bit field shpuld be set up of all the Garibs collected.
//Becuase this information needs to be saved onto memory card 
typedef struct tagGARIBPOS{
	USHORT num;  //set top bit of num if collected 
	SHORT shadowheight;
	SHORT x,y,z;
	BYTE type; // 0=normal, 2=extra life
//	BYTE scoretimer;
//	BYTE scorevalue;
}GARIBPOS;

// this is from "collect.h" in the n64
enum
{
	NORMAL_GARIB,
	SUPER_GARIB,
	EXTRA_LIFE,
	NUM_GARIB_TYPES
};


extern	GARIBPOS *garibpositions;
extern ULONG numberofgaribs; //set to garibs on THIS level, including extra lives;
extern ULONG numGaribs;	// number of garibs on level, including non-existant ones inside enemies
// temp mod by Fred till I get a better counting mech going
#define MAX_GARIBS 90

void	   	Update_Garibs();
void	   	Draw_Garibs();

void Effects_LevelStart();
void Effects_LoadShapes();


/*********************************************/

// Again, Fred's been horrible for a while...
#define MAX_MR_TIPS 8

typedef struct tagMRTIPS{
	SHORT x,y,z,num;
}MRTIPS;

extern	MRTIPS *mrtippositions;
extern ULONG numberofmrtips; //set to garibs on THIS level, including extra lives;
void	   	Update_MrTips();
void	   	Draw_MrTips();


/*************************************************************/
//#define MAX_ENEMIES 10
// (max_enemies is defined in "types.mh" as 30)

void	Draw_Enemies();


// vec is the (small-numbers, not *4096) 3d coords of the shadow. It's always drawn "flat" at the mo
// colour = 0x7f7f7f for a black shadow, f'rinstance
// radius = 4 or 5 for small (garib), 10 for smallish enemies/balls/gloves...
// matrix is assumed to be set to world-level (gte_SetRotMatrix(&GsWSMATRIX); gte_SetTransMatrix(&GsWSMATRIX))
// set otz = -1 to have it calculated
void Draw_RawShadow(SVECTOR *vec, LONG radius, ULONG colour, LONG otz);





#if GOLDCD==YES
	#define Draw_RadCheckRing
#else
	void Draw_RadCheckRing2(SVECTOR *vec, LONG radius, ULONG colour);
#endif




#define MAX_DEBRIS 60
typedef struct DEBRISTAG
{
	struct DEBRISTAG *next;
	VECTOR pos;
	unsigned char type;
	unsigned char timer;
	int value;
}DEBRISSTR;

enum								
{
	DEBRIS_FREE,		// 0
	DEBRIS_BLUESTAR,	// 1
	DEBRIS_POINTS,		// 2
	DEBRIS_LIFEGLOW,	// 3
	DEBRIS_RINGSTAR,	// 4
	DEBRIS_WISP,		// 5
	DEBRIS_SPELLDUST,	// 6
	DEBRIS_SPELLFLASH,	// 7
	DEBRIS_FLAME,		// 8
	DEBRIS_STUNSTAR,	// 9
	DEBRIS_AIMBLOB,		// 10
	DEBRIS_DUST,		// 11
	DEBRIS_PORTALPUFF	// 12
};

void KillAllDebris();
void DebrisInit();
void DebrisFree();

// use of "value" is debris-type dependant
DEBRISSTR *New_Debris(int type,VECTOR *pos, int value);
void New_StarRingDebris(VECTOR *pos, int num_stars);
void New_PortalDebris(VECTOR *pos);

// bgrcolour = 0x808000 for cyan lightening
void effectsDrawLightningStrand(SVECTOR *v1, SVECTOR *v2, LONG bgr_colour);
void effectsStartBlastRing(VECTOR *pos, int minrad, int maxrad, int time);


typedef struct BLASTRINGTAG
{
	VECTOR v;
	int time;
	int count;
	int minrad;
	int maxrad;
}BLASTRING;
void effectsDraw_BlastRing(BLASTRING *br);


void effectsStartOverlay(int timer, int colour);


void Kill_Debris(DEBRISSTR *debris, DEBRISSTR **prev);
void Update_Debris();
void Draw_Debris();

extern int sinewave1;
extern int sinewave2;

#define MAX_SPELLS 6

// what a spell's doing
// (homing on the ball/glove/...)
enum
{
	SPELLACTION_BALLTRANS,
	SPELLACTION_NMETRANS,
	SPELLACTION_RUNOUT,
	SPELLACTION_GLOVETRANS
};


enum
{
// this lot match up with "ball_mode_normal" onwards
	SPELL_BALL_NORMAL,
	SPELL_BALL_BOWLING,
	SPELL_BALL_POWER,
	SPELL_BALL_BEARING,
	SPELL_BALL_BEACH,
	SPELL_BALL_SNOW,
	SPELL_BALL_CRYSTAL,

// others
 // The ball can certainly be hit by a boomerang spell, for a start...

 // you fire these at baddies
	SPELL_DEATH,
	SPELL_FROGGY,

// pickups fire these at the glove
	SPELL_SUCTION,
	SPELL_HERCULES,
	SPELL_SPEEDUP,
	SPELL_ROTORBLADES,
	
// pickups fire these at the ball
	SPELL_BOOMERANG,
	SPELL_VANISH,
	NUM_SPELLS

};

int pickupFireGloveSpell(int type);	// fire spell from glove
// fire spell from pickup to glove/ball
int pickupFirePickupSpell(int action,VECTOR *pos, int type);


#define BALLGARIBCOLLRADIUS 15
#define GLOVEGARIBCOLLRADIUS 15
#define GARIBCOLLRADIUS 10
#define GARIBSCORINGTIME 30


// spritex of the test tube
extern SPRITEX *SPR_tubebase;
extern SPRITEX *SPR_fairbase;
extern SPRITEX *SPR_aiglowbase;

#define EFFECT_BOXCOLL_BALL  1
#define EFFECT_BOXCOLL_GLOVE 2
int effect_BoxCollideWithPlayer(int test,SVECTOR *pos, int radius);

int AngleHomer(int ang, int targ, int speed);
int IntHomer(int val, int targ, int speed);

#define MAX_SCENERIES 20

#define gte_SetLDDQA( r0 ) __asm__ volatile (		\
	"ctc2	%0, $27"					\
	:							\
	: "r"( r0 ) )

#define gte_SetLDDQB( r0 ) __asm__ volatile (		\
	"ctc2	%0, $28"					\
	:							\
	: "r"( r0 ) )



/*************************************************************/
#endif /*EFFECTS*/


