/*
	Fonts: Definitions and externals.
*/

#ifndef __FONT_H__
#define __FONT_H__

extern UBYTE message[100];


typedef struct TAGTEXT
{
	struct TAGTEXT *next,*prev;
	char message[64];
	int x,y;
	int scaleX,scaleY;
	UBYTE r,g,b,a;	//alpha default 255  
	UBYTE r1,g1,b1,a1; //alpha default 255
	int byebye;
	SPRITEX *font;
	int centre;
	ULONG flags;
}TEXT;
#define FULLALPHA 255
typedef struct
{
	TEXT head;
	int numEntries;
}TEXTLIST;

#define TEXTSETPOS(X,Y){	*(ULONG*)&messctrl.x=(Y<<16)|(X); \
							*(ULONG*)&messctrl.ox=*(ULONG*)&messctrl.x;}

#define TEXTPRINTAT(X,Y,M){	TEXTSETPOS(X,Y); \
							textPrint(M);}

#define TEXTSETFONT(T){messctrl.font=T;}


#define LEFTTEXT		0
#define RIGHTTEXT		1
#define CENTRETEXT		2

#define TEXT_SHADED		1
#define TEXT_ANIMATED   (1<<1)

#define MESSNEWLINE		(11)
#define MESSXY			(12)
#define MESSPAUSE		(13)
#define MESSCOL			(14)
#define MESSTWEEN		(15)
#define MESSENDTWEEN	(17)

typedef struct tagMESS
{
	SHORT x;
	SHORT y;
	SHORT ox;
	SHORT oy;
	SPRITEX *font;

	UBYTE propor;
	UBYTE justify;
	SHORT spc;
	short  gapx;
}MESS;

extern MESS messctrl;

extern TEXTLIST textList;
extern char _message[];
extern TEXT *mtext;

void NEW_TEXT(short xval,short yval,char rr,char gg,char bb,char aa,int sx,int sy,char bye,char *string,char center);
void ShowText();
void InitTextList();
void AddText(TEXT *text, int);
void SubText(TEXT *text);
void ClearText();
void ClearAllText();
void InitFont();
void LoadFont();

short GetStringPixelLength(char *msg,LONG scaleX,LONG scaleY);

SPRITEX *textLoadFont(char *sFile, int intelligent);
void textReset(void);
UBYTE textForeignLetters(UBYTE);
USHORT textFindLineLen(UBYTE *);
void textPrint(UBYTE *);
int textPrintf(char *, ...);

void textPrintAnimated(UBYTE *mess);


#define TEXTPRINTANIMATEDAT(X,Y,M){	TEXTSETPOS(X,Y); \
							textPrintAnimated(M);}


#define NUMFONTS 3
extern SPRITEX *fontList[];


#ifdef MULTI_LANGUAGE
void loadLangFile(int language);
char *fontFindLangString(int id);



// Language strings
#define STR_START			0x0100
#define STR_OPTIONS			0x0200
#define STR_HISCORES		0x0300

#define STR_NG_NEWGAME		0x0400
#define STR_NG_LOADGAME		0x0500

#define STR_CONGRATS		0x0600
#define STR_YOURTIME		0x0700
#define STR_BESTTIME		0x0800
#define STR_YOURCARDS		0x0901
#define STR_BESTCARDS		0x0A01

#define STR_SAVE			0x0B00
#define STR_CONTINUE		0x0C00

#define STR_BONUS_OPEN		0x0C01

#define STR_OUTOFTIME1		0x0D00
#define STR_OUTOFTIME2		0x0D01
#define STR_GAMEOVER1		0x0E00
#define STR_GAMEOVER2		0x0E01
#define STR_TIME			0x0F00

#define STR_FREEBLOCK		0x1000
#define STR_SAVENAME		0x1100
#define STR_SAVECANCEL		0x1200
#define STR_LOADGAME		0x1300
#define STR_LOADCANCEL		0x1400
#define STR_INSERTCARD		0x1500
#define STR_FORMATCARD		0x1600

#define STR_NO				0x1700
#define STR_YES				0x1701

#define STR_INVALIDCARD		0x1800
#define STR_OVERWRITE		0x1900
#define STR_NOTGLOVER		0x1A00
#define STR_SAVING			0x1B00
#define STR_LOADING			0x1C00
#define STR_DONTREMOVE		0x1C01
#define STR_WAIT			0x1D00

#define STR_ACCESSING		0x1E00
#define STR_NOTFORMATTED	0x1F00
#define STR_NOCARD			0x2000


#define STR_CHT_CALLBALL	0x2100
#define STR_CHT_WINLEVEL	0x2200
#define STR_CHT_CHECKPOINTS	0x2300
#define STR_CHT_MENU		0x2400
#define STR_CHT_FROGSPELL	0x2500
#define STR_CHT_DEATHSPELL	0x2600
#define STR_CHT_HERCULES	0x2700
#define STR_CHT_SPEEDUP		0x2800
#define STR_CHT_ROTORBLADES	0x2900
#define STR_CHT_POWERBALL	0x2A00
#define STR_CHT_BOOMERANG	0x2B00
#define STR_CHT_BEACHBALL	0x2C00
#define STR_CHT_INFYENERGY	0x2D00
#define STR_CHT_INFYLIVES	0x2E00
#define STR_CHT_LOWGRAVITY	0x2F00
#define STR_CHT_CINEMASCOPE	0x3000
#define STR_CHT_ALLCHEATS	0x3100
#define STR_CHT_LOOKMODE	0x3101

#define STR_CHEAT_ON		0x3200
#define STR_CHEAT_OFF		0x3300

#define STR_HUB				0x3400
#define STR_ATLANTIS		0x3500
#define STR_CARNIVAL		0x3600
#define STR_PIRATES			0x3700
#define STR_PREHISTORIC		0x3800
#define STR_FEAR			0x3900
#define STR_SPACE			0x3A00

#define STR_BOSS			0x3B00
#define STR_BONUS			0x3C00

#define STR_SOUND			0x3D00
#define STR_CONTROLS		0x3E00
#define STR_CENTER			0x3F00
#define STR_LANGUAGE		0x4000
#define STR_INTRO			0x4100
#define STR_CHEATS			0x4200
#define STR_VIBRATION		0x4201
#define STR_ON				0x4202
#define STR_OFF				0x4203

#define STR_BUT_SEL			0x4300
#define STR_BUT_SELCANCEL	0x4400
#define STR_BUT_PLAYCANCEL	0x4500
#define STR_BUT_CANCEL		0x4600
#define STR_BUT_PLAYCANCEL2	0x4700

#define STR_SOUNDTITLE		0x4800
#define STR_MUSICVOL		0x4900
#define STR_EFFECTSVOL		0x4A00

#define STR_CENTRETITLE		0x4B00
#define STR_DIRECTIONAL		0x4C00
#define STR_CONTROLTITLE	0x4D00

#define STR_CTRL_MOVE		0x4E00
#define STR_CTRL_ZOOM		0x4F00
#define STR_CTRL_MAGIC		0x5000
#define STR_CTRL_DROP		0x5100
#define STR_CTRL_THROW		0x5200
#define STR_CTRL_JUMP		0x5300
#define STR_CTRL_SLAP		0x5400
#define STR_CTRL_THROW2		0x5500
#define STR_CTRL_HELP		0x5600
#define STR_CTRL_CAMERA		0x5700
#define STR_CTRL_START		0x5800
#define STR_CTRL_PAUSE		0x5900

#define STR_CHEATMENU		0x5A00
#define STR_SOUNDTEST		0x5B00
#define STR_MUSICTEST		0x5C00
#define STR_CREDITS			0x5D00
#define STR_LEVELSELECT		0x5E00

#define STR_HISCORE_TITLE	0x5F00
#define STR_HIS_SCORE		0x6000
#define STR_HIS_NAME		0x6001
#define STR_HIS_BESTTIMES	0x6100
#define STR_HIS_LEVEL		0x6200
#define STR_HIS_TIME		0x6201

#define STR_LANGTITLE		0x6300
#define STR_ENGLISH			0x6400
#define STR_FRENCH			0x6500
#define STR_GERMAN			0x6600
#define STR_ITALIAN			0x6601

#define STR_MUSICTESTTITLE	0x6700
#define STR_SOUNDTESTTITLE	0x6800

#define STR_PAUSED			0x6900
#define STR_PAUSE_CONTINUE	0x6A00
#define STR_BACKTOSTLE		0x6B00
#define STR_CHECKPOINT		0x6C00
#define STR_RESTART			0x6D00
#define STR_HELPON			0x6D01
#define STR_HELPOFF			0x6D02

#define STR_QUIT			0x6E00
#define STR_CALLBALL		0x6F00
#define STR_WINLEVEL		0x7000

#define STR_AREYOUSURE		0x7100
#define STR_YES2			0x7200
#define STR_NO2				0x7300

#define STR_GOTHIGHSCORE	0x7400
#define STR_ENTERNAME		0x7500
#define STR_HI_CONTINUE		0x7600


#define STR_HLP_FIRE		0x7700
#define STR_HLP_SHIELD		0x7800
#define STR_HLP_BOUNCE		0x7900

#define STR_HLP_JUMP		0x7A00
#define STR_HLP_BOUNCEBALL	0x7B00
#define STR_HLP_POINT		0x7C00
#define STR_HLP_TIP			0x7D00
#define STR_HLP_2BUTSLAM	0x7E00
#define STR_HLP_1BUTSLAM	0x7F00
#define STR_HLP_CASTSPELL	0x7F01
#define STR_HLP_THROWBALL	0x8000
#define STR_HLP_RELTHROW	0x8100
#define STR_HLP_THROW		0x8200
#define STR_HLP_SLAPBALL	0x8300
#define STR_HLP_RELSLAP		0x8400
#define STR_HLP_SLAP		0x8500
#define STR_HLP_CANCEL		0x8600
#define STR_HLP_LEAVE		0x8700
#define STR_HLP_GETOFF		0x8800
#define STR_HLP_HOLD		0x8900
#define STR_HLP_BALLSPELL	0x8A00

#define STR_HLP_THRUST		0x8B00
#define STR_HLP_HOVER		0x8C00
#define STR_HLP_DROP		0x8D00

#define STR_MORE			0x8E00
#define STR_EXTRAHEART		0x8F00

#define STR_LOADFAIL		0x9000
#define STR_SAVEFAIL		0x9100
#define STR_FORMATTING		0x9200

#define STR_LOADOK			0x9300
#define STR_SAVEOK			0x9400

#define STR_ABBREV_AT		0x9500
#define STR_ABBREV_CA		0x9600
#define STR_ABBREV_PI		0x9700
#define STR_ABBREV_PR		0x9800
#define STR_ABBREV_FF		0x9900
#define STR_ABBREV_SP		0x9A00
#define STR_ABBREV_BOSS		0x9B00
#define STR_ABBREV_BONUS	0x9C00

#endif

#endif
