/*
	Fonts: Definitions and externals.
*/

#ifndef __FONT_H__
#define __FONT_H__

typedef struct TAGTEXT
{
	struct TAGTEXT *next,*prev;
	char message[64];
	int x,y;
	int scaleX,scaleY;
	UBYTE r,g,b,a;
	UBYTE r1,g1,b1,a1;
	int byebye;
	SPRITEX *font;
	int centre;
	ULONG flags;
}TEXT;

typedef struct
{
	TEXT head;
	int numEntries;
}TEXTLIST;

#define LEFTTEXT		0
#define RIGHTTEXT		1
#define CENTRETEXT		2

#define TEXT_SHADED		1

#define MESSNEWLINE		(11)
#define MESSXY			(12)
#define MESSPAUSE		(13)
#define MESSCOL			(14)
#define MESSTWEEN		(15)
#define MESSENDTWEEN	(17)

typedef struct tagMESS
{
	SHORT x;
	SHORT y;
	SHORT ox;
	SHORT oy;
	SHORT depth;
	UBYTE col;
	SHORT size;
	LONG tweencnt;
	SPRITEX *font;
	UBYTE propor;
	UBYTE linespc;
	SHORT spc;
	UBYTE justify;
	UBYTE trippy;
}MESS;

extern MESS messctrl;

extern TEXTLIST textList;
extern char _message[];
extern TEXT *mtext;

void NEW_TEXT(short xval,short yval,char rr,char gg,char bb,char aa,int sx,int sy,char bye,char *string,char center);
void ShowText();
void InitTextList();
void AddText(TEXT *text, int);
void SubText(TEXT *text);
void ClearText();
void ClearAllText();
void InitFont();
void LoadFont();

void textSetFont(SPRITEX *);
short GetStringPixelLength(char *msg,LONG scaleX,LONG scaleY);

SPRITEX *textLoadFont(char *sFile, int intelligent);
void textReset(void);
UBYTE textForeignLetters(UBYTE);
USHORT textFindLineLen(UBYTE *);
void textPrint(UBYTE *);
void textSetPos(LONG,LONG);
void textPrintAt(LONG,LONG,UBYTE *);
int textPrintf(char *, ...);


int debugPrintf(char* fmt, ...);

typedef struct _psFont
{
	int				numchars;
	int				height;
	unsigned short	*clut;
	int				dataoffset[256];
	int				width[256];
	int				pixelwidth[256];
	SPRITEX			*sprX;
	uchar			charlookup[256];
}psFont;

#define NUMFONTS 2
extern SPRITEX *fontList[];

#endif
