
#ifndef __H_INTERUPT
#define __H_INTERUPT



extern unsigned long __heapbase;
extern unsigned long __heapsize;
extern unsigned long __bss;
extern unsigned long __bsslen;
extern unsigned long __data;
extern unsigned long __datalen;
extern unsigned long __text;
extern unsigned long __textlen;
  
// Tidied up by CPW on 19/2/1999
// NOTE: There's no longer a fixed max number of polygons,
//       just a maximum size that the polygon list can be.

#define MAXPACKETSIZE (sizeof(POLY_GT4))
#define OT_LENGTH 11  // size of order table, in bits
#define MAXPOLYDEPTH ((1<<OT_LENGTH)-1)

//#define PACKETMAX 0x14000 // max size of poly table (0x28000 = 160K)
// rqd when subdiv went in
#define PACKETMAX 0x18000 // max size of poly table (0x28000 = 160K)

extern UBYTE *dodgeypolys; //this is the address to check, if polys overrun
extern void *PauseFunction;
extern UBYTE PauseExitCount;

extern UBYTE wipeScreen;  //used to turn load wipe on/off


extern UBYTE *PacketBuildList;	//malloc'd with PACKETMAX *2 ('cos of 2 tables)

extern	RECT mainwindow;
extern	UBYTE mainwindowfull;

extern	UBYTE		scr_toggle;

extern	UBYTE regnum;

extern 	SHORT	scrcenterx;
extern 	SHORT	scrcentery;
extern	SHORT	screenwidth;
extern	SHORT	screenheight;
extern USHORT resolution;
extern DRAWENV	GsDRAWENV;
extern DISPENV	GsDISPENV;
									      
void Check_Stack(UBYTE num);
extern	int  oldSp;

void 		Start_Loop(void);
void 		End_Loop(ULONG forceframe);
void		rts(void);
void 		Cls(void);
void		Turn_Screen_Off();

extern 	volatile 	ULONG	vblank;
extern 	volatile 	ULONG	iframe;
extern 				ULONG	ovblank;
extern int		frameLock;
extern int		showProgress, currProgress;
extern volatile UBYTE	allowPadHandler;

extern USHORT framerate;
extern USHORT realframerate;
extern USHORT framerate256;
extern LONG forceframe;
extern 				ULONG 	frame;

void		VblCallback();

/*********************************************************/

//typedef struct
//{
//	UBYTE r,g,b,code;
//}RGBCD;

extern	RGBCD  	clscol;

void	Set_Up_Display();

void	Show_VRAM(void);



#define	MAXCLIPPOKES 30
typedef struct{
			USHORT 			polysinlist;
			USHORT 			polycnt;
			volatile  	UBYTE		dblbuf;
			UBYTE		*id; 
			GsOTA		Wot[2];
			GsOT_TAG	*sorttable;
			PACKET		*poly_packets;
			LONG		sizeofpackets;	//actually malloc 2 times this for double buffer
			LONG		overallz;
			UBYTE		flags; //PACKOT  PRESETPOLYS
			P_TAG		*endofot;
			PACKET		*workbase;
			SHORT		offx;
			SHORT		offy;
			RECT		drawarea;
			UBYTE*		topofdrawlist[2];
			UBYTE*		bottomofdrawlist[2];
			UBYTE       used;
			}OBJECTPOLYLIST;
extern	ULONG		clippokes[2][MAXCLIPPOKES];

extern	ULONG numofclips;

UBYTE TooManyPolys(LONG size,UBYTE *mess);

#if GOLDCD==NO
#define TOOMANYPOLYS(A,B)  TooManyPolys(A,B)	
#else
#define TOOMANYPOLYS(A,B) 	(A+(LONG)GsOUT_PACKET_P)>(ULONG)(CurrentPolyList->topofdrawlist[CurrentPolyList->dblbuf])
#endif



#define PACKOT 1
#define PRESETPOLYS 2

#define MAXPOLYLISTS 8
extern	OBJECTPOLYLIST *polylists[MAXPOLYLISTS];

extern	OBJECTPOLYLIST *CurrentPolyList;
extern	OBJECTPOLYLIST *OldObjectPolyList;
extern	GsOT_TAG *TempOT; 

void	brokenscreenoffon();
void 	solidscreenonoff();
void	ShowScreen(int);

void	Init_PolyLists();
OBJECTPOLYLIST*	Register_ObjectPolyList(UBYTE bitdepth,UBYTE* id,ULONG packetbuildsize);
void			UnRegister_ObjectPolyList(OBJECTPOLYLIST *ptr);
void			Do_ObjectPolyList(OBJECTPOLYLIST *ptr);
void			Done_ObjectPolyList(OBJECTPOLYLIST *ptr,LONG depth);
void			PackOt(OBJECTPOLYLIST *ptr);
void			DoClipsForWindow(OBJECTPOLYLIST *ptr);

void	endpoly();

extern GsOTA *OldPolyList;
//extern PACKET *OldWorkBase;
extern	GsOTA *PolyList;

//extern	ULONG ev;
void	VblCallback();
extern	OBJECTPOLYLIST *defaultpolylist;
extern	ULONG maxmapdepth;


void	   mainloop();
extern	UBYTE *origstack;

extern	volatile LONG finisheddrawing;
void	enddrawing();
#define FastStack() {EnterCriticalSection(); \
			      	 oldSp=SetSp(DCACHETOP); \
					ExitCriticalSection();}
#define SlowStack(){EnterCriticalSection(); \
					SetSp(oldSp); \
					ExitCriticalSection();}


void	Start_Poly_Lists();
void	Add2cliptable(ULONG packet);
void	UnSet_Clip_Area(ULONG depth);
void	Set_Clip_Area(ULONG x,ULONG y,ULONG w,ULONG h,ULONG depth);



/*******PAUSE STUFF************************************************************/
#define PAUSEPACKETSIZE (1000*MAXPACKETSIZE)

typedef struct{
			UBYTE 	available;
			UBYTE 	active;
			UBYTE	attempt;
		}PAUSECTRL;

extern PAUSECTRL pausectrl;
void		PauseRou(void (*Pause_Function)(void));
extern	OBJECTPOLYLIST *pausepolylist;
//extern	UBYTE*	pausepolypackets;
extern UBYTE player_pressed_start;







/******************************************************************************/	 
LONG MainLoopTimeLeft();
LONG HardWareTimeLeft();
					 

void	SnapShot(void);
/*******************************************************************************/
enum {
	TIMER_TOTAL,
	TIMER_TIMERS,
	TIMER_LSCAPE,
	TIMER_COLLISION,
	TIMER_NME,
	TIMER_NMEMOVE,
	TIMER_BALLGLOVE,
	TIMER_DRAWSYNC,

	TIMER_NUMTIMERS
};


#define TIMER_NAMES		"Total", \
						"Timers", \
						"Lscape", \
						"Collision",\
						"NME", \
						"NMEMove", \
						"Ball and Glove", \
						"DrawSync"


extern char	timerActive;
extern char	*timerName[TIMER_NUMTIMERS];
extern int	globalTimer[TIMER_NUMTIMERS];
extern int	splitTimer[TIMER_NUMTIMERS];
extern int	prevTimer[TIMER_NUMTIMERS];
extern int	prevsplitTimer[TIMER_NUMTIMERS];


/**************************************************************************
	FUNCTION:	TIMER_START()
	PURPOSE:	Start timing
	PARAMETERS:	Timer number
	RETURNS:	
**************************************************************************/
#define TIMER_START(n)		{globalTimer[n] = VSync(1); splitTimer[n] = 0;}

/**************************************************************************
	FUNCTION:	TIMER_STOP()
	PURPOSE:	Stop timing
	PARAMETERS:	Timer number
	RETURNS:	
**************************************************************************/

#define TIMER_SPLIT(n)		splitTimer[n] = VSync(1)-globalTimer[n]
#define TIMER_STOP(n)		globalTimer[n] = VSync(1)-globalTimer[n]


/**************************************************************************
	FUNCTION:	TIMER_ENDFRAME()
	PURPOSE:	Start timing
	PARAMETERS:	Timer number
	RETURNS:	
**************************************************************************/

#define TIMER_ENDFRAME		{memcpy(prevTimer, globalTimer, sizeof(globalTimer)); memcpy(prevsplitTimer, splitTimer, sizeof(globalTimer));}


/**************************************************************************
	FUNCTION:	timerDisplay()
	PURPOSE:	Display timer readings if enabled
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void timerDisplay();




#endif /*H_INTERUPT*/





  