/************************************************************************************
	GLOVER PSX	(c) 1998-9 ISL

	lscape.h:		Landscape specific draw routines

************************************************************************************/

#ifndef _LSCAPE_H_
#define _LSCAPE_H_

#define LIGHTING_OFF 0
#define LIGHTING_DYNAMIC 1
#define LIGHTING_PARALLEL 2

extern	long *transVerts;
extern	long *transDepths;

extern	SPRITEX *watersprites;
extern	SPRITEX *waterflowsprites;

void lscapeDrawAll(PSAWORLD *);

void lscapeInit(void);
/**************************************************************************
	FUNCTION:	lscapeDraw()
	PURPOSE:	Draw a landscape object (with proper depth sort)
	PARAMETERS:	Model structure
	RETURNS:	
**************************************************************************/

void lscapeDraw(NEWMODEL *model);

/**************************************************************************
	FUNCTION:	lscapeDraw()
	PURPOSE:	Draw a landscape object (with proper depth sort), can rotate
	PARAMETERS:	Model structure
	RETURNS:	
**************************************************************************/
void lscapeDrawRotate(NEWMODEL *model);

/**************************************************************************
	FUNCTION:	lscapeDrawBoundPoly()
	PURPOSE:	highlights the collision polys
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void lscapeDrawBoundPoly(int numPoints, Point2DType *points, int height, uchar r,uchar g,uchar b);

/**************************************************************************
	FUNCTION:	lscapeDrawBoundPoly3D()
	PURPOSE:	highlights the collision polys
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void lscapeDrawBoundPoly3D(int numPoints, Point3DType *points, uchar r,uchar g,uchar b);

extern PSAWORLD *pWld;


#endif

