######################################################################
#
# GLOVER PS MAKEFILE
#
######################################################################

#
# MACROS
#

#OPT =  -xc++ -wall -DWHACK -c -O0 -g -X0$18000
#OPT =  -comments-c++ -Wall -DWHACK -c -O0 -g -mgpopt -G16 -X0$18000
# OPT =  -comments-c++ -DMAKE_GOLDCD=NO -DWHACK -c -O2 -g -mgpopt -G32 -X0$18000
# OPT0 =  -comments-c++ -DMAKE_GOLDCD=NO -DWHACK -c -O2 -g -mgpopt -G16 -X0$18000


# the "unused" warning flags our PRINTF macros, so I've disabled it
# (as well as reporting loads of unused variables, byt WTH?)

#OPT =  -comments-c++ -Wall -Wno-unused -DMAKE_GOLDCD=NO -DWHACK -c -O2 -g -mgpopt -G32 -X0$18000
#OPT0 =  -comments-c++ -Wall -Wno-unused -DMAKE_GOLDCD=NO -DWHACK -c -O2 -g -mgpopt -G16 -X0$18000


# sony examples use 8-high for whatever reason (both are i-cache ok)
# the extra 8000 is only necessary for coverdisk demos

OPT =  -comments-c++ -Wall -Wno-unused -DMAKE_GOLDCD=NO -DWHACK -c -O2 -g -mgpopt -G32 -X0$80010000
OPT0 =  -comments-c++ -Wall -Wno-unused -DMAKE_GOLDCD=NO -DWHACK -c -O2 -g -mgpopt -G16 -X0$80010000

#
# DEFAULT BUILD RULES
#

.c.obj:							 
        ccpsx32 $(OPT) $&.c -o$&.obj
	dmpsx -b $&.obj			

#
# MAIN TARGET
#			   
	   
glover.cpe:     main.obj collide.obj object.obj poly.obj polya.obj \
         lscape.obj lscapea.obj quatern.obj texture.obj \
         variable.obj memory.obj utils.obj interupt.obj eff_draw.obj \
         ctrller.obj maths.obj video.obj incbins.obj water.obj  \
         camera.obj overlay.obj font.obj platform.obj \
         ball.obj hand.obj gameflow.obj puzzles.obj xa.obj fileio.obj \
         effects.obj menu.obj loadlnd.obj anim.obj \
         enemies.obj cameo.obj bff_load.obj sfx.obj card.obj \
         bosses.obj weather.obj debug.obj cacase.obj cheats.obj exc_c.obj exc_asm.obj
                        slink /psx /c /strip /nostriplib @glover.lnk,glover.cpe,glover.sym,glover.map
#                        psylink /l ..\..\lib.45 /n500 /m /c /g @glover.lnk,glover.cpe,glover.sym,glover.map
#			symmunge glover.sym

#
# SECONDARY TARGET - download and run
#

run: whack.cpe
	resetps /p
	run whack.cpe
	testmess

#
# SECONDARY TARGET - download and debug
#
debug: whack.cpe
	resetps /p
        dbugpsx whack /e


#
# GAME COMPONENTS
#

incbins.obj:	incbins.s
		asmpsx /zd /l incbins.s,incbins.obj

lscapea.obj:        lscape.s
        asmpsx /zd /l /g lscape.s,lscapea.obj
        dmpsx -b lscapea.obj

exc_asm.obj:        exc_asm.s
        asmpsx /zd /l /g exc_asm.s,exc_asm.obj
        dmpsx -b exc_asm.obj

polya.obj:        poly.s
        asmpsx /zd /l /g poly.s,polya.obj
        dmpsx -b polya.obj


collide.obj:    collide.c glover.h maths.h memory.h collide.h quatern.h object.h utils.h lscape.h ctrller.h utils.h main.h font.h 
        ccpsx32 $(OPT0) collide.c -ocollide.obj
        dmpsx -b collide.obj          


object.obj:     object.c glover.h texture.h poly.h quatern.h object.h memory.h  maths.h utils.h lscape.h loadlnd.h
poly.obj:               poly.c glover.h quatern.h texture.h poly.h object.h utils.h lscape.h 
lscape.obj:             lscape.c glover.h font.h quatern.h utils.h main.h poly.h object.h interupt.h memory.h lscape.h maths.h 
quatern.obj:	quatern.c glover.h quatern.h maths.h 
texture.obj:	texture.c glover.h memory.h maths.h font.h interupt.h texture.h utils.h main.h 
main.obj:               main.c glover.h interupt.h maths.h quatern.h object.h memory.h ctrller.h main.h texture.h utils.h camera.h texture.h overlay.h font.h lscape.h sound.h 
lights.obj:		lights.c glover.h quatern.h object.h texture.h utils.h lights.h 
utils.obj:		utils.c glover.h font.h maths.h utils.h 
interupt.obj:	interupt.c glover.h maths.h memory.h main.h quatern.h poly.h object.h ctrller.h font.h utils.h sound.h interupt.h 
memory.obj:		memory.c glover.h memory.h font.h ctrller.h font.h interupt.h 
maths.obj:		maths.c glover.h maths.h 
ctrller.obj:	ctrller.c glover.h ctrller.h 
maingame.obj:   maingame.c glover.h interupt.h memory.h ctrller.h maingame.h texture.h utils.h quatern.h object.h camera.h texture.h overlay.h font.h lights.h lscape.h maingame.h collide.h maths.h viewer.h effects.h texture.h
camera.obj:		camera.c glover.h quatern.h object.h utils.h ctrller.h maths.h font.h interupt.h texture.h memory.h effects.h collide.h camera.h 
overlay.obj:	overlay.c glover.h utils.h texture.h poly.h quatern.h object.h camera.h overlay.h memory.h 
font.obj:		font.c glover.h memory.h texture.h interupt.h font.h 
ball.obj:       ball.c glover.h glover.h interupt.h memory.h ctrller.h texture.h utils.h quatern.h object.h camera.h texture.h overlay.h lscape.h main.h collide.h maths.h camera.h effects.h viewer.h ball.h sound.h loadlnd.h
hand.obj:       hand.c glover.h hand.h interupt.h memory.h ctrller.h texture.h utils.h quatern.h object.h camera.h texture.h overlay.h lscape.h main.h collide.h maths.h camera.h effects.h viewer.h hand.h sound.h loadlnd.h
gameflow.obj:   gameflow.c glover.h glover.h interupt.h memory.h ctrller.h texture.h utils.h quatern.h object.h camera.h texture.h overlay.h lscape.h main.h collide.h maths.h camera.h effects.h viewer.h hand.h ball.h sound.h 
effects.obj:	effects.c glover.h maths.h quatern.h object.h interupt.h poly.h camera.h texture.h effects.h 
menu.obj:		menu.c glover.h
loadlnd.obj:	loadlnd.c glover.h
anim.obj:		anim.c glover.h
enemies.obj:	enemies.c glover.h
puzzles.obj:	glover.h object.h puzzles.h gameflow.h
platform.obj:	platform.h
xa.obj:         glover.h xa.h
video.obj:		glover.h video.h
cameo.obj:		glover.h cameo.h enemies.h
bff_load.obj:   bff_load.c glover.h bff_load.h
sfx.obj:        sfx.c glover.h sfx.h
card.obj:       card.c glover.h card.h
fileio.obj:     fileio.c glover.h fileio.h
eff_draw.obj:   eff_draw.c
variable.obj:   variable.c
water.obj:      water.c glover.h water.h loadlnd.h
bosses.obj:     bosses.c bosses.h enemies.h object.h
weather.obj:    weather.c weather.h glover.h
debug.obj:      debug.c debug.h
cacase.obj:     cacase.c cacase.h glover.h
cheats.obj:     cheats.c cheats.h glover.h
exc_c.obj:      glover.h exc.h

