#ifndef __H_MATHS
#define __H_MATHS

extern 	UBYTE randomtable[];
extern	UBYTE rndcnt;

LONG	random(ULONG size);
UBYTE	Seed_Random(LUBYTE rnd);
ULONG	fast_sqrt(ULONG num);
ULONG	Lfast_sqrt(double long num);
LONG	calc_angle(LONG adj,LONG opp);

ULONG	Ping_Pong(ULONG num,ULONG limit);



LONG arcsin(LONG sin);
LONG arccos(LONG cos);

extern	UBYTE	rndcnt;
extern	UBYTE 	randomtable[];
extern	ULONG 	sqrtable[];
extern	SHORT 	acostable[];

#define min(A,B) ((((LONG)A) <= ((LONG)B)) ? ((LONG)A) : ((LONG)B))
#define max(A,B) ((((LONG)A) >= ((LONG)B)) ? ((LONG)A) : ((LONG)B))

//USHORT	Ping_Pong(LUSHORT num,LUSHORT limit);
LONG	BOUND(LONG var,LONG lim);

#define SWAP(A,B,TMP) TMP=A;  A=B; B=TMP;

long absmax3(long a,long b,long c);
typedef struct {
	long vx, vy, vz;
}LVERT;
typedef struct {
	long x, y, z;
}LCOORD;


ULONG  	Size_Of_Poly(VERT *v0,VERT *v1,VERT *v2);
void	CalcInverseVector(VECTOR *vectscr,VECTOR *vectdest);

long	Magnitude(VECTOR *vect);
long	MagnitudeS(SVECTOR *v);
long	FindHeight(long a,long b);
long	DotProduct(VECTOR *v1, VECTOR *v2);
void	CrossProduct(VECTOR *result, VECTOR *operand1, VECTOR *operand2);
void	MakeUnit(VECTOR *vect);
void	MakeUnitS(SVECTOR *vect);
void	CalcBounce2(VECTOR *vel,VECTOR *normal);
void	CalcBounce(VECTOR *vel,VECTOR *normal);
void	AddToOneScaledVector(VECTOR *result,VECTOR *operand2,long scale2);
void	SetVector(VECTOR *v1,VECTOR *v2);
void	RotateVector2D(VECTOR *dest, VECTOR *source, LONG angle);
void	RotateVector2DXYZ(VECTOR *dest, VECTOR *source, LONG angle, BYTE axis);

#define LINKLISTINIT(A)		{   A.prev=A.next=&A; }

#define LINKLISTADD(A,B)	{ 	B.prev->next=A; \
								A->prev=B.prev; \
								A->next=&B;	  \
								B.prev=A;   }
#define LINKLISTSUB(A)		{   A->next->prev=A->prev; \
								A->prev->next=A->next; }


#define RANDOM256()			randomtable[rndcnt++]


#define ZeroVector(vect) {(vect)->vx=(vect)->vy=(vect)->vz=0;}
#define ZeroVector2D(vect) {((vect)->vx=(vect)->vy=0;}
#define Labs(A)  (((A)<0)?-(A):(A)) 
#define ABS(A)  (((A)<0)?-(A):(A)) 
#define ScaleVector(vect,scale){ 	(vect)->vx = ((vect)->vx*scale)/FRACTIONAL_DIV; \
									(vect)->vy = ((vect)->vy*scale)/FRACTIONAL_DIV; \
									(vect)->vz = ((vect)->vz*scale)/FRACTIONAL_DIV; }

#define SubVector(result,operand1,operand2) { 	((result)->vx) = ((operand1)->vx) - ((operand2)->vx); \
												((result)->vy) = ((operand1)->vy) - ((operand2)->vy); \
												((result)->vz) = ((operand1)->vz) - ((operand2)->vz);	}

#define AddVector(result,operand1,operand2) { 	((result)->vx) = ((operand1)->vx) + ((operand2)->vx); \
												((result)->vy) = ((operand1)->vy) + ((operand2)->vy); \
												((result)->vz) = ((operand1)->vz) + ((operand2)->vz);	}

#define AddToVector(result,operand)	{	(result)->vx += (operand)->vx; \
										(result)->vy += (operand)->vy; \
										(result)->vz += (operand)->vz; }
																


ULONG	AreaOfTriangle(VERT *sVert0, VERT *sVert1, VERT *sVert2);

//if you have a problem with MEMCPY (ie, with if statement, it must have {MEMCPY} around it,declare scr,dest & size, and use MEMCPY1)
//the if statement can be knocked out later 
#define FMEMCPY(DEST,SRC,SIZE)	{	{ \
									ULONG *qfsrc=(ULONG*)(SRC); \
									ULONG *qfdest=(ULONG*)(DEST); \
									LONG qfsize=(SIZE); \
								  	/*if (qfsize&3){printf("MEMCPY ERROR  SIZE NOT DIVISABLE BY 4!!!!!!!\n");VSync(0);}*/ \
									while (qfsize>0){ \
									*qfdest++=*qfsrc++; \
									qfsize-=4; \
									} \
									} \
								}

/*
//									LONG qfsize=(SIZE); \
// 	if (qfsize&3){printf("MEMCPY ERROR  SIZE NOT DIVISABLE BY 4!!!!!!!\n");VSync(0);} \
//									qfsize-=4; \

#define STRCPY(DEST,SRC)	{	{ \
									UBYTE *qfsrc=(UBYTE*)(SRC); \
									UBYTE *qfdest=(UBYTE*)(DEST); \
									while (*qfsrc!=0){ \
									*qfdest++=*qfsrc++; \
									} \
									*qfdest++=*qfsrc++; \
									} \
								}
*/
#define SETRGBC(A,R,G,B,C)	*(ULONG*)&A=(ULONG)((R)|(G<<8)|(B<<16)|(C<<24))
	


// --------------------------------------------------------------------------------------------------------------------
// Constants & Macros

#define RSIN0 0
#define RCOS0 4096

#define DEG		(57.29577951)
#define RAD		(0.017453292)

#define M_PI            3.14159265358979323846
#define PI				3.141592654
#define D3DPI			(3.141592654)

#define VECTORSUBTRACT(D, A,B)	{   (D).x = (A).x - (B).x; \
									(D).y = (A).y - (B).y; \
									(D).z = (A).z - (B).z; }

#define VECTORADD(D, A,B)		{   (D).x = (A).x + (B).x; \
									(D).y = (A).y + (B).y; \
									(D).z = (A).z + (B).z; }

#define VECTORMULTIPLY(D, A,B)	{   (D).x = (A).x * (B).x; \
									(D).y = (A).y * (B).y; \
									(D).z = (A).z * (B).z; }

#define VECTORDIVIDE(D, A,B)	{   (D).x = (A).x / (B).x; \
									(D).y = (A).y / (B).y; \
									(D).z = (A).z / (B).z; }

#define VECTORSUBTRACTX(D, A, X,Y,Z) {  (D).x = (A).x - (X); \
										(D).y = (A).y - (Y); \
										(D).z = (A).z - (Z); }

#define VECTORADDX(D, A, X,Y,Z)		 {  (D).x = (A).x + (X); \
										(D).y = (A).y + (Y); \
										(D).z = (A).z + (Z); }

#define VECTORMULTIPLYX(D, A, X,Y,Z) {  (D).x = (A).x * (X); \
										(D).y = (A).y * (Y); \
										(D).z = (A).z * (Z); }

#define VECTORDIVIDEX(D, A, X,Y,Z)   {  (D).x = (A).x / (X); \
										(D).y = (A).y / (Y); \
										(D).z = (A).z / (Z); }

#define VECTORDOT(A,B)  (((A).x*(B).x)+((A).y*(B).y)+((A).z*(B).z))

//--------------------------------------------------------------------------------------------------------------------

#define READ_LONG_FROM_ODD(A) (*A++)|((*A++)<<8)|((*A++)<<16)|((*A++)<<24)
#define LONGVALUE(A) 	((*(A+3)<<24) + (*(A+2)<<16) + (*(A+1)<<8) + *(A)) 
#define SHORTVALUE(A) 	((*(A+1)<<8) + *A) 
#define V3SUM(A,B,D)		{   (D).vx = (A).vx + (B).vx; \
								(D).vy = (A).vy + (B).vy; \
								(D).vz = (A).vz + (B).vz; }


// speed < 0 means "go there NOW"
// returns YES/NO for arrival
// (VectorMoveTo can now cope with large vectors & speed without overflowing)
int VectorMoveTo(VECTOR *src, VECTOR *dest, int speed);

int SVectorMoveTo(SVECTOR *src, SVECTOR *dest, int speed);


#endif